/*
 * Decompiled with CFR 0.152.
 */
package gui;

import gui.SeSimApplication;
import gui.util.ColorUtilsRGB;
import java.awt.Color;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.prefs.Preferences;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPopupMenu;
import javax.swing.UIManager;
import org.json.JSONArray;
import org.json.JSONObject;
import sesim.Config;
import sesim.Logger;
import sesim.Sim;

public class Globals {
    public static final String SESIM_FILEEXTENSION = "sesim";
    public static final Double SESIM_FILEVERSION = 0.1;
    public static final String SESIM_APPTITLE = "OpenSeSim - Stock Exchange Simulator";
    public static SeSimApplication theApp;
    public static Colors colors;
    static boolean lafInstalled;
    static ArrayList<CfgListener> cfg_listeners;
    public static JFrame frame;
    static final String DEVELSTATUS = "devel_status";
    public static final String GODMODE = "godmode";
    public static final String DATADIR = "datadir";
    public static Sim sim;
    public static Preferences prefs_new;
    public static final java.util.logging.Logger LOGGER;

    static void setLookAndFeel() {
        UIManager.LookAndFeelInfo[] lafInfo;
        if (!lafInstalled) {
            UIManager.installLookAndFeel("FlatLaf Light", "com.formdev.flatlaf.FlatLightLaf");
            UIManager.installLookAndFeel("FlatLaf Dark", "com.formdev.flatlaf.FlatDarkLaf");
            lafInstalled = true;
        }
        String selected = prefs_new.get("laf", "Nimbus");
        for (UIManager.LookAndFeelInfo lafInfo1 : lafInfo = UIManager.getInstalledLookAndFeels()) {
            if (!lafInfo1.getName().equals(selected)) continue;
            String lafClassName = lafInfo1.getClassName();
            try {
                UIManager.setLookAndFeel(lafClassName);
                break;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        JDialog.setDefaultLookAndFeelDecorated(prefs_new.getBoolean("laf_decorated_dialogs", true));
        JFrame.setDefaultLookAndFeelDecorated(prefs_new.getBoolean("laf_decorated_frames", true));
        JPopupMenu.setDefaultLightWeightPopupEnabled(prefs_new.getBoolean("laf_lightweight_popups", true));
        Globals.colors.tableRed = ColorUtilsRGB.readableRed(UIManager.getColor("Table.background"));
        Globals.colors.tableBgLightRed = ColorUtilsRGB.readable(new Color(255, 200, 200), UIManager.getColor("Table.foreground"));
        Globals.colors.tableGreen = ColorUtilsRGB.readableGreen(UIManager.getColor("Table.background"));
        Globals.colors.tableBgLightGreen = ColorUtilsRGB.readable(new Color(200, 255, 200), UIManager.getColor("Table.foreground"));
        Globals.colors.tableBgLightGray = ColorUtilsRGB.readable(new Color(220, 220, 220), UIManager.getColor("Table.foreground"));
        Globals.colors.bgLightYellow = ColorUtilsRGB.readable(new Color(255, 255, 200), UIManager.getColor("TextField.foreground"));
        Globals.colors.tableDarkGreen = ColorUtilsRGB.readable(new Color(0, 100, 0), UIManager.getColor("Table.background"));
        Globals.colors.bg = UIManager.getColor("TextField.background");
        Globals.colors.text = UIManager.getColor("TextField.foreground");
    }

    public static void notifyCfgListeners() {
        for (CfgListener l : cfg_listeners) {
            l.cfgChanged();
        }
    }

    public static void addCfgListener(CfgListener l) {
        cfg_listeners.add(l);
    }

    static void setLookAndFeel(String selected) {
        UIManager.LookAndFeelInfo[] lafInfo;
        for (UIManager.LookAndFeelInfo lafInfo1 : lafInfo = UIManager.getInstalledLookAndFeels()) {
            if (!lafInfo1.getName().equals(selected)) continue;
            String lafClassName = lafInfo1.getClassName();
            try {
                UIManager.setLookAndFeel(lafClassName);
                break;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static String getDataDir() {
        String dataDir = prefs_new.get(DATADIR, null);
        if (dataDir == null) {
            String userHome = System.getProperty("user.home", "");
            Path path = Paths.get(userHome, ".opensesim");
            dataDir = path.toString();
        }
        return dataDir;
    }

    public static String createDataDir() {
        String logDir = Globals.getDataDir();
        Path directoryPath = Paths.get(logDir, new String[0]);
        if (Files.notExists(directoryPath, new LinkOption[0])) {
            try {
                Files.createDirectories(directoryPath, new FileAttribute[0]);
            }
            catch (IOException e) {
                Logger.error("Creating data directory %s: %s", logDir, e.getMessage());
                return null;
            }
        }
        return logDir;
    }

    static void initGlobals() {
        String[] a = System.getProperty("java.class.path").split(System.getProperty("path.separator"));
        ArrayList<String> pathlist = new ArrayList<String>();
        String dp = new File(SeSimApplication.class.getProtectionDomain().getCodeSource().getLocation().getPath()).toString();
        pathlist.add(dp);
    }

    public static final JSONObject getStrategies() {
        JSONObject strategies = Config.getStrategies(Globals.getConfig());
        return strategies;
    }

    public static final JSONObject getConfig() {
        String dataDir = Globals.createDataDir();
        if (dataDir == null) {
            return new JSONObject();
        }
        String fileName = "current-config.sesim";
        File f = new File(dataDir, fileName);
        try {
            return Globals.loadConfigFromFile(f);
        }
        catch (IOException ex) {
            return new JSONObject();
        }
    }

    public static final void putConfig(JSONObject cfg) {
        String dataDir = Globals.createDataDir();
        if (dataDir == null) {
            return;
        }
        String fileName = "current-config.sesim";
        File f = new File(dataDir, fileName);
        try {
            Globals.saveFile(f, cfg);
        }
        catch (FileNotFoundException ex) {
            try {
                Logger.error("Saving file %s", f.getCanonicalPath());
            }
            catch (IOException ex1) {
                LOGGER.log(Level.SEVERE, null, ex1);
            }
        }
    }

    public static final void putStrategies(JSONObject strategies) {
        JSONObject sobj = Globals.getConfig();
        Config.putStrategies(sobj, strategies);
        Globals.putConfig(sobj);
    }

    public static final void putTraders(JSONArray traders) {
        JSONObject sobj = Globals.getConfig();
        Config.putTraders(sobj, traders);
        Globals.putConfig(sobj);
    }

    public static JSONObject getStrategy(String name) {
        return Globals.getStrategies().getJSONObject(name);
    }

    public static void getStrategiesIntoComboBox(JComboBox comboBox) {
        TreeMap stm = Globals.getStrategiesAsTreeMap();
        comboBox.removeAllItems();
        Iterator i = stm.keySet().iterator();
        while (i.hasNext()) {
            comboBox.addItem(i.next());
        }
    }

    public static TreeMap getStrategiesAsTreeMap() {
        TreeMap<String, JSONObject> strategies = new TreeMap<String, JSONObject>();
        JSONObject cfgs = Globals.getStrategies();
        Iterator<String> i = cfgs.keys();
        while (i.hasNext()) {
            String k = i.next();
            JSONObject o = cfgs.getJSONObject(k);
            strategies.put(k, o);
        }
        return strategies;
    }

    public static final void saveStrategy(String name, JSONObject cfg) {
        JSONObject cfgs = Globals.getStrategies();
        cfgs.put(name, cfg);
        Globals.putStrategies(cfgs);
    }

    public static void saveFile(File f, JSONObject sobj) throws FileNotFoundException {
        PrintWriter out = new PrintWriter(f.getAbsolutePath());
        out.print(sobj.toString(4));
        out.close();
    }

    public static JSONObject loadConfigFromString(String s) throws IOException {
        JSONObject sobj = new JSONObject(s);
        Double version = sobj.getDouble("version");
        if (version > SESIM_FILEVERSION) {
            throw new IOException("File has wrong version.");
        }
        return sobj;
    }

    public static JSONObject loadConfigFromFile(File f) throws IOException {
        f.getAbsoluteFile();
        String s = new String(Files.readAllBytes(f.toPath()));
        return Globals.loadConfigFromString(s);
    }

    public static void clearAll() {
        Globals.putStrategies(new JSONObject());
        Globals.putTraders(new JSONArray());
    }

    static {
        colors = new Colors();
        lafInstalled = false;
        cfg_listeners = new ArrayList();
        LOGGER = java.util.logging.Logger.getLogger("com.cauwersin.sesim");
    }

    public static class Colors {
        public Color tableRed = Color.RED;
        public Color tableGreen = Color.GREEN;
        public Color tableBgLightRed = Color.RED;
        public Color tableDarkGreen = new Color(0, 100, 0);
        public Color tableBgLightGreen = new Color(200, 255, 200);
        public Color tableBgLightGray = new Color(220, 220, 220);
        public Color red = Color.RED;
        public Color green = Color.GREEN;
        public Color bgLightYellow = Color.YELLOW;
        public Color bg = Color.WHITE;
        public Color text = Color.BLACK;
    }

    public static interface CfgListener {
        public void cfgChanged();
    }

    public static final class PrefKeys {
        public static String WORKDIR = "workdir";
        public static final String CURRENTFILE = "currentfile";
        public static final String SESIMVERSION = "version";
        public static final String CONFIG = "sesimconfig";
    }

    public static class CfgStrings {
        public static final String GODMODE = "godmode";
    }
}

