/*
 * Decompiled with CFR 0.152.
 */
package gui;

import gui.EscDialog;
import gui.Globals;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import sesim.AutoTrader;

public class NewStrategyDialog
extends EscDialog {
    transient Result result = null;
    private JComboBox<Result> baseComboBox;
    private JLabel baseText;
    private JButton cancelButton;
    private JTextField nameInput;
    private JLabel nameText;
    private JButton okButton;

    public NewStrategyDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        boolean devel = Globals.prefs_new.get("devel_status", "false").equals("true");
        ArrayList<String> names = Globals.sim.tloader.getDefaultStrategyNames(devel);
        this.baseComboBox.removeAllItems();
        for (String name : names) {
            AutoTrader ac = Globals.sim.tloader.getStrategyBase(name);
            Result r = new Result();
            r.base = name;
            r.displayName = ac.getDisplayName() + (ac.getDevelStatus() ? "  (Experimenatl)" : "");
            this.baseComboBox.addItem(r);
        }
    }

    public NewStrategyDialog(Frame parent, boolean modal, String base) {
        this(parent, modal);
        for (int i = 0; i < this.baseComboBox.getItemCount(); ++i) {
            Result r = this.baseComboBox.getItemAt(i);
            if (!r.base.equals(base)) continue;
            this.baseComboBox.setSelectedIndex(i);
            break;
        }
        this.baseComboBox.setEnabled(false);
    }

    private void saveResult() {
        String name = this.nameInput.getText();
        if (name.equals("")) {
            return;
        }
        this.result = (Result)this.baseComboBox.getSelectedItem();
        this.result.name = name;
        this.dispose();
    }

    private void initComponents() {
        this.baseComboBox = new JComboBox();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.baseText = new JLabel();
        this.nameInput = new JTextField();
        this.nameText = new JLabel();
        this.setDefaultCloseOperation(2);
        this.setTitle("Create Strategy");
        this.baseComboBox.setModel(new DefaultComboBoxModel());
        this.okButton.setText("Ok");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NewStrategyDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.cancelButton.setMnemonic('c');
        this.cancelButton.setText("Cancel");
        this.cancelButton.setToolTipText("");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NewStrategyDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.baseText.setText("Base:");
        this.nameInput.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                NewStrategyDialog.this.nameInputActionPerformed(evt);
            }
        });
        this.nameText.setText("Name:");
        GroupLayout layout2 = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout2);
        layout2.setHorizontalGroup(layout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout2.createSequentialGroup().addContainerGap().addGroup(layout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout2.createSequentialGroup().addGap(0, 268, Short.MAX_VALUE).addComponent(this.okButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cancelButton)).addGroup(layout2.createSequentialGroup().addGroup(layout2.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.baseText).addComponent(this.nameText)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout2.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.baseComboBox, 0, -1, Short.MAX_VALUE).addComponent(this.nameInput)))).addContainerGap()));
        layout2.setVerticalGroup(layout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout2.createSequentialGroup().addContainerGap().addGroup(layout2.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.baseComboBox, -2, -1, -2).addComponent(this.baseText)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout2.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.nameInput, -2, -1, -2).addComponent(this.nameText)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 23, Short.MAX_VALUE).addGroup(layout2.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.okButton).addComponent(this.cancelButton)).addContainerGap()));
        this.pack();
    }

    private void nameInputActionPerformed(ActionEvent evt) {
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        this.saveResult();
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.result = null;
        this.dispose();
    }

    class Result {
        public String displayName;
        public String base;
        public String name;

        Result() {
        }

        public String toString() {
            return this.displayName;
        }
    }
}

