/*
 * Decompiled with CFR 0.152.
 */
package gui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.Map;
import javax.swing.GroupLayout;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableModel;
import sesim.Order;

public class OpenOrdersList
extends JPanel {
    DefaultTableModel model;
    private Map list = null;
    private JPopupMenu ctxMenu;
    private JMenuItem ctxMenuCancelOrder;
    private JMenuItem ctxMenuCreateBuyOrder;
    private JMenuItem ctxMenuCreateSellOrder;
    private JMenuItem ctxMenuModifyOder;
    private JScrollPane jScrollPane1;
    public JTable table;

    public final void updateModel() {
        if (this.list == null) {
            return;
        }
        Iterator it = this.list.entrySet().iterator();
        this.model.setRowCount(this.list.size());
        int row = 0;
        while (it.hasNext()) {
            Map.Entry e = it.next();
            Long k = (Long)e.getKey();
            Order o = (Order)e.getValue();
            this.model.setValueAt(k, row, 0);
            this.model.setValueAt(o.getTypeAsString(), row, 1);
            this.model.setValueAt(o.getInitialVolume(), row, 2);
            if (o.hasLimit()) {
                this.model.setValueAt(o.getLimit(), row, 3);
            } else {
                this.model.setValueAt(null, row, 3);
            }
            if (o.hasStop()) {
                this.model.setValueAt(o.getStop(), row, 4);
            } else {
                this.model.setValueAt(null, row, 4);
            }
            this.model.setValueAt(o.getExecuted(), row, 5);
            double av = o.getAveragePrice();
            if (av < 0.0) {
                this.model.setValueAt(null, row, 6);
            } else {
                this.model.setValueAt(av, row, 6);
            }
            this.model.setValueAt(o.getStatusString(), row, 7);
            ++row;
        }
        this.table.getRowSorter().allRowsChanged();
    }

    public OpenOrdersList() {
        this.initComponents();
        if (this.table == null) {
            return;
        }
        this.model = (DefaultTableModel)this.table.getModel();
        this.model.setRowCount(0);
        this.table.setFillsViewportHeight(true);
    }

    public void setOrderList(Map m) {
        this.list = m;
        SwingUtilities.invokeLater(this::updateModel);
    }

    private void initComponents() {
        this.ctxMenu = new JPopupMenu();
        this.ctxMenuCreateBuyOrder = new JMenuItem();
        this.ctxMenuCreateSellOrder = new JMenuItem();
        this.ctxMenuCancelOrder = new JMenuItem();
        this.ctxMenuModifyOder = new JMenuItem();
        this.jScrollPane1 = new JScrollPane();
        this.table = new JTable();
        this.ctxMenuCreateBuyOrder.setText("Create Buy Order");
        this.ctxMenuCreateBuyOrder.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OpenOrdersList.this.ctxMenuCreateBuyOrderActionPerformed(evt);
            }
        });
        this.ctxMenu.add(this.ctxMenuCreateBuyOrder);
        this.ctxMenuCreateSellOrder.setText("Create Sell Order");
        this.ctxMenuCreateSellOrder.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OpenOrdersList.this.ctxMenuCreateSellOrderActionPerformed(evt);
            }
        });
        this.ctxMenu.add(this.ctxMenuCreateSellOrder);
        this.ctxMenuCancelOrder.setText("Cancel Order");
        this.ctxMenuCancelOrder.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OpenOrdersList.this.ctxMenuCancelOrderActionPerformed(evt);
            }
        });
        this.ctxMenu.add(this.ctxMenuCancelOrder);
        this.ctxMenuModifyOder.setText("Modify Oder");
        this.ctxMenu.add(this.ctxMenuModifyOder);
        this.table.setAutoCreateRowSorter(true);
        this.table.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null, null, null, null, null}, {null, null, null, null, null, null, null, null}, {null, null, null, null, null, null, null, null}}, new String[]{"ID", "Type", "Volume", "Limit", "Stop", "Vol. Executed", "Av. Price", "Status"}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{Long.class, String.class, Double.class, Double.class, Double.class, Double.class, Double.class, String.class};
                this.canEdit = new boolean[]{false, false, false, false, false, false, false, false};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.table.setSelectionMode(0);
        this.jScrollPane1.setViewportView(this.table);
        if (this.table.getColumnModel().getColumnCount() > 0) {
            this.table.getColumnModel().getColumn(0).setPreferredWidth(80);
        }
        GroupLayout layout2 = new GroupLayout(this);
        this.setLayout(layout2);
        layout2.setHorizontalGroup(layout2.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, GroupLayout.Alignment.TRAILING, -1, 595, Short.MAX_VALUE));
        layout2.setVerticalGroup(layout2.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, -1, 125, Short.MAX_VALUE));
    }

    private void createOrder(byte t) {
    }

    private void ctxMenuCreateSellOrderActionPerformed(ActionEvent evt) {
        this.createOrder((byte)3);
    }

    private void ctxMenuCreateBuyOrderActionPerformed(ActionEvent evt) {
        this.createOrder((byte)2);
    }

    private void ctxMenuCancelOrderActionPerformed(ActionEvent evt) {
        int r = this.table.getSelectedRow();
        Long id = (Long)this.model.getValueAt(r, 0);
    }
}

