/*
 * Decompiled with CFR 0.152.
 */
package gui;

import gui.Globals;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JSpinner;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import org.json.JSONObject;
import sesim.Config;

public class RandomSeedDialog
extends JDialog {
    private static final Logger logger = Logger.getLogger(RandomSeedDialog.class.getName());
    private JButton cancelButton;
    private JButton okButton;
    private JSpinner seed;
    private JCheckBox useSeed;

    public RandomSeedDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.setTitle("Random Seed");
        this.setLocationRelativeTo(this.getParent());
        this.setConfig();
    }

    private void setConfig() {
        JSONObject cfg = Globals.getConfig();
        boolean us = Config.getUseRandomSeed(cfg);
        long s = Config.getRandomSeed(cfg);
        this.seed.setValue(s);
        this.useSeed.setSelected(us);
        this.seed.setEnabled(us);
    }

    void save() {
        JSONObject cfg = Globals.getConfig();
        JSONObject rand = Config.getRandomCfg(cfg);
        rand.put("use_seed", this.useSeed.isSelected());
        rand.put("seed", (Long)this.seed.getValue());
        cfg.put("random", rand);
        Globals.putConfig(cfg);
    }

    private void initComponents() {
        this.useSeed = new JCheckBox();
        this.cancelButton = new JButton();
        this.okButton = new JButton();
        this.seed = new JSpinner();
        this.setDefaultCloseOperation(2);
        this.useSeed.setText("Use Random Seed:");
        this.useSeed.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RandomSeedDialog.this.useSeedActionPerformed(evt);
            }
        });
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RandomSeedDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.okButton.setText("Ok");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RandomSeedDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.seed.setModel(new SpinnerNumberModel((Number)0L, null, null, (Number)1L));
        GroupLayout layout2 = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout2);
        layout2.setHorizontalGroup(layout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout2.createSequentialGroup().addContainerGap().addGroup(layout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout2.createSequentialGroup().addComponent(this.useSeed).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.seed, -1, 201, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, layout2.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.okButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cancelButton))).addContainerGap()));
        layout2.setVerticalGroup(layout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout2.createSequentialGroup().addGap(7, 7, 7).addGroup(layout2.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.useSeed).addComponent(this.seed, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 25, Short.MAX_VALUE).addGroup(layout2.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cancelButton).addComponent(this.okButton)).addContainerGap()));
        this.pack();
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void useSeedActionPerformed(ActionEvent evt) {
        this.seed.setEnabled(this.useSeed.isSelected());
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        this.save();
        this.dispose();
    }

    public static void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ReflectiveOperationException | UnsupportedLookAndFeelException ex) {
            logger.log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                RandomSeedDialog dialog = new RandomSeedDialog((Frame)new JFrame(), true);
                dialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }
}

