/*
 * Decompiled with CFR 0.152.
 */
package gui;

import chart.ChartPanel;
import gui.AboutDialog;
import gui.AccelerationPanel;
import gui.AssetEditor.AssetListDialog;
import gui.BreakPoints.BreakPointsDialog;
import gui.Clock;
import gui.CustomHelpHandler;
import gui.EditAutoTraderListDialog;
import gui.EditPreferencesDialog;
import gui.EditStrategiesDialog;
import gui.Globals;
import gui.LogDialog;
import gui.RandomSeedDialog;
import gui.RawOrderBookDialog;
import gui.Statistics;
import gui.TraderListDialog;
import gui.TraderListPanel;
import gui.TradingLogDialog;
import gui.orderbook.OrderBooksHorizontal;
import gui.orderbook.QuoteVertical;
import gui.orderbook.RawOrderBook;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Scanner;
import java.util.logging.ConsoleHandler;
import java.util.logging.Level;
import java.util.logging.SimpleFormatter;
import java.util.prefs.Preferences;
import javax.help.HelpBroker;
import javax.help.HelpSet;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.json.JSONObject;
import sesim.AppHelp;
import sesim.Logger;
import sesim.Sim;

public class SeSimApplication
extends JFrame {
    RawOrderBookDialog rawOrderBookDialog = null;
    RawOrderBookDialog stopOrderBookDialog = null;
    RawOrderBookDialog unlimitedOrdersDialog = null;
    LogDialog logDialog;
    String logFileName = null;
    TradingLogDialog tradingLogDialog = null;
    static boolean f = false;
    private JMenuItem aboutMenuItem;
    private AccelerationPanel accelerationPanel1;
    private ChartPanel chartPanel;
    private JMenuItem clearMenuItem;
    private Clock clock;
    private Clock clock1;
    private JMenuItem closeMenuItem;
    private JMenuItem deleteMenuItem;
    private JMenu editMenu;
    private JMenuItem editPreferences;
    private JMenuItem exitMenuItem;
    private JMenu fileMenu;
    private JMenuItem fileOpenMenuItem;
    private JMenuItem fileSaveAsMenuItem;
    private JMenuItem fileSaveMenuItem;
    private JMenu helpMenu;
    private JMenuItem jMenuItem2;
    private JPanel jPanel2;
    private JScrollPane jScrollPane2;
    private JPopupMenu.Separator jSeparator2;
    private JPopupMenu.Separator jSeparator3;
    private JPopupMenu.Separator jSeparator4;
    private JPopupMenu.Separator jSeparator5;
    private JPopupMenu.Separator jSeparator6;
    private JSplitPane jSplitPane1;
    private JSplitPane jSplitPane2;
    private JSplitPane jSplitPane3;
    private JSplitPane jSplitPane4;
    private JSplitPane jSplitPane5;
    private JTextArea jTextArea1;
    private JMenuItem marketsMenuItem;
    private JToolBar meinToolBar;
    private JMenuBar menuBar;
    private RawOrderBook orderBookNew1;
    private OrderBooksHorizontal orderBooksHorizontal;
    private JMenuItem pasteMenuItem;
    private JButton pauseButton;
    private QuoteVertical quoteVertical1;
    private JMenuItem randomSeed;
    private JMenuItem resetToDefaultsMenuItem;
    private JButton runButton;
    private JPanel runControls;
    private JMenu simMenu;
    private JMenuItem simMenuPause;
    private JMenuItem simMenuStart;
    private JMenuItem simMenuStop;
    private Statistics statistics1;
    private JButton stopButton;
    private TraderListPanel traderListPanel;
    private JCheckBox tradingLogCheckBox;
    private JCheckBoxMenuItem viewLog;
    private JMenu viewMenu;
    private JCheckBoxMenuItem viewRawOrderBook;
    private JCheckBoxMenuItem viewStopOrders;
    private JCheckBoxMenuItem viewTraderListCheckBox;
    private JCheckBoxMenuItem viewTradingLog;
    private JCheckBoxMenuItem viewUnlimitedOrdes;

    public SeSimApplication() {
        GraphicsDevice[] screens;
        this.initComponents();
        Globals.theApp = this;
        ToolTipManager.sharedInstance().setInitialDelay(200);
        ToolTipManager.sharedInstance().setDismissDelay(50000);
        ToolTipManager.sharedInstance().setReshowDelay(200);
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        for (GraphicsDevice graphicsDevice : screens = ge.getScreenDevices()) {
        }
        this.initSim();
        this.setTitle("");
        boolean init = Globals.prefs_new.getBoolean("initilized", false);
        if (!init) {
            this.resetToDefaults();
            Globals.prefs_new.putBoolean("initilized", true);
        }
        if (this.logDialog == null) {
            this.logDialog = new LogDialog((Frame)this, false);
            this.logDialog.setLocationRelativeTo(this);
        }
        this.logDialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                super.windowClosing(e);
                SeSimApplication.this.viewLog.setState(false);
                SeSimApplication.this.logDialog.setVisible(false);
            }
        });
        this.logDialog.getRootPane().registerKeyboardAction(e -> this.logDialog.dispatchEvent(new WindowEvent(this.logDialog, 201)), KeyStroke.getKeyStroke(27, 0), 2);
        HelpBroker hb = AppHelp.getHelpBroker();
        HelpSet hs = AppHelp.getHelpSet();
        CustomHelpHandler.installHelp(this, hs);
        this.meinToolBar.setFloatable(false);
    }

    public void acceptBreakPoint(Long time) {
        this.pauseSim();
    }

    private void initComponents() {
        this.jScrollPane2 = new JScrollPane();
        this.jTextArea1 = new JTextArea();
        this.jSplitPane1 = new JSplitPane();
        this.jSplitPane2 = new JSplitPane();
        this.orderBookNew1 = new RawOrderBook();
        this.meinToolBar = new JToolBar();
        this.jPanel2 = new JPanel();
        this.clock = new Clock();
        this.runControls = new JPanel();
        this.stopButton = new JButton();
        this.pauseButton = new JButton();
        this.runButton = new JButton();
        this.accelerationPanel1 = new AccelerationPanel();
        this.tradingLogCheckBox = new JCheckBox();
        this.jSplitPane3 = new JSplitPane();
        this.jSplitPane4 = new JSplitPane();
        this.orderBooksHorizontal = new OrderBooksHorizontal();
        this.chartPanel = new ChartPanel();
        this.quoteVertical1 = new QuoteVertical();
        this.jSplitPane5 = new JSplitPane();
        this.statistics1 = new Statistics();
        this.clock1 = new Clock();
        this.traderListPanel = new TraderListPanel(this, new TraderListPanel.Column[]{TraderListPanel.Column.NAME, TraderListPanel.Column.STATUS, TraderListPanel.Column.SHARES, TraderListPanel.Column.CASH, TraderListPanel.Column.PNL});
        this.menuBar = new JMenuBar();
        this.fileMenu = new JMenu();
        this.fileOpenMenuItem = new JMenuItem();
        this.fileSaveMenuItem = new JMenuItem();
        this.fileSaveAsMenuItem = new JMenuItem();
        this.closeMenuItem = new JMenuItem();
        this.jSeparator5 = new JPopupMenu.Separator();
        this.resetToDefaultsMenuItem = new JMenuItem();
        this.clearMenuItem = new JMenuItem();
        this.jSeparator4 = new JPopupMenu.Separator();
        this.exitMenuItem = new JMenuItem();
        this.editMenu = new JMenu();
        this.marketsMenuItem = new JMenuItem();
        this.pasteMenuItem = new JMenuItem();
        this.deleteMenuItem = new JMenuItem();
        this.jSeparator2 = new JPopupMenu.Separator();
        this.jMenuItem2 = new JMenuItem();
        this.jSeparator6 = new JPopupMenu.Separator();
        this.editPreferences = new JMenuItem();
        this.simMenu = new JMenu();
        this.simMenuStart = new JMenuItem();
        this.simMenuPause = new JMenuItem();
        this.simMenuStop = new JMenuItem();
        this.jSeparator3 = new JPopupMenu.Separator();
        this.randomSeed = new JMenuItem();
        this.viewMenu = new JMenu();
        this.viewTraderListCheckBox = new JCheckBoxMenuItem();
        this.viewRawOrderBook = new JCheckBoxMenuItem();
        this.viewUnlimitedOrdes = new JCheckBoxMenuItem();
        this.viewStopOrders = new JCheckBoxMenuItem();
        this.viewLog = new JCheckBoxMenuItem();
        this.viewTradingLog = new JCheckBoxMenuItem();
        this.helpMenu = new JMenu();
        this.aboutMenuItem = new JMenuItem();
        this.jTextArea1.setColumns(20);
        this.jTextArea1.setRows(5);
        this.jTextArea1.setText("Hakke");
        this.jScrollPane2.setViewportView(this.jTextArea1);
        this.jSplitPane1.setOrientation(0);
        this.jSplitPane2.setLeftComponent(this.orderBookNew1);
        this.jSplitPane1.setTopComponent(this.jSplitPane2);
        this.meinToolBar.setRollover(true);
        this.setDefaultCloseOperation(3);
        this.setTitle("SeSim - Stock Exchange Simmulator");
        this.setMinimumSize(new Dimension(640, 480));
        this.setPreferredSize(new Dimension(1024, 768));
        this.stopButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/stop.gif")));
        this.stopButton.setText("Stop");
        this.stopButton.setToolTipText("Stop the simulation!");
        this.stopButton.setHorizontalTextPosition(0);
        this.stopButton.setVerticalTextPosition(3);
        this.stopButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SeSimApplication.this.stopButtonActionPerformed(evt);
            }
        });
        this.pauseButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/pause.gif")));
        this.pauseButton.setText("Pause");
        this.pauseButton.setToolTipText("Pause simulation");
        this.pauseButton.setHorizontalTextPosition(0);
        this.pauseButton.setVerticalTextPosition(3);
        this.pauseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SeSimApplication.this.pauseButtonActionPerformed(evt);
            }
        });
        this.runButton.setFont(this.runButton.getFont());
        this.runButton.setIcon(new ImageIcon(this.getClass().getResource("/icons/run.gif")));
        this.runButton.setText("Run sim!");
        this.runButton.setToolTipText("Run the simmulation");
        this.runButton.setHorizontalTextPosition(0);
        this.runButton.setVerticalTextPosition(3);
        this.runButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SeSimApplication.this.runButtonActionPerformed(evt);
            }
        });
        GroupLayout runControlsLayout = new GroupLayout(this.runControls);
        this.runControls.setLayout(runControlsLayout);
        runControlsLayout.setHorizontalGroup(runControlsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(runControlsLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.runButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.pauseButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.stopButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.accelerationPanel1, -2, -1, -2).addGap(27, 27, 27)));
        runControlsLayout.setVerticalGroup(runControlsLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.stopButton, GroupLayout.Alignment.LEADING).addComponent(this.pauseButton, GroupLayout.Alignment.LEADING).addComponent(this.runButton, GroupLayout.Alignment.LEADING).addComponent(this.accelerationPanel1, GroupLayout.Alignment.LEADING, -2, -1, -2));
        this.tradingLogCheckBox.setText("Trading Log");
        this.tradingLogCheckBox.setToolTipText("<html>\nIf checked, a log of all created orders,<br>\ntransactions between traders, and additional details<br>\nwill be written to disk. You can analyze these details later.<br>\n<font color='red'>ATTENTION:<br>\nTurning this option on will write a large amount of data<br>\nto your disk. You may run out of disk space.</font>\n</html>");
        this.tradingLogCheckBox.setHorizontalTextPosition(10);
        this.tradingLogCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SeSimApplication.this.tradingLogCheckBoxActionPerformed(evt);
            }
        });
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.runControls, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 56, Short.MAX_VALUE).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.tradingLogCheckBox, GroupLayout.Alignment.TRAILING).addComponent(this.clock, GroupLayout.Alignment.TRAILING, -2, 122, -2)).addContainerGap()));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.tradingLogCheckBox).addComponent(this.runControls, -2, -1, -2)).addComponent(this.clock, -2, 29, -2)).addGap(0, 10, Short.MAX_VALUE)));
        this.getContentPane().add((Component)this.jPanel2, "First");
        this.jSplitPane4.setDividerLocation(300);
        this.jSplitPane4.setOrientation(0);
        this.jSplitPane4.setRightComponent(this.orderBooksHorizontal);
        this.jSplitPane4.setLeftComponent(this.chartPanel);
        this.jSplitPane3.setRightComponent(this.jSplitPane4);
        this.jSplitPane3.setLeftComponent(this.quoteVertical1);
        this.jSplitPane5.setOrientation(0);
        this.jSplitPane5.setTopComponent(this.statistics1);
        this.jSplitPane5.setRightComponent(this.clock1);
        this.jSplitPane5.setRightComponent(this.traderListPanel);
        this.jSplitPane3.setLeftComponent(this.jSplitPane5);
        this.getContentPane().add((Component)this.jSplitPane3, "Center");
        this.fileMenu.setMnemonic('f');
        this.fileMenu.setText("File");
        this.fileOpenMenuItem.setAccelerator(KeyStroke.getKeyStroke(79, 128));
        this.fileOpenMenuItem.setMnemonic('o');
        this.fileOpenMenuItem.setText("Open");
        this.fileOpenMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SeSimApplication.this.fileOpenMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.fileOpenMenuItem);
        this.fileSaveMenuItem.setAccelerator(KeyStroke.getKeyStroke(83, 128));
        this.fileSaveMenuItem.setMnemonic('s');
        this.fileSaveMenuItem.setText("Save");
        this.fileSaveMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SeSimApplication.this.fileSaveMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.fileSaveMenuItem);
        this.fileSaveAsMenuItem.setMnemonic('a');
        this.fileSaveAsMenuItem.setText("Save As ...");
        this.fileSaveAsMenuItem.setDisplayedMnemonicIndex(5);
        this.fileSaveAsMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SeSimApplication.this.fileSaveAsMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.fileSaveAsMenuItem);
        this.closeMenuItem.setMnemonic('c');
        this.closeMenuItem.setText("Close");
        this.closeMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SeSimApplication.this.closeMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.closeMenuItem);
        this.fileMenu.add(this.jSeparator5);
        this.resetToDefaultsMenuItem.setMnemonic('r');
        this.resetToDefaultsMenuItem.setText("Reset to defaults");
        this.resetToDefaultsMenuItem.setToolTipText("");
        this.resetToDefaultsMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SeSimApplication.this.resetToDefaultsMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.resetToDefaultsMenuItem);
        this.clearMenuItem.setMnemonic('c');
        this.clearMenuItem.setText("Clear All");
        this.clearMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SeSimApplication.this.clearMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.clearMenuItem);
        this.fileMenu.add(this.jSeparator4);
        this.exitMenuItem.setAccelerator(KeyStroke.getKeyStroke(81, 128));
        this.exitMenuItem.setMnemonic('x');
        this.exitMenuItem.setText("Exit");
        this.exitMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SeSimApplication.this.exitMenuItemActionPerformed(evt);
            }
        });
        this.fileMenu.add(this.exitMenuItem);
        this.menuBar.add(this.fileMenu);
        this.editMenu.setMnemonic('e');
        this.editMenu.setText("Edit");
        this.marketsMenuItem.setText("Markets");
        this.marketsMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SeSimApplication.this.marketsMenuItemActionPerformed(evt);
            }
        });
        this.editMenu.add(this.marketsMenuItem);
        this.pasteMenuItem.setMnemonic('s');
        this.pasteMenuItem.setText("Strategies ...");
        this.pasteMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SeSimApplication.this.pasteMenuItemActionPerformed(evt);
            }
        });
        this.editMenu.add(this.pasteMenuItem);
        this.deleteMenuItem.setMnemonic('d');
        this.deleteMenuItem.setText("Traders ...");
        this.deleteMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SeSimApplication.this.deleteMenuItemActionPerformed(evt);
            }
        });
        this.editMenu.add(this.deleteMenuItem);
        this.editMenu.add(this.jSeparator2);
        this.jMenuItem2.setText("BreakPoints");
        this.jMenuItem2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SeSimApplication.this.jMenuItem2ActionPerformed(evt);
            }
        });
        this.editMenu.add(this.jMenuItem2);
        this.editMenu.add(this.jSeparator6);
        this.editPreferences.setMnemonic('p');
        this.editPreferences.setText("Preferences ...");
        this.editPreferences.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SeSimApplication.this.editPreferencesActionPerformed(evt);
            }
        });
        this.editMenu.add(this.editPreferences);
        this.menuBar.add(this.editMenu);
        this.simMenu.setMnemonic('s');
        this.simMenu.setText("Sim");
        this.simMenuStart.setMnemonic('s');
        this.simMenuStart.setText("Start");
        this.simMenuStart.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SeSimApplication.this.simMenuStartActionPerformed(evt);
            }
        });
        this.simMenu.add(this.simMenuStart);
        this.simMenuPause.setMnemonic('p');
        this.simMenuPause.setText("Pause");
        this.simMenuPause.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SeSimApplication.this.simMenuPauseActionPerformed(evt);
            }
        });
        this.simMenu.add(this.simMenuPause);
        this.simMenuStop.setMnemonic('t');
        this.simMenuStop.setText("Stop");
        this.simMenuStop.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SeSimApplication.this.simMenuStopActionPerformed(evt);
            }
        });
        this.simMenu.add(this.simMenuStop);
        this.simMenu.add(this.jSeparator3);
        this.randomSeed.setText("Random seed");
        this.randomSeed.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SeSimApplication.this.randomSeedActionPerformed(evt);
            }
        });
        this.simMenu.add(this.randomSeed);
        this.menuBar.add(this.simMenu);
        this.viewMenu.setMnemonic('v');
        this.viewMenu.setText("View");
        this.viewTraderListCheckBox.setAccelerator(KeyStroke.getKeyStroke(84, 0));
        this.viewTraderListCheckBox.setMnemonic('t');
        this.viewTraderListCheckBox.setText("Traders");
        this.viewTraderListCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SeSimApplication.this.viewTraderListCheckBoxActionPerformed(evt);
            }
        });
        this.viewMenu.add(this.viewTraderListCheckBox);
        this.viewRawOrderBook.setAccelerator(KeyStroke.getKeyStroke(51, 0));
        this.viewRawOrderBook.setMnemonic('R');
        this.viewRawOrderBook.setText("Level 3 Orde Book");
        this.viewRawOrderBook.setToolTipText("");
        this.viewRawOrderBook.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SeSimApplication.this.viewRawOrderBookActionPerformed(evt);
            }
        });
        this.viewMenu.add(this.viewRawOrderBook);
        this.viewUnlimitedOrdes.setAccelerator(KeyStroke.getKeyStroke(77, 0));
        this.viewUnlimitedOrdes.setText("Market Orders View");
        this.viewUnlimitedOrdes.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SeSimApplication.this.viewUnlimitedOrdesActionPerformed(evt);
            }
        });
        this.viewMenu.add(this.viewUnlimitedOrdes);
        this.viewStopOrders.setAccelerator(KeyStroke.getKeyStroke(83, 0));
        this.viewStopOrders.setText("Stop Orders View");
        this.viewStopOrders.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SeSimApplication.this.viewStopOrdersActionPerformed(evt);
            }
        });
        this.viewMenu.add(this.viewStopOrders);
        this.viewLog.setAccelerator(KeyStroke.getKeyStroke(76, 0));
        this.viewLog.setText("Log Window");
        this.viewLog.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SeSimApplication.this.viewLogActionPerformed(evt);
            }
        });
        this.viewMenu.add(this.viewLog);
        this.viewTradingLog.setText("Trading Log");
        this.viewTradingLog.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SeSimApplication.this.viewTradingLogActionPerformed(evt);
            }
        });
        this.viewMenu.add(this.viewTradingLog);
        this.menuBar.add(this.viewMenu);
        this.helpMenu.setMnemonic('h');
        this.helpMenu.setText("Help");
        this.aboutMenuItem.setMnemonic('a');
        this.aboutMenuItem.setText("About");
        this.aboutMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SeSimApplication.this.aboutMenuItemActionPerformed(evt);
            }
        });
        this.helpMenu.add(this.aboutMenuItem);
        this.menuBar.add(this.helpMenu);
        this.setJMenuBar(this.menuBar);
        this.pack();
    }

    private void exitMenuItemActionPerformed(ActionEvent evt) {
        System.exit(0);
    }

    private void aboutMenuItemActionPerformed(ActionEvent evt) {
        AboutDialog d = new AboutDialog((Frame)this, this.rootPaneCheckingEnabled);
        d.setVisible(this.rootPaneCheckingEnabled);
    }

    void pauseSim() {
        if (Globals.sim.getPause()) {
            this.runButton.setEnabled(false);
            this.pauseButton.setEnabled(true);
            Globals.sim.setPause(false);
        } else {
            this.runButton.setEnabled(true);
            this.pauseButton.setEnabled(false);
            Globals.sim.setPause(true);
        }
    }

    void startSim() {
        if (Globals.sim.getPause()) {
            this.pauseSim();
            return;
        }
        this.runButton.setEnabled(false);
        this.stopButton.setEnabled(true);
        Globals.sim.reset();
        Globals.sim.startTraders(Globals.getConfig());
        this.setTradingLogFile();
        try {
            Globals.sim.getDefaultMarket().setTradingLog(this.tradingLogCheckBox.isSelected());
        }
        catch (FileNotFoundException ex) {
            Logger.error("Cannot write log %s: %s", this.logFileName, ex.getMessage());
            this.tradingLogCheckBox.setSelected(false);
        }
        Globals.sim.setPause(false);
        Globals.sim.startScheduler();
        this.accelerationPanel1.initAcceleration();
        Globals.sim.setAcceleration((Double)this.accelerationPanel1.accelSpinner.getValue());
        this.chartPanel.reset();
        if (this.rawOrderBookDialog != null) {
            this.rawOrderBookDialog.start(Globals.sim.getDefaultMarket(), (byte)2, (byte)3);
        }
        this.orderBooksHorizontal.start();
        this.stopButton.setEnabled(true);
        this.pauseButton.setEnabled(true);
        this.orderBooksHorizontal.invalidate();
        this.orderBooksHorizontal.repaint();
        this.clock.invalidate();
        this.clock.repaint();
        this.chartPanel.reset();
        this.clock.invalidate();
        this.clock.repaint();
    }

    void stopSim() {
        Globals.sim.stop();
        this.stopButton.setEnabled(false);
        this.pauseButton.setEnabled(false);
        this.runButton.setEnabled(true);
    }

    void resetSim() {
        Globals.sim.reset();
        this.chartPanel.reset();
        if (this.rawOrderBookDialog != null) {
            this.rawOrderBookDialog.start(Globals.sim.getDefaultMarket(), (byte)2, (byte)3);
        }
        this.orderBooksHorizontal.start();
    }

    private void initSim() {
        this.runButton.setEnabled(true);
        this.stopButton.setEnabled(false);
        this.pauseButton.setEnabled(false);
    }

    private void editPreferencesActionPerformed(ActionEvent evt) {
        EditPreferencesDialog d = new EditPreferencesDialog((Frame)this, this.rootPaneCheckingEnabled);
        d.setVisible(this.rootPaneCheckingEnabled);
    }

    private void deleteMenuItemActionPerformed(ActionEvent evt) {
        EditAutoTraderListDialog ed = new EditAutoTraderListDialog((Frame)this, true);
        ed.setVisible(this.rootPaneCheckingEnabled);
    }

    private void pasteMenuItemActionPerformed(ActionEvent evt) {
        EditStrategiesDialog s = new EditStrategiesDialog((Frame)this, false);
        s.setVisible(this.rootPaneCheckingEnabled);
    }

    private void fileOpenMenuItemActionPerformed(ActionEvent evt) {
        JFileChooser fc = this.getFileChooser();
        while (fc.showOpenDialog(this) == 0) {
            try {
                File f = fc.getSelectedFile();
                JSONObject cfg = Globals.loadConfigFromFile(f);
                Globals.putConfig(cfg);
                String workdir = fc.getCurrentDirectory().getAbsolutePath();
                Globals.prefs_new.put(Globals.PrefKeys.WORKDIR, workdir);
                Globals.prefs_new.put("currentfile", f.getAbsolutePath());
                this.setTitle(f.getName());
                return;
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(this, "Can't load file: " + ex.getMessage(), "Error", 0);
                continue;
            }
            break;
        }
        return;
    }

    private JFileChooser getFileChooser() {
        JFileChooser fc = new JFileChooser();
        String workdir = Globals.prefs_new.get(Globals.PrefKeys.WORKDIR, "");
        fc.setCurrentDirectory(new File(workdir));
        FileNameExtensionFilter sesim_filter = new FileNameExtensionFilter("SeSim Files", "sesim");
        fc.setFileFilter(sesim_filter);
        return fc;
    }

    @Override
    public final void setTitle(String filename) {
        String name = "OpenSeSim - Stock Exchange Simulator";
        if (!"".equals(filename)) {
            name = name + " (" + filename + ")";
        }
        super.setTitle(name);
    }

    private void saveFile(boolean saveAs) {
        JFileChooser fc = this.getFileChooser();
        FileFilter sesim_filter = fc.getFileFilter();
        while (true) {
            String s;
            int dialogResult;
            File fobj;
            String current_file = Globals.prefs_new.get("currentfile", "");
            if (saveAs || "".equals(current_file)) {
                if (!"".equals(current_file)) {
                    fobj = new File(current_file);
                    fc.setSelectedFile(fobj);
                    fc.setCurrentDirectory(fobj);
                }
                saveAs = true;
                if (fc.showSaveDialog(this) != 0) {
                    return;
                }
            } else {
                fobj = new File(current_file);
                fc.setSelectedFile(fobj);
                fc.setCurrentDirectory(fobj);
            }
            File f = fc.getSelectedFile();
            String workdir = fc.getCurrentDirectory().getAbsolutePath();
            Globals.prefs_new.put(Globals.PrefKeys.WORKDIR, workdir);
            String fn = f.getAbsolutePath();
            if (f.exists() && saveAs && (dialogResult = JOptionPane.showConfirmDialog(this, s = String.format("File %s already exists. Do you want to overwrite?", fn), "Warning", 0)) != 0) continue;
            FileFilter selected_filter = fc.getFileFilter();
            if (selected_filter == sesim_filter && !fn.toLowerCase().endsWith(".sesim")) {
                f = new File(fn + "." + "sesim");
            }
            try {
                Globals.saveFile(f, Globals.getConfig());
                this.setTitle(f.getName());
                return;
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(this, "Can't save file: " + ex.getMessage(), "Error", 0);
                continue;
            }
            break;
        }
    }

    private void fileSaveAsMenuItemActionPerformed(ActionEvent evt) {
        this.saveFile(true);
    }

    private void resetToDefaults() {
        InputStream is = this.getClass().getResourceAsStream("/files/defaultcfg.json");
        String df = new Scanner(is, "UTF-8").useDelimiter("\\A").next();
        try {
            JSONObject cfg = Globals.loadConfigFromString(df);
            Globals.putConfig(cfg);
        }
        catch (IOException ex) {
            JOptionPane.showMessageDialog(this, "Can't load file: " + ex.getMessage(), "Error", 0);
        }
    }

    private void resetToDefaultsMenuItemActionPerformed(ActionEvent evt) {
        int dialogResult = JOptionPane.showConfirmDialog(this, "Are you sure?", "Warning", 0);
        if (dialogResult != 0) {
            return;
        }
        this.resetToDefaults();
    }

    private void simMenuStartActionPerformed(ActionEvent evt) {
        this.startSim();
    }

    private void simMenuPauseActionPerformed(ActionEvent evt) {
        this.pauseSim();
    }

    private void simMenuStopActionPerformed(ActionEvent evt) {
        this.stopSim();
    }

    private void pauseButtonActionPerformed(ActionEvent evt) {
        this.pauseSim();
    }

    private void runButtonActionPerformed(ActionEvent evt) {
        this.startSim();
    }

    private void stopButtonActionPerformed(ActionEvent evt) {
        this.stopSim();
    }

    private void viewRawOrderBookActionPerformed(ActionEvent evt) {
        SwingUtilities.invokeLater(() -> {
            if (this.viewRawOrderBook.getState()) {
                if (this.rawOrderBookDialog == null) {
                    this.rawOrderBookDialog = new RawOrderBookDialog((Frame)this, false);
                    this.rawOrderBookDialog.start(Globals.sim.getDefaultMarket(), (byte)2, (byte)3);
                    this.rawOrderBookDialog.setTitle("Level 3 Order Book");
                    this.rawOrderBookDialog.addWindowListener(new WindowAdapter(){

                        @Override
                        public void windowClosing(WindowEvent e) {
                            super.windowClosing(e);
                            SeSimApplication.this.rawOrderBookDialog.dispose();
                            SeSimApplication.this.rawOrderBookDialog.stop();
                            SeSimApplication.this.rawOrderBookDialog = null;
                            SeSimApplication.this.viewRawOrderBook.setState(false);
                        }
                    });
                }
                this.rawOrderBookDialog.setVisible(true);
            } else if (this.rawOrderBookDialog != null) {
                this.rawOrderBookDialog.setVisible(false);
            }
        });
    }

    private void viewTraderListCheckBoxActionPerformed(ActionEvent evt) {
        SwingUtilities.invokeLater(() -> {
            Dialog traderListDialog = null;
            if (this.viewTraderListCheckBox.getState()) {
                if (traderListDialog == null) {
                    traderListDialog = new TraderListDialog((Frame)this, false);
                    traderListDialog.addWindowListener(new WindowAdapter(){

                        @Override
                        public void windowClosing(WindowEvent e) {
                            super.windowClosing(e);
                            SeSimApplication.this.viewTraderListCheckBox.setState(false);
                            System.out.printf("Set menu false\n", new Object[0]);
                        }
                    });
                }
                traderListDialog.setVisible(true);
            } else if (traderListDialog != null) {
                traderListDialog.setVisible(false);
            }
        });
    }

    private void fileSaveMenuItemActionPerformed(ActionEvent evt) {
        this.saveFile(false);
    }

    private void closeMenuItemActionPerformed(ActionEvent evt) {
        Globals.prefs_new.put("currentfile", "");
        this.setTitle("");
    }

    private void clearMenuItemActionPerformed(ActionEvent evt) {
        int dialogResult = JOptionPane.showConfirmDialog(this, "Are you sure?", "Warning", 0);
        if (dialogResult != 0) {
            return;
        }
        Globals.clearAll();
    }

    private void viewUnlimitedOrdesActionPerformed(ActionEvent evt) {
        SwingUtilities.invokeLater(() -> {
            if (this.viewUnlimitedOrdes.getState()) {
                if (this.unlimitedOrdersDialog == null) {
                    this.unlimitedOrdersDialog = new RawOrderBookDialog((Frame)this, false);
                    this.unlimitedOrdersDialog.start(Globals.sim.getDefaultMarket(), (byte)0, (byte)1);
                    this.unlimitedOrdersDialog.setTitle("Unlimited Orders");
                    this.unlimitedOrdersDialog.addWindowListener(new WindowAdapter(){

                        @Override
                        public void windowClosing(WindowEvent e) {
                            super.windowClosing(e);
                            SeSimApplication.this.unlimitedOrdersDialog.dispose();
                            SeSimApplication.this.unlimitedOrdersDialog.stop();
                            SeSimApplication.this.unlimitedOrdersDialog = null;
                            SeSimApplication.this.viewUnlimitedOrdes.setState(false);
                        }
                    });
                }
                this.unlimitedOrdersDialog.setVisible(true);
            } else if (this.unlimitedOrdersDialog != null) {
                this.unlimitedOrdersDialog.setVisible(false);
            }
        });
    }

    private void viewStopOrdersActionPerformed(ActionEvent evt) {
        SwingUtilities.invokeLater(() -> {
            if (this.viewStopOrders.getState()) {
                if (this.stopOrderBookDialog == null) {
                    this.stopOrderBookDialog = new RawOrderBookDialog((Frame)this, false);
                    this.stopOrderBookDialog.start(Globals.sim.getDefaultMarket(), (byte)4, (byte)5);
                    this.stopOrderBookDialog.setTitle("Stop Orders");
                    this.stopOrderBookDialog.setTitles("Stop Buy", "Stop Sell");
                    this.stopOrderBookDialog.setPriceColumn((byte)4);
                    this.stopOrderBookDialog.addWindowListener(new WindowAdapter(){

                        @Override
                        public void windowClosing(WindowEvent e) {
                            super.windowClosing(e);
                            SeSimApplication.this.stopOrderBookDialog.dispose();
                            SeSimApplication.this.stopOrderBookDialog.stop();
                            SeSimApplication.this.stopOrderBookDialog = null;
                            SeSimApplication.this.viewStopOrders.setState(false);
                        }
                    });
                }
                this.stopOrderBookDialog.setVisible(true);
            } else if (this.unlimitedOrdersDialog != null) {
                this.stopOrderBookDialog.setVisible(false);
            }
        });
    }

    private void randomSeedActionPerformed(ActionEvent evt) {
        RandomSeedDialog d = new RandomSeedDialog((Frame)this, true);
        d.setVisible(true);
    }

    private void viewLogActionPerformed(ActionEvent evt) {
        if (this.logDialog == null) {
            this.logDialog = new LogDialog((Frame)this, false);
            this.logDialog.setLocationRelativeTo(this);
        }
        this.logDialog.setVisible(this.viewLog.isSelected());
    }

    void setTradingLogFile() {
        String dataDir = Globals.getDataDir();
        Path directoryPath = Paths.get(dataDir, new String[0]);
        this.logFileName = directoryPath.resolve("tradinglog.dat").toString();
        Globals.sim.getDefaultMarket().setTradingLogFile(this.logFileName);
    }

    private void tradingLogCheckBoxActionPerformed(ActionEvent evt) {
        try {
            Globals.sim.getDefaultMarket().setTradingLog(this.tradingLogCheckBox.isSelected());
        }
        catch (FileNotFoundException ex) {
            Logger.error("Cannot write log %s: %s", this.logFileName, ex.getMessage());
            this.tradingLogCheckBox.setSelected(false);
        }
    }

    private void viewTradingLogActionPerformed(ActionEvent evt) {
        SwingUtilities.invokeLater(() -> {
            if (this.viewTradingLog.getState()) {
                if (this.tradingLogDialog == null) {
                    this.tradingLogDialog = new TradingLogDialog((Frame)this, false);
                    this.tradingLogDialog.addWindowListener(new WindowAdapter(){

                        @Override
                        public void windowClosing(WindowEvent e) {
                            super.windowClosing(e);
                            SeSimApplication.this.viewTraderListCheckBox.setState(false);
                            System.out.printf("Set menu false\n", new Object[0]);
                        }
                    });
                }
                this.tradingLogDialog.setLocationRelativeTo(this);
                this.tradingLogDialog.setVisible(true);
            } else if (this.tradingLogDialog != null) {
                this.tradingLogDialog.setVisible(false);
            }
        });
    }

    private void marketsMenuItemActionPerformed(ActionEvent evt) {
        AssetListDialog ad = new AssetListDialog(this, true);
        ad.pack();
        ad.setMinimumSize(ad.getSize());
        ad.setLocationRelativeTo(this);
        ad.setVisible(true);
    }

    private void jMenuItem2ActionPerformed(ActionEvent evt) {
        BreakPointsDialog bpd = new BreakPointsDialog((Frame)this, true);
        bpd.setLocationRelativeTo(this);
        bpd.setVisible(true);
    }

    public static void main(String[] args) throws IllegalAccessException, InstantiationException {
        java.util.logging.Logger rootLogger = Logger.getLogger();
        ConsoleHandler consoleHandler = new ConsoleHandler();
        consoleHandler.setLevel(Level.ALL);
        consoleHandler.setFormatter(new SimpleFormatter());
        rootLogger.addHandler(consoleHandler);
        rootLogger.setLevel(Level.ALL);
        Globals.initGlobals();
        Globals.prefs_new = Preferences.userRoot().node("/opensesim");
        Logger.info("Data directory is %s", Globals.getDataDir());
        Globals.setLookAndFeel();
        Globals.prefs_new.put("currentfile", "");
        Globals.sim = new Sim();
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                SeSimApplication app = new SeSimApplication();
                app.setLocationRelativeTo(null);
                app.setVisible(true);
            }
        });
    }
}

