/*
 * Decompiled with CFR 0.152.
 */
package gui;

import gui.Globals;
import java.awt.Color;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import sesim.Market;

public class Statistics
extends JPanel {
    long lastNumTrades0;
    long lastNumTrades1 = 0L;
    long lastNumTrades = 0L;
    private JLabel freeMem;
    private JLabel high;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JPanel jPanel1;
    private JLabel low;
    private JLabel maxMem;
    private JLabel numOrders;
    private JLabel numOrdersLabel;
    private JLabel numTrades;
    private JLabel totalMem;
    private JLabel tradesLabel;
    private JLabel tradesPerSecLabel;
    private JLabel tradesPerSecReal;
    private JLabel tradesPerSecSim;
    private JLabel usedMem;

    String formatFloatX(float v) {
        if (v == 0.0f) {
            return "0";
        }
        if (v >= 10.0f) {
            return String.format("%.0f", Float.valueOf(v));
        }
        if (v >= 1.0f) {
            return String.format("%.1f", Float.valueOf(v));
        }
        if ((double)v >= 0.1) {
            return String.format("%.1f", Float.valueOf(v));
        }
        if ((double)v > 0.01) {
            return String.format("%.2f", Float.valueOf(v));
        }
        return String.format("%f", Float.valueOf(v));
    }

    public Statistics() {
        this.initComponents();
        new Timer().schedule(new TimerTask(){

            @Override
            public void run() {
                Market.Statistics s = Globals.sim.getDefaultMarket().getStatistics();
                Statistics.this.tradesLabel.setText(String.format("%d", s.trades));
                Statistics.this.high.setText(Globals.sim.getDefaultMarket().getCurrency().getFormatter().format(s.high));
                Statistics.this.low.setText(Globals.sim.getDefaultMarket().getCurrency().getFormatter().format(s.low));
                long diff = s.trades - Statistics.this.lastNumTrades;
                if (diff < 0L) {
                    Statistics.this.lastNumTrades1 = 0L;
                    Statistics.this.lastNumTrades0 = 0L;
                    Statistics.this.lastNumTrades = 0L;
                    diff = s.trades;
                }
                Statistics.this.lastNumTrades = s.trades;
                Statistics.this.lastNumTrades0 = Statistics.this.lastNumTrades1;
                Statistics.this.lastNumTrades1 = diff;
                float tps = (Statistics.this.lastNumTrades1 + Statistics.this.lastNumTrades0) / 2L;
                Statistics.this.tradesPerSecReal.setText(Statistics.this.formatFloatX(tps));
                Statistics.this.numOrders.setText(String.format("%d", s.orders));
                float t = (float)s.lastTradeTime / 1000.0f;
                float simTrades = t != 0.0f ? (float)s.trades / t : 0.0f;
                Statistics.this.tradesPerSecSim.setText(Statistics.this.formatFloatX(simTrades));
                Runtime rt = Runtime.getRuntime();
                long maxMemory = rt.maxMemory();
                long totalMemory = rt.totalMemory();
                long freeMemory = rt.freeMemory();
                long usedMemory = totalMemory - freeMemory;
                Statistics.this.maxMem.setText(String.format("Max: %d MB%n", maxMemory / 1024L / 1024L));
                Statistics.this.totalMem.setText(String.format("Total: %d MB%n", totalMemory / 1024L / 1024L));
                Statistics.this.freeMem.setText(String.format("Free: %d MB%n", freeMemory / 1024L / 1024L));
                Statistics.this.usedMem.setText(String.format("Used: %d MB%n", usedMemory / 1024L / 1024L));
            }
        }, 1000L, 1000L);
    }

    private void initComponents() {
        this.numTrades = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.high = new JLabel();
        this.low = new JLabel();
        this.tradesLabel = new JLabel();
        this.jPanel1 = new JPanel();
        this.jLabel4 = new JLabel();
        this.jLabel5 = new JLabel();
        this.jLabel7 = new JLabel();
        this.totalMem = new JLabel();
        this.freeMem = new JLabel();
        this.usedMem = new JLabel();
        this.maxMem = new JLabel();
        this.jLabel6 = new JLabel();
        this.tradesPerSecReal = new JLabel();
        this.numOrdersLabel = new JLabel();
        this.numOrders = new JLabel();
        this.jLabel1 = new JLabel();
        this.tradesPerSecLabel = new JLabel();
        this.tradesPerSecSim = new JLabel();
        this.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.numTrades.setText("Trades:");
        this.jLabel2.setText("High:");
        this.jLabel3.setText("Low:");
        this.high.setText("100.00");
        this.low.setText("50.00");
        this.tradesLabel.setText("0");
        this.jPanel1.setToolTipText("Java VM stats");
        this.jLabel4.setText("Max:");
        this.jLabel5.setText("Total:");
        this.jLabel7.setText("Used:");
        this.totalMem.setText("0");
        this.freeMem.setText("0");
        this.usedMem.setText("0");
        this.maxMem.setText("0");
        this.jLabel6.setText("Free:");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel7).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel4).addComponent(this.jLabel5))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.freeMem, -1, 114, Short.MAX_VALUE).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.maxMem, -1, 114, Short.MAX_VALUE).addComponent(this.totalMem, -1, -1, Short.MAX_VALUE).addComponent(this.usedMem, -1, -1, Short.MAX_VALUE)))).addComponent(this.jLabel6)).addContainerGap(131, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jLabel4, -1, -1, Short.MAX_VALUE).addComponent(this.maxMem, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel5).addComponent(this.totalMem)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jLabel7, -1, -1, Short.MAX_VALUE).addComponent(this.usedMem, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jLabel6, -1, -1, Short.MAX_VALUE).addComponent(this.freeMem, -1, -1, Short.MAX_VALUE)).addContainerGap(-1, Short.MAX_VALUE)));
        this.tradesPerSecReal.setText("0");
        this.numOrdersLabel.setText("Orders:");
        this.numOrders.setText("0");
        this.jLabel1.setText("Overall trades/sec (sim):");
        this.tradesPerSecLabel.setText("Current trades/sec (real):");
        this.tradesPerSecSim.setText("0");
        GroupLayout layout2 = new GroupLayout(this);
        this.setLayout(layout2);
        layout2.setHorizontalGroup(layout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout2.createSequentialGroup().addContainerGap().addGroup(layout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout2.createSequentialGroup().addComponent(this.numOrdersLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.numOrders)).addGroup(layout2.createSequentialGroup().addGroup(layout2.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1).addComponent(this.tradesPerSecLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout2.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.tradesPerSecReal, -1, 118, Short.MAX_VALUE).addComponent(this.tradesPerSecSim, -1, -1, Short.MAX_VALUE))).addComponent(this.jPanel1, -2, -1, -2).addGroup(layout2.createSequentialGroup().addGroup(layout2.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jLabel2, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel3, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.numTrades, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout2.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.high, -1, 97, Short.MAX_VALUE).addComponent(this.tradesLabel).addComponent(this.low, -1, -1, Short.MAX_VALUE)))).addGap(0, 99, Short.MAX_VALUE)));
        layout2.setVerticalGroup(layout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout2.createSequentialGroup().addContainerGap().addGroup(layout2.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.high)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout2.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.low)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout2.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.numTrades).addComponent(this.tradesLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout2.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.numOrdersLabel).addComponent(this.numOrders)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout2.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.tradesPerSecSim)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout2.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.tradesPerSecLabel).addComponent(this.tradesPerSecReal)).addGap(18, 18, 18).addComponent(this.jPanel1, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
    }
}

