/*
 * Decompiled with CFR 0.152.
 */
package gui;

import gui.Globals;
import gui.util.NummericCellRenderer;
import gui.util.PercentageCellRenderer;
import gui.util.PercentageValue;
import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.GroupLayout;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import sesim.Account;
import sesim.AutoTrader;

public class TraderListPanel
extends JPanel {
    MyModel model;
    Frame parentFrame = null;
    TimerTask updater;
    private final Map<Column, TableColumn> hiddenColumns = new HashMap<Column, TableColumn>();
    Column[] columnList = Column.values();
    MyRowSorter sorter;
    JPopupMenu popupMenu;
    private JScrollPane jScrollPane1;
    private JTable list;

    public TraderListPanel(Frame parent) {
        this();
        this.parentFrame = parent;
    }

    public TraderListPanel(Frame parent, Column[] columnList) {
        this.initComponents();
        if (Globals.sim == null) {
            return;
        }
        this.columnList = columnList;
        this.setupTable();
        this.addContextMenu();
    }

    public TraderListPanel() {
        this.initComponents();
        if (Globals.sim == null) {
            return;
        }
        this.setupTable();
        this.addContextMenu();
    }

    private void setupTable() {
        this.model = new MyModel(Column.values());
        this.list.setModel(this.model);
        this.sorter = new MyRowSorter(this.model);
        this.list.setRowSorter(this.sorter);
        for (Column a : Column.values()) {
            this.list.getColumnModel().getColumn(a.ordinal()).setHeaderValue(a.header);
            this.list.getColumnModel().getColumn(a.ordinal()).setIdentifier((Object)a);
            this.list.getColumnModel().getColumn(a.ordinal()).setCellRenderer(a.getRenderer());
        }
        DefaultTableCellRenderer centerRenderer = new DefaultTableCellRenderer();
        centerRenderer.setHorizontalAlignment(0);
        this.list.getColumnModel().getColumn(Column.ID.ordinal()).setCellRenderer(centerRenderer);
        TableColumnModel colModel = this.list.getColumnModel();
        for (int i = colModel.getColumnCount() - 1; i >= 0; --i) {
            TableColumn col = colModel.getColumn(i);
            Column columnEnum = (Column)((Object)col.getIdentifier());
            if (Arrays.asList(this.columnList).contains((Object)columnEnum)) continue;
            this.hideColumn(columnEnum);
        }
        String widestText = "-100.0%";
        FontMetrics fm = this.list.getFontMetrics(this.list.getFont());
        int textWidth = fm.stringWidth(widestText);
        int padding = 12;
        int preferredWidth = textWidth + padding;
        int maxWidth = 100 * preferredWidth;
        final AtomicBoolean running = new AtomicBoolean(false);
        Timer timer = new Timer();
        this.updater = new TimerTask(){

            @Override
            public void run() {
                if (running.get()) {
                    return;
                }
                running.set(true);
                TraderListPanel.this.updateModel();
                running.set(false);
            }
        };
        timer.schedule(this.updater, 0L, 1000L);
    }

    final void updateModel() {
        if (Globals.sim == null) {
            return;
        }
        if (Globals.sim.getDefaultMarket() == null) {
            return;
        }
        if (Globals.sim.traders == null) {
            return;
        }
        this.model.copyTraders();
        this.sorter.sortTraders();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TableColumnModel colModel = TraderListPanel.this.list.getColumnModel();
                for (int i = colModel.getColumnCount() - 1; i >= 0; --i) {
                    TableColumn col = colModel.getColumn(i);
                    Column columnEnum = (Column)((Object)col.getIdentifier());
                    col.setCellRenderer(columnEnum.getRenderer());
                }
                Object selectedTraderId = null;
                int selectedViewRow = TraderListPanel.this.list.getSelectedRow();
                int modelRowToRestore = -1;
                if (selectedViewRow != -1) {
                    modelRowToRestore = TraderListPanel.this.list.convertRowIndexToModel(selectedViewRow);
                }
                TraderListPanel.this.sorter.updateSortedTraders();
                TraderListPanel.this.model.traders = TraderListPanel.this.model.tTraders;
                List<RowSorter.SortKey> l = TraderListPanel.this.list.getRowSorter().getSortKeys();
                TraderListPanel.this.model.fireTableDataChanged();
                TraderListPanel.this.list.getRowSorter().allRowsChanged();
                if (!l.isEmpty()) {
                    TraderListPanel.this.list.getRowSorter().allRowsChanged();
                } else {
                    TraderListPanel.this.model.fireTableDataChanged();
                }
                if (modelRowToRestore != -1 && modelRowToRestore < TraderListPanel.this.model.getRowCount()) {
                    int viewRowToRestore = TraderListPanel.this.list.convertRowIndexToView(modelRowToRestore);
                    TraderListPanel.this.list.setRowSelectionInterval(viewRowToRestore, viewRowToRestore);
                }
            }
        });
    }

    private void addContextMenu() {
        this.popupMenu = new JPopupMenu("Spalten verwalten");
        for (final Column colEnum : Column.values()) {
            String header = colEnum.header;
            boolean isVisible = false;
            try {
                isVisible = this.list.getColumnModel().getColumnIndex((Object)colEnum) != -1;
            }
            catch (Exception exception) {
                // empty catch block
            }
            final JCheckBoxMenuItem menuItem = new JCheckBoxMenuItem(header, isVisible);
            menuItem.setName(header);
            if (colEnum == Column.ID) {
                // empty if block
            }
            menuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (menuItem.isSelected()) {
                        TraderListPanel.this.showColumn(colEnum);
                    } else {
                        TraderListPanel.this.hideColumn(colEnum);
                    }
                }
            });
            this.popupMenu.add(menuItem);
        }
        this.list.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    TraderListPanel.this.popupMenu.show(e.getComponent(), e.getX(), e.getY());
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    TraderListPanel.this.popupMenu.show(e.getComponent(), e.getX(), e.getY());
                }
            }
        });
    }

    private void hideColumn(Column colEnum) {
        TableColumnModel colModel = this.list.getColumnModel();
        try {
            int viewIndex = colModel.getColumnIndex((Object)colEnum);
            TableColumn col = colModel.getColumn(viewIndex);
            colModel.removeColumn(col);
            this.hiddenColumns.put(colEnum, col);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private void showColumn(Column colEnum) {
        TableColumn col = this.hiddenColumns.get((Object)colEnum);
        if (col != null) {
            Column current;
            TableColumnModel colModel = this.list.getColumnModel();
            int insertIndex = 0;
            Column[] allColumns = Column.values();
            for (int i = 0; i < allColumns.length && (current = allColumns[i]) != colEnum; ++i) {
                if (this.hiddenColumns.containsKey((Object)current)) continue;
                ++insertIndex;
            }
            colModel.addColumn(col);
            colModel.moveColumn(colModel.getColumnCount() - 1, insertIndex);
            this.hiddenColumns.remove((Object)colEnum);
        }
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.list = new JTable();
        this.list.setAutoCreateRowSorter(true);
        this.list.setModel(new DefaultTableModel(new Object[0][], new String[]{"ID", "Name", "Status", "Shares", "Cash", "Free Margin", "Total", "PnL%"}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{Long.class, Object.class, String.class, Float.class, Float.class, Float.class, Float.class, Double.class};
                this.canEdit = new boolean[]{false, false, false, false, false, false, false, false};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.list.setDoubleBuffered(true);
        this.list.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                TraderListPanel.this.listMouseClicked(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.list);
        if (this.list.getColumnModel().getColumnCount() > 0) {
            this.list.getColumnModel().getColumn(0).setPreferredWidth(20);
            this.list.getColumnModel().getColumn(0).setMaxWidth(70);
            this.list.getColumnModel().getColumn(7).setPreferredWidth(50);
            this.list.getColumnModel().getColumn(7).setMaxWidth(80);
        }
        GroupLayout layout2 = new GroupLayout(this);
        this.setLayout(layout2);
        layout2.setHorizontalGroup(layout2.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, GroupLayout.Alignment.TRAILING, -1, 574, Short.MAX_VALUE));
        layout2.setVerticalGroup(layout2.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, GroupLayout.Alignment.TRAILING, -1, 292, Short.MAX_VALUE));
    }

    private void listMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() == 2) {
            System.out.printf("double clicked\n", new Object[0]);
            int index = this.list.rowAtPoint(evt.getPoint());
            System.out.printf("Index: %d\n", index);
            index = this.list.getRowSorter().convertRowIndexToModel(index);
            System.out.printf("Model Index: %d", index);
            Integer tid = (Integer)this.model.getValueAt(index, 0);
            System.out.printf("TID Index: %d\n", index);
            JDialog console = Globals.sim.traders.get(tid).getGuiConsole(this.parentFrame);
            if (console == null) {
                System.out.printf("Console was 0 \n", new Object[0]);
                return;
            }
            console.setVisible(true);
        }
    }

    public static enum Column {
        ID("ID", null, Long.class),
        NAME("Name", null, Object.class),
        STATUS("Status", null, String.class),
        SHARES("Shares", null, Float.class),
        MARGIN("Margin", null, Float.class),
        EQUITY("Equtiy", null, Float.class),
        FREEMARGIN("Free Margin", null, Float.class),
        NETCASHFLOW("Net Cahs Flow", null, Float.class),
        CASH("Cash", null, Float.class),
        PNL("PnL", null, PercentageValue.class);

        public final String header;
        private TableCellRenderer renderer;
        public final Class cls;

        private Column(String header, TableCellRenderer r, Class cls) {
            this.header = header;
            this.renderer = r;
            this.cls = cls;
        }

        public TableCellRenderer getRenderer() {
            this.renderer = null;
            if (this.renderer == null) {
                switch (this.ordinal()) {
                    case 1: {
                        this.renderer = new NameCellRenderer();
                        break;
                    }
                    case 3: {
                        this.renderer = new NummericCellRenderer(Globals.sim.getDefaultMarket().getAsset().getDecimals());
                        break;
                    }
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: {
                        this.renderer = new NummericCellRenderer(Globals.sim.getDefaultMarket().getCurrency().getDecimals());
                        break;
                    }
                    case 9: {
                        this.renderer = new PercentageCellRenderer();
                        break;
                    }
                }
            }
            return this.renderer;
        }
    }

    private class MyModel
    extends DefaultTableModel {
        Column[] def;
        ArrayList<ArrayList<Object>> traders;
        ArrayList<ArrayList<Object>> tTraders;

        public MyModel(Object[][] arg0, Object[] arg1) {
            super(arg0, arg1);
            this.traders = null;
            this.tTraders = null;
        }

        public MyModel(Column[] d) {
            this.traders = null;
            this.tTraders = null;
            this.def = d;
        }

        @Override
        public int getColumnCount() {
            if (this.def == null) {
                return 0;
            }
            return this.def.length;
        }

        public Class getColumnClass(int columnIndex) {
            if (this.def == null) {
                return null;
            }
            return this.def[columnIndex].cls;
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return false;
        }

        @Override
        public void fireTableDataChanged() {
            super.fireTableDataChanged();
        }

        @Override
        public void fireTableStructureChanged() {
        }

        @Override
        public void fireTableRowsUpdated(int firstRow, int lastRow) {
            super.fireTableRowsUpdated(firstRow, lastRow);
        }

        @Override
        public void fireTableCellUpdated(int row, int column) {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void copyTraders() {
            ArrayList<AutoTrader> arrayList = Globals.sim.traders;
            synchronized (arrayList) {
                ArrayList t = new ArrayList();
                for (AutoTrader a : Globals.sim.traders) {
                    ArrayList<Object> objects = new ArrayList<Object>();
                    for (Column c : Column.values()) {
                        objects.add(this.getValue(a, c.ordinal()));
                    }
                    t.add(objects);
                }
                this.tTraders = t;
            }
        }

        public Object getValue(AutoTrader at, int column) {
            Account a = at.getAccount();
            double price = Globals.sim.getDefaultMarket().getLastPrice();
            if (column == Column.ID.ordinal()) {
                int id = (int)at.getID();
                return id;
            }
            if (column == Column.NAME.ordinal()) {
                int[] atc = at.getColor();
                Color c = null;
                if (atc != null) {
                    c = new Color(atc[0], atc[1], atc[2]);
                }
                return new NameValue(at.getName(), c);
            }
            if (column == Column.STATUS.ordinal()) {
                return at.getStatus();
            }
            if (column == Column.CASH.ordinal()) {
                return a.getMoney();
            }
            if (column == Column.SHARES.ordinal()) {
                return a.getShares(Globals.sim.getDefaultMarket());
            }
            if (column == Column.EQUITY.ordinal()) {
                return a.getEquity();
            }
            if (column == Column.MARGIN.ordinal()) {
                return a.getMarginUsed();
            }
            if (column == Column.FREEMARGIN.ordinal()) {
                return a.getFreeMargin();
            }
            if (column == Column.NETCASHFLOW.ordinal()) {
                return a.getPosition(Globals.sim.getDefaultMarket()).getNetCashFlow();
            }
            if (column == Column.PNL.ordinal()) {
                return new PercentageValue(a.getPerformance(price));
            }
            return null;
        }

        @Override
        public Object getValueAt(int row, int column) {
            if (this.traders == null) {
                AutoTrader at = Globals.sim.traders.get(row);
                return this.getValue(at, column);
            }
            return this.traders.get(row).get(column);
        }

        public Object getTValueAt(int row, int column) {
            if (this.tTraders == null) {
                AutoTrader at = Globals.sim.traders.get(row);
                return this.getValue(at, column);
            }
            return this.tTraders.get(row).get(column);
        }

        @Override
        public int getRowCount() {
            return Globals.sim.traders.size();
        }
    }

    class MyRowSorter
    extends RowSorter<MyModel> {
        private final MyModel model;
        private List<RowSorter.SortKey> sortKeys = Collections.emptyList();
        byte sortCol = 0;
        boolean sortAsc = false;
        ArrayList<Integer> viewToModel = null;
        ArrayList<Integer> modelToView = null;
        ArrayList<Integer> tViewToModel = new ArrayList();
        ArrayList<Integer> tModelToView = new ArrayList();

        public void sortTraders() {
            int i;
            this.tViewToModel = new ArrayList();
            this.tModelToView = new ArrayList();
            for (i = 0; i < this.model.getRowCount(); ++i) {
                this.tViewToModel.add(i);
                this.tModelToView.add(i);
            }
            this.tViewToModel.sort(new TraderComparator(this.sortCol, this.sortAsc));
            for (i = 0; i < this.tViewToModel.size(); ++i) {
                int modelIndex = this.tViewToModel.get(i);
                this.tModelToView.set(modelIndex, i);
            }
        }

        void updateSortedTraders() {
            this.viewToModel = this.tViewToModel;
            this.modelToView = this.tModelToView;
        }

        public MyRowSorter(MyModel model) {
            this.model = model;
        }

        @Override
        public MyModel getModel() {
            return this.model;
        }

        @Override
        public void setSortKeys(List<? extends RowSorter.SortKey> keys2) {
            this.sortKeys = new ArrayList<RowSorter.SortKey>(keys2);
            if (!keys2.isEmpty()) {
                RowSorter.SortKey k = keys2.get(0);
                int col = k.getColumn();
                boolean bl = k.getSortOrder() == SortOrder.ASCENDING;
            }
            System.out.print(this.sortKeys);
            this.fireSortOrderChanged();
        }

        @Override
        public List<RowSorter.SortKey> getSortKeys() {
            return this.sortKeys;
        }

        @Override
        public int convertRowIndexToModel(int row) {
            if (this.viewToModel == null) {
                return row;
            }
            return this.viewToModel.get(row);
        }

        @Override
        public int convertRowIndexToView(int row) {
            if (this.modelToView == null) {
                return row;
            }
            return this.modelToView.get(row);
        }

        @Override
        public void modelStructureChanged() {
            this.fireSortOrderChanged();
        }

        @Override
        public void allRowsChanged() {
            this.fireSortOrderChanged();
        }

        @Override
        public void rowsInserted(int firstRow, int endRow) {
        }

        @Override
        public void rowsDeleted(int firstRow, int endRow) {
        }

        @Override
        public void rowsUpdated(int firstRow, int endRow) {
        }

        @Override
        public void rowsUpdated(int firstRow, int endRow, int col) {
        }

        @Override
        public void toggleSortOrder(int column) {
            RowSorter.SortKey current;
            boolean asc = true;
            if (!this.sortKeys.isEmpty() && (current = this.sortKeys.get(0)).getColumn() == column) {
                asc = current.getSortOrder() != SortOrder.ASCENDING;
            }
            this.sortCol = (byte)column;
            this.sortAsc = asc;
            ArrayList<RowSorter.SortKey> newKeys = new ArrayList<RowSorter.SortKey>();
            newKeys.add(new RowSorter.SortKey(column, asc ? SortOrder.ASCENDING : SortOrder.DESCENDING));
            System.out.print(newKeys);
            this.setSortKeys(newKeys);
        }

        @Override
        public int getViewRowCount() {
            return this.model.getRowCount();
        }

        @Override
        public int getModelRowCount() {
            return this.model.getRowCount();
        }

        class TraderComparator
        implements Comparator<Integer> {
            byte col;
            boolean asc;

            TraderComparator(byte col, boolean asc) {
                this.col = col;
                this.asc = asc;
            }

            @Override
            public int compare(Integer left, Integer right) {
                Object lo = MyRowSorter.this.model.getTValueAt(left, this.col);
                Object ro = MyRowSorter.this.model.getTValueAt(right, this.col);
                Comparable l = (Comparable)lo;
                Comparable r = (Comparable)ro;
                if (l == null && r == null) {
                    return 0;
                }
                if (l == null) {
                    return this.asc ? 1 : -1;
                }
                if (r == null) {
                    return this.asc ? -1 : 1;
                }
                return this.asc ? l.compareTo(r) : r.compareTo(l);
            }
        }
    }

    public static class NameCellRenderer
    extends DefaultTableCellRenderer {
        @Override
        public Component getTableCellRendererComponent(JTable table2, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            NameValue n = (NameValue)value;
            Component c = super.getTableCellRendererComponent(table2, n.toString(), isSelected, hasFocus, row, column);
            if (!isSelected) {
                Color color = n.getColor();
                if (color != null) {
                    this.setBackground(n.getColor());
                } else {
                    this.setBackground(table2.getBackground());
                }
            }
            return c;
        }
    }

    public class NameValue
    implements Comparable<NameValue> {
        private final String value;
        private final Color color;

        public NameValue(String value, Color color) {
            this.value = value;
            this.color = color;
        }

        public String toString() {
            return this.value;
        }

        @Override
        public int compareTo(NameValue other) {
            return this.value.compareTo(other.value);
        }

        public String getValue() {
            return this.value;
        }

        public Color getColor() {
            return this.color;
        }
    }
}

