/*
 * Decompiled with CFR 0.152.
 */
package gui;

import gui.Globals;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.GroupLayout;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.Timer;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableModel;
import sesim.Order;
import sesim.TradingLogReader;
import sesim.TradingLogWriter;

public class TradingLogPanel
extends JPanel {
    private Timer updateTimer;
    private long lastLogSize = 0L;
    private TradingLogModel logModel;
    private JScrollPane jScrollPane1;
    private JTable table;

    public TradingLogPanel() {
        this.initComponents();
        if (Globals.sim == null) {
            return;
        }
        this.logModel = new TradingLogModel();
        this.table.setModel(this.logModel);
        int delay = 166;
        this.updateTimer = new Timer(delay, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TradingLogPanel.this.checkAndUpdateLog();
            }
        });
        this.updateTimer.start();
    }

    private void checkAndUpdateLog() {
        if (Globals.sim == null || Globals.sim.getDefaultMarket() == null) {
            return;
        }
        try {
            long currentSize;
            TradingLogReader logReader = Globals.sim.getDefaultMarket().getTradingLog();
            if (logReader != null && (currentSize = logReader.size()) != this.lastLogSize) {
                if (currentSize > this.lastLogSize) {
                    int firstRow = (int)this.lastLogSize;
                    int lastRow = (int)(currentSize - 1L);
                    this.logModel.fireTableRowsInserted(firstRow, lastRow);
                } else if (currentSize < this.lastLogSize) {
                    int firstRow = (int)currentSize;
                    int lastRow = (int)(this.lastLogSize - 1L);
                    this.logModel.fireTableRowsDeleted(firstRow, lastRow);
                }
                this.lastLogSize = currentSize;
            }
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(TradingLogPanel.class.getName()).log(Level.WARNING, "TradingLogReader file not found.", ex);
        }
        catch (IOException ex) {
            Logger.getLogger(TradingLogPanel.class.getName()).log(Level.SEVERE, "IO Error when calling TradingLogReader.size()", ex);
        }
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.table = new JTable();
        this.table.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Time", "Action", "Order ID", "Title 4"}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{Long.class, String.class, Long.class, Object.class};
                this.canEdit = new boolean[]{false, false, false, false};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.jScrollPane1.setViewportView(this.table);
        GroupLayout layout2 = new GroupLayout(this);
        this.setLayout(layout2);
        layout2.setHorizontalGroup(layout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout2.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 646, Short.MAX_VALUE).addContainerGap()));
        layout2.setVerticalGroup(layout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout2.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -1, 250, Short.MAX_VALUE).addContainerGap()));
    }

    class TradingLogModel
    extends AbstractTableModel {
        final String[] colNames = new String[]{"Time", "Action", "Trader", "OID", "Type", "Volume", "Limit", "Stop", "Trans Vol", "Trans Price"};
        final Class[] colTypes = new Class[]{Long.class, String.class, String.class, Long.class, String.class, Float.class, Float.class, Float.class, Float.class, Float.class};

        TradingLogModel() {
        }

        @Override
        public int getRowCount() {
            TradingLogReader l = null;
            try {
                l = Globals.sim.getDefaultMarket().getTradingLog();
            }
            catch (FileNotFoundException ex) {
                return 0;
            }
            if (l == null) {
                return 0;
            }
            int rows = 0;
            try {
                rows = (int)l.size();
            }
            catch (IOException ex) {
                return 0;
            }
            return rows;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            TradingLogReader l = null;
            try {
                l = Globals.sim.getDefaultMarket().getTradingLog();
            }
            catch (FileNotFoundException ex) {
                return null;
            }
            TradingLogWriter.TradingLogRecord e = l.get(rowIndex + 1);
            switch (columnIndex) {
                case 0: {
                    return e.time;
                }
                case 1: {
                    return e.action.toString();
                }
                case 2: {
                    return e.owner;
                }
                case 3: {
                    return e.orderID;
                }
                case 4: {
                    return Order.getTypeAsString(e.orderType);
                }
                case 5: {
                    return Float.valueOf(e.volume);
                }
                case 6: {
                    return Float.valueOf(e.limit);
                }
                case 7: {
                    return Float.valueOf(e.stop);
                }
                case 8: {
                    return Float.valueOf(e.trasaction_volume);
                }
                case 9: {
                    return Float.valueOf(e.transaction_price);
                }
            }
            return null;
        }

        @Override
        public int getColumnCount() {
            return 10;
        }

        @Override
        public String getColumnName(int column) {
            return this.colNames[column];
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return this.colTypes[columnIndex];
        }
    }
}

