/*
 * Decompiled with CFR 0.152.
 */
package gui.orderbook;

import gui.Globals;
import gui.orderbook.RawOrderBook;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import sesim.Market;
import sesim.OrderBookEntry;

public class OrderBook
extends RawOrderBook {
    TreeMap<Long, OrderBookEntry> lastMap = new TreeMap();

    @Override
    public void setGodMode(boolean on) {
        super.setGodMode(false);
    }

    private OrderBookEntry getDiffedEntry(OrderBookEntry oe) {
        OrderBookEntry prev = this.lastMap.get(oe.getLimit_Long());
        ColoredOrderBookEntry ce = new ColoredOrderBookEntry(oe);
        ce.color = prev == null ? "Gray" : (prev.getVolume() > oe.getVolume() ? "Red" : (prev.getVolume() < oe.getVolume() ? "Green" : "  ---  "));
        return ce;
    }

    @Override
    protected ArrayList<? extends OrderBookEntry> getOrderBook() {
        TreeMap<Long, OrderBookEntry> map2 = Globals.sim.getDefaultMarket().getCompressedOrderBook(this.type, this.depth);
        ArrayList<OrderBookEntry> r = new ArrayList<OrderBookEntry>();
        if (this.type == 2) {
            for (Map.Entry oe : map2.descendingMap().entrySet()) {
                r.add(this.getDiffedEntry((OrderBookEntry)oe.getValue()));
            }
        } else {
            for (Map.Entry<Long, OrderBookEntry> oe : map2.entrySet()) {
                r.add(this.getDiffedEntry(oe.getValue()));
            }
        }
        this.lastMap = map2;
        return r;
    }

    @Override
    protected JTable createList() {
        return new MyList();
    }

    @Override
    protected AbstractTableModel createModel() {
        return new MyModel();
    }

    class ColoredOrderBookEntry
    extends Market.CompOrderBookEntry {
        public String color;

        private ColoredOrderBookEntry(OrderBookEntry oe) {
            super(oe);
            this.color = new String();
        }

        @Override
        public String getOwnerName() {
            return this.color;
        }
    }

    class MyList
    extends JTable {
        MyList() {
        }

        @Override
        public Component prepareRenderer(TableCellRenderer renderer, int row, int column) {
            Component c = super.prepareRenderer(renderer, row, column);
            int modelRow = this.convertRowIndexToModel(row);
            Object firstColValue = this.getModel().getValueAt(modelRow, 0);
            if ("Red".equals(firstColValue)) {
                c.setBackground(Globals.colors.tableBgLightRed);
            } else if ("Gray".equals(firstColValue)) {
                c.setBackground(Globals.colors.tableBgLightGray);
            } else if ("Green".equals(firstColValue)) {
                c.setBackground(Globals.colors.tableBgLightGreen);
            } else {
                c.setBackground(OrderBook.this.list.getBackground());
            }
            return c;
        }
    }

    class MyModel
    extends RawOrderBook.RawOrderBookModel {
        MyModel() {
        }
    }
}

