/*
 * Decompiled with CFR 0.152.
 */
package gui.orderbook;

import gui.Globals;
import java.awt.Dimension;
import java.awt.Font;
import java.text.DecimalFormat;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import sesim.Market;
import sesim.Quote;

public class QuoteVertical
extends JPanel
implements Market.QuoteReceiver {
    DecimalFormat dfm = new DecimalFormat("0.00#");
    DecimalFormat dfv = new DecimalFormat("0.#");
    ExecutorService executor = Executors.newSingleThreadExecutor();
    private JLabel jLabel1;
    private JLabel quoteLabel;
    private JLabel volumeLabel;
    double last_price = -1.0;
    boolean busy;
    boolean update;
    Quote quote;

    public QuoteVertical() {
        this.initComponents();
        if (Globals.sim == null) {
            return;
        }
        this.reset();
    }

    public final void reset() {
        Quote q = Globals.sim.getDefaultMarket().getLastQuoete();
        this.UpdateQuote(q);
        Globals.sim.getDefaultMarket().addQuoteReceiver(this);
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.quoteLabel = new JLabel();
        this.volumeLabel = new JLabel();
        this.setMaximumSize(new Dimension(130, Short.MAX_VALUE));
        this.setMinimumSize(new Dimension(130, 0));
        this.jLabel1.setHorizontalAlignment(0);
        this.jLabel1.setText("<html><b>Price</b> (Vol)");
        this.quoteLabel.setFont(new Font("DejaVu Sans", 1, 12));
        this.quoteLabel.setHorizontalAlignment(0);
        this.quoteLabel.setText("--");
        this.quoteLabel.setFocusable(false);
        this.quoteLabel.setHorizontalTextPosition(0);
        this.volumeLabel.setHorizontalAlignment(0);
        this.volumeLabel.setText("(--)");
        GroupLayout layout2 = new GroupLayout(this);
        this.setLayout(layout2);
        layout2.setHorizontalGroup(layout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout2.createSequentialGroup().addContainerGap().addGroup(layout2.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1, -1, 118, Short.MAX_VALUE).addComponent(this.quoteLabel, -1, -1, Short.MAX_VALUE).addComponent(this.volumeLabel, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout2.setVerticalGroup(layout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout2.createSequentialGroup().addContainerGap().addComponent(this.jLabel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.quoteLabel, -2, 21, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.volumeLabel).addContainerGap(-1, Short.MAX_VALUE)));
    }

    @Override
    public void UpdateQuote(Quote q) {
        if (q == null) {
            return;
        }
        if (this.busy) {
            this.quote = q;
            this.update = true;
            return;
        }
        this.busy = true;
        this.update = true;
        this.executor.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    while (QuoteVertical.this.update) {
                        Quote q = QuoteVertical.this.quote;
                        QuoteVertical.this.update = false;
                        if (q == null) {
                            return;
                        }
                        SwingUtilities.invokeLater(() -> {
                            String text = QuoteVertical.this.dfm.format(q.getPrice());
                            String vtext = QuoteVertical.this.dfv.format(q.getVolume());
                            if (QuoteVertical.this.last_price == -1.0) {
                                text = "--";
                            } else if (q.getPrice() >= QuoteVertical.this.last_price) {
                                text = "<html>" + text + "<font color=\"green\">&#8593;</color></html>";
                            } else if (q.getPrice() < QuoteVertical.this.last_price) {
                                text = "<html>" + text + "<font color=\"red\">&#8595;</color></html>";
                            }
                            QuoteVertical.this.last_price = q.getPrice();
                            QuoteVertical.this.quoteLabel.setText(text);
                            QuoteVertical.this.volumeLabel.setText("(" + vtext + ")");
                        });
                        try {
                            Thread.sleep(50L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
                finally {
                    QuoteVertical.this.busy = false;
                }
            }
        });
    }
}

