/*
 * Decompiled with CFR 0.152.
 */
package gui.orderbook;

import gui.Globals;
import gui.orderbook.QuoteVertical;
import gui.orderbook.RawOrderBook;
import java.awt.Dimension;
import java.awt.Font;
import javax.swing.BoxLayout;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import sesim.Market;

public class RawOrderBooksHorizontal
extends JPanel {
    private RawOrderBook askBook;
    private JPanel askBookPanel;
    private RawOrderBook bidBook;
    private JPanel bidBookPanel;
    private JLabel leftTitle;
    private QuoteVertical quoteVertical2;
    private JLabel rightTitle;

    public RawOrderBooksHorizontal() {
        this.initComponents();
    }

    public final void start(Market se, byte leftType, byte rightType) {
        this.bidBook.start(Globals.sim.getDefaultMarket(), leftType);
        this.askBook.start(Globals.sim.getDefaultMarket(), rightType);
        this.quoteVertical2.reset();
    }

    public final void setTitles(String left, String right) {
        this.leftTitle.setText(left);
        this.rightTitle.setText(right);
    }

    public void setPriceColumn(byte t) {
        this.bidBook.setPriceColumn(t);
        this.askBook.setPriceColumn(t);
    }

    public void stop() {
        this.bidBook.stop();
        this.askBook.stop();
    }

    public void setDepth(int depth) {
        this.bidBook.depth = depth;
        this.askBook.depth = depth;
    }

    private void initComponents() {
        this.bidBookPanel = new JPanel();
        this.bidBook = new RawOrderBook();
        this.leftTitle = new JLabel();
        this.quoteVertical2 = new QuoteVertical();
        this.askBookPanel = new JPanel();
        this.askBook = new RawOrderBook();
        this.rightTitle = new JLabel();
        this.setLayout(new BoxLayout(this, 2));
        this.bidBookPanel.setPreferredSize(new Dimension(320, 296));
        this.leftTitle.setFont(new Font("DejaVu Sans", 1, 12));
        this.leftTitle.setHorizontalAlignment(0);
        this.leftTitle.setText("Bid");
        GroupLayout bidBookPanelLayout = new GroupLayout(this.bidBookPanel);
        this.bidBookPanel.setLayout(bidBookPanelLayout);
        bidBookPanelLayout.setHorizontalGroup(bidBookPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(bidBookPanelLayout.createSequentialGroup().addContainerGap().addGroup(bidBookPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.bidBook, -1, 244, Short.MAX_VALUE).addComponent(this.leftTitle, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        bidBookPanelLayout.setVerticalGroup(bidBookPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, bidBookPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.leftTitle).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.bidBook, -1, 269, Short.MAX_VALUE)));
        this.add(this.bidBookPanel);
        this.add(this.quoteVertical2);
        this.askBookPanel.setPreferredSize(new Dimension(320, 296));
        this.rightTitle.setFont(new Font("DejaVu Sans", 1, 12));
        this.rightTitle.setHorizontalAlignment(0);
        this.rightTitle.setText("Ask");
        GroupLayout askBookPanelLayout = new GroupLayout(this.askBookPanel);
        this.askBookPanel.setLayout(askBookPanelLayout);
        askBookPanelLayout.setHorizontalGroup(askBookPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(askBookPanelLayout.createSequentialGroup().addContainerGap().addGroup(askBookPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.askBook, -1, 244, Short.MAX_VALUE).addComponent(this.rightTitle, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        askBookPanelLayout.setVerticalGroup(askBookPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, askBookPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.rightTitle).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.askBook, -1, 269, Short.MAX_VALUE)));
        this.add(this.askBookPanel);
    }
}

