/*
 * Decompiled with CFR 0.152.
 */
package gui.util;

import java.awt.FlowLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.UIManager;

public class AdaptiveButtonPanel
extends JPanel {
    public final JButton okButton = new JButton("OK");
    public final JButton cancelButton = new JButton("Abbrechen");

    public AdaptiveButtonPanel() {
        super(new FlowLayout(2, 5, 5));
        this.okButton.putClientProperty("JButton.buttonType", "ok");
        this.cancelButton.putClientProperty("JButton.buttonType", "cancel");
        this.okButton.putClientProperty("action-role", "accept");
        this.cancelButton.putClientProperty("action-role", "cancel");
        this.setupButtonOrder();
    }

    private void setupButtonOrder() {
        boolean isCancelOkOrder = false;
        Object orientation = UIManager.get("OptionPane.buttonOrientation");
        if (orientation instanceof Integer) {
            isCancelOkOrder = (Integer)orientation > 0;
        }
        this.removeAll();
        if (isCancelOkOrder) {
            this.add(this.cancelButton);
            this.add(this.okButton);
        } else {
            this.add(this.okButton);
            this.add(this.cancelButton);
        }
        this.revalidate();
        this.repaint();
    }

    public String getOkButtonText() {
        return this.okButton.getText();
    }

    public void setOkButtonText(String text) {
        this.okButton.setText(text);
    }

    public String getCancelButtonText() {
        return this.cancelButton.getText();
    }

    public void setCancelButtonText(String text) {
        this.cancelButton.setText(text);
    }
}

