/*
 * Decompiled with CFR 0.152.
 */
package gui.util;

import java.awt.Color;
import java.util.HashMap;
import java.util.Map;

public final class ColorUtilsRGB {
    private static final Map<String, Color> CACHE = new HashMap<String, Color>();

    private ColorUtilsRGB() {
    }

    private static String key(Color base, Color bg) {
        return base.getRGB() + ":" + bg.getRGB();
    }

    public static Color readableRed(Color background) {
        return ColorUtilsRGB.readable(new Color(255, 0, 0), background);
    }

    public static Color readableGreen(Color background) {
        return ColorUtilsRGB.readable(new Color(0, 180, 0), background);
    }

    public static Color readable(Color base, Color background) {
        double ct;
        Color c;
        int i;
        double minct = 1.9;
        String k = ColorUtilsRGB.key(base, background);
        if (CACHE.containsKey(k)) {
            return CACHE.get(k);
        }
        if (ColorUtilsRGB.contrast(base, background) >= minct) {
            return base;
        }
        Color best = base;
        double bestContrast = ColorUtilsRGB.contrast(base, background);
        for (i = 0; i <= 255; ++i) {
            c = ColorUtilsRGB.lighten(base, i);
            ct = ColorUtilsRGB.contrast(c, background);
            if (ct >= minct) {
                return c;
            }
            if (!(ct > bestContrast)) continue;
            best = c;
            bestContrast = ct;
        }
        for (i = 0; i <= 255; ++i) {
            c = ColorUtilsRGB.darken(base, i);
            ct = ColorUtilsRGB.contrast(c, background);
            if (ct >= minct) {
                return c;
            }
            if (!(ct > bestContrast)) continue;
            best = c;
            bestContrast = ct;
        }
        return best;
    }

    private static double luminance(Color c) {
        double r = (double)c.getRed() / 255.0;
        double g = (double)c.getGreen() / 255.0;
        double b = (double)c.getBlue() / 255.0;
        return 0.2126 * r + 0.7152 * g + 0.0722 * b;
    }

    private static double contrast(Color a, Color b) {
        double l1 = ColorUtilsRGB.luminance(a);
        double l2 = ColorUtilsRGB.luminance(b);
        return (Math.max(l1, l2) + 0.05) / (Math.min(l1, l2) + 0.05);
    }

    private static Color lighten(Color c, int amount) {
        return new Color(ColorUtilsRGB.clamp(c.getRed() + amount), ColorUtilsRGB.clamp(c.getGreen() + amount), ColorUtilsRGB.clamp(c.getBlue() + amount));
    }

    private static Color darken(Color c, int amount) {
        return new Color(ColorUtilsRGB.clamp(c.getRed() - amount), ColorUtilsRGB.clamp(c.getGreen() - amount), ColorUtilsRGB.clamp(c.getBlue() - amount));
    }

    private static int clamp(int v) {
        return Math.max(0, Math.min(255, v));
    }
}

