/*
 * Decompiled with CFR 0.152.
 */
package gui.util;

import java.awt.Font;
import java.awt.Toolkit;
import java.util.Enumeration;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.plaf.FontUIResource;

public final class HiDPIScaler {
    public static void autoScale() {
        double scale = (double)Toolkit.getDefaultToolkit().getScreenResolution() / 96.0;
        if (scale <= 1.05) {
            return;
        }
        UIDefaults ui = UIManager.getLookAndFeelDefaults();
        Font baseFont = ui.getFont("defaultFont");
        if (baseFont == null) {
            baseFont = UIManager.getFont("Label.font");
        }
        if (baseFont != null && baseFont.getSize() > 13) {
            return;
        }
        Enumeration e = ui.keys();
        while (e.hasMoreElements()) {
            Object key = e.nextElement();
            Object value = ui.get(key);
            if (!(value instanceof Font)) continue;
            Font f = (Font)value;
            float newSize = (float)((double)f.getSize2D() * scale);
            ui.put(key, new FontUIResource(f.deriveFont(newSize)));
        }
    }
}

