/*
 * Decompiled with CFR 0.152.
 */
package gui.util;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JTextField;
import org.json.JSONObject;

public class Json {
    public static JSONObject get(Object o) {
        Method[] methods;
        Field[] fields = o.getClass().getFields();
        JSONObject jo = new JSONObject();
        for (Field f : fields) {
            Class<?> cls;
            Export exp = f.getAnnotation(Export.class);
            if (exp == null || !JTextField.class.isAssignableFrom(cls = f.getType())) continue;
            try {
                JTextField tf = (JTextField)f.get(o);
                String name = null == exp.value() ? f.getName() : exp.value();
                jo.put(name, tf.getText());
            }
            catch (IllegalAccessException | IllegalArgumentException ex1) {
                Logger.getLogger(Json.class.getName()).log(Level.SEVERE, null, ex1);
            }
        }
        for (Method m : methods = o.getClass().getMethods()) {
            Export exp = m.getAnnotation(Export.class);
            if (exp == null) continue;
            if (m.getParameterCount() != 0) {
                Logger.getLogger(Json.class.getName()).log(Level.SEVERE, null, "Wrong pcount");
                continue;
            }
            String name = null == exp.value() ? m.getName() : exp.value();
            Class<?> rt = m.getReturnType();
            if (!String.class.isAssignableFrom(rt)) continue;
            try {
                String str = (String)m.invoke(o, new Object[0]);
                jo.put(name, str);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException ex) {
                Logger.getLogger(Json.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return jo;
    }

    public static void put(Object o, JSONObject jo) {
        Method[] methods;
        String name;
        Field[] fields;
        for (Field f : fields = o.getClass().getFields()) {
            Import imp = f.getAnnotation(Import.class);
            if (imp == null) continue;
            Class<?> cls = f.getType();
            String string = name = null == imp.value() ? f.getName() : imp.value();
            if (JTextField.class.isAssignableFrom(cls)) {
                try {
                    JTextField tf = (JTextField)f.get(o);
                    tf.setText(jo.optString(name));
                }
                catch (IllegalAccessException | IllegalArgumentException ex1) {
                    Logger.getLogger(Json.class.getName()).log(Level.SEVERE, null, ex1);
                }
                continue;
            }
            if (!String.class.isAssignableFrom(cls)) continue;
            try {
                f.set(o, jo.optString(name));
            }
            catch (IllegalAccessException | IllegalArgumentException ex1) {
                Logger.getLogger(Json.class.getName()).log(Level.SEVERE, null, ex1);
            }
        }
        for (Method m : methods = o.getClass().getMethods()) {
            Import imp = m.getAnnotation(Import.class);
            if (imp == null) continue;
            if (m.getParameterCount() != 1) {
                Logger.getLogger(Json.class.getName()).log(Level.SEVERE, null, "Wrong pcount");
                continue;
            }
            name = null == imp.value() ? m.getName() : imp.value();
            Class<?> p0 = m.getParameterTypes()[0];
            if (!String.class.isAssignableFrom(p0)) continue;
            String param = jo.optString(name, "");
            try {
                m.invoke(o, param);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException ex) {
                Logger.getLogger(Json.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD, ElementType.METHOD})
    public static @interface Export {
        public String value() default "";
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD, ElementType.METHOD})
    public static @interface Import {
        public String value() default "";
    }
}

