/*
 * Decompiled with CFR 0.152.
 */
package gui.util;

import java.awt.Component;
import java.text.DecimalFormat;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

public class NummericCellRenderer
extends DefaultTableCellRenderer {
    private final DecimalFormat formatter;

    public NummericCellRenderer(int decimals) {
        String s = "#0.";
        if (decimals == 0) {
            s = "#";
        } else {
            for (int i = 0; i < decimals; ++i) {
                s = s + "0";
            }
        }
        this.formatter = new DecimalFormat(s);
        this.setHorizontalAlignment(4);
    }

    public NummericCellRenderer(DecimalFormat formatter) {
        this.formatter = formatter;
        this.setHorizontalAlignment(4);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table2, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (!(value instanceof Number)) {
            return super.getTableCellRendererComponent(table2, value, isSelected, hasFocus, row, column);
        }
        Number number = (Number)value;
        double val = number.doubleValue();
        String text = Math.abs(val) >= 1.0E9 ? this.formatter.format(val / 1.0E9) + "B" : (Math.abs(val) >= 1000000.0 ? this.formatter.format(val / 1000000.0) + "M" : this.formatter.format(val));
        return super.getTableCellRendererComponent(table2, text, isSelected, hasFocus, row, column);
    }
}

