/*
 * Decompiled with CFR 0.152.
 */
package indicators;

import indicators.BaseIndicator;
import org.json.JSONObject;
import sesim.OHLCData;
import sesim.OHLCDataItem;

public class SMAIndicator
extends BaseIndicator {
    private OHLCData parent;
    OHLCData indicator;
    final String LEN = "len";
    int len = 60;

    public void setParent(OHLCData parent) {
        this.parent = parent;
    }

    public void putConfig(JSONObject cfg) {
        this.len = cfg.getInt("len");
    }

    public JSONObject getConfig() {
        JSONObject r = new JSONObject();
        r.put("len", this.len);
        return r;
    }

    private float getAt(int pos) {
        if (this.parent.size() == 0) {
            return 0.0f;
        }
        int start = pos - this.len;
        if (start < 0) {
            start = 0;
        }
        float sum2 = 0.0f;
        for (int i = start; i <= pos; ++i) {
            sum2 = (float)((double)sum2 + this.parent.get(i).getClose());
        }
        return sum2 / (float)(pos - start + 1);
    }

    public void update() {
        if (this.parent.size() == 0) {
            return;
        }
        if (this.parent.size() == this.indicator.size()) {
            int i = this.parent.size() - 1;
            OHLCDataItem p = this.parent.get(i);
            float pr = this.getAt(i);
            return;
        }
        for (int i = this.indicator.size(); i < this.parent.size(); ++i) {
            OHLCDataItem p = this.parent.get(i);
            float f = this.getAt(i);
        }
    }

    public OHLCData getData() {
        this.update();
        return this.indicator;
    }
}

