/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.api.list.primitive;

import java.util.Spliterator;
import java.util.stream.DoubleStream;
import java.util.stream.StreamSupport;
import org.eclipse.collections.api.DoubleIterable;
import org.eclipse.collections.api.block.function.primitive.DoubleIntToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.DoubleToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.DoublePredicate;
import org.eclipse.collections.api.block.procedure.primitive.DoubleProcedure;
import org.eclipse.collections.api.list.ListIterable;
import org.eclipse.collections.api.list.primitive.ImmutableDoubleList;
import org.eclipse.collections.api.ordered.primitive.ReversibleDoubleIterable;
import org.eclipse.collections.api.tuple.primitive.DoubleDoublePair;
import org.eclipse.collections.api.tuple.primitive.DoubleObjectPair;

public interface DoubleList
extends ReversibleDoubleIterable {
    public double get(int var1);

    public double dotProduct(DoubleList var1);

    public int binarySearch(double var1);

    public int lastIndexOf(double var1);

    @Override
    public DoubleList select(DoublePredicate var1);

    @Override
    public DoubleList reject(DoublePredicate var1);

    @Override
    default public DoubleList tap(DoubleProcedure procedure) {
        this.forEach(procedure);
        return this;
    }

    public <V> ListIterable<V> collect(DoubleToObjectFunction<? extends V> var1);

    default public <V> ListIterable<V> collectWithIndex(DoubleIntToObjectFunction<? extends V> function) {
        int[] index = new int[]{0};
        return this.collect((double each2) -> {
            int n = index[0];
            index[0] = n + 1;
            return function.value(each2, n);
        });
    }

    public boolean equals(Object var1);

    public int hashCode();

    public ImmutableDoubleList toImmutable();

    @Override
    public DoubleList distinct();

    @Override
    public DoubleList toReversed();

    public DoubleList subList(int var1, int var2);

    default public ListIterable<DoubleDoublePair> zipDouble(DoubleIterable iterable) {
        throw new UnsupportedOperationException("Default method to prevent breaking backwards compatibility");
    }

    default public <T> ListIterable<DoubleObjectPair<T>> zip(Iterable<T> iterable) {
        throw new UnsupportedOperationException("Default method to prevent breaking backwards compatibility");
    }

    public Spliterator.OfDouble spliterator();

    default public DoubleStream primitiveStream() {
        return StreamSupport.doubleStream(this.spliterator(), false);
    }

    default public DoubleStream primitiveParallelStream() {
        return StreamSupport.doubleStream(this.spliterator(), true);
    }
}

