/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.lazy.primitive;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.eclipse.collections.api.CharIterable;
import org.eclipse.collections.api.block.function.Function0;
import org.eclipse.collections.api.block.procedure.Procedure;
import org.eclipse.collections.api.collection.primitive.MutableCharCollection;
import org.eclipse.collections.api.iterator.CharIterator;
import org.eclipse.collections.impl.factory.primitive.CharLists;
import org.eclipse.collections.impl.lazy.AbstractLazyIterable;
import org.eclipse.collections.impl.utility.internal.IterableIterate;

public class ChunkCharIterable
extends AbstractLazyIterable<CharIterable> {
    private final CharIterable adapted;
    private final int size;

    public ChunkCharIterable(CharIterable delegate, int size2) {
        if (size2 <= 0) {
            throw new IllegalArgumentException("Size for groups must be positive but was: " + size2);
        }
        this.adapted = delegate;
        this.size = size2;
    }

    @Override
    public Iterator<CharIterable> iterator() {
        return new ChunkCharIterator(this.adapted, this.size);
    }

    @Override
    public void each(Procedure<? super CharIterable> procedure) {
        IterableIterate.forEach(this, procedure);
    }

    public static class ChunkCharIterator
    implements Iterator<CharIterable> {
        private final CharIterator iterator;
        private final int size;
        private final Function0<MutableCharCollection> speciesNewStrategy;

        public ChunkCharIterator(CharIterable iterable, int size2) {
            if (size2 <= 0) {
                throw new IllegalArgumentException("Size for groups must be positive but was: " + size2);
            }
            this.size = size2;
            this.iterator = iterable.charIterator();
            this.speciesNewStrategy = iterable instanceof MutableCharCollection ? ((MutableCharCollection)iterable)::newEmpty : CharLists.mutable::empty;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public CharIterable next() {
            if (!this.iterator.hasNext()) {
                throw new NoSuchElementException();
            }
            MutableCharCollection result = this.speciesNewStrategy.value();
            for (int i = this.size; i > 0 && this.iterator.hasNext(); --i) {
                result.add(this.iterator.next());
            }
            return result;
        }
    }
}

