/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.map.immutable.primitive;

import org.eclipse.collections.api.block.function.primitive.ByteFunction;
import org.eclipse.collections.api.block.function.primitive.DoubleFunction;
import org.eclipse.collections.api.factory.map.primitive.ImmutableByteDoubleMapFactory;
import org.eclipse.collections.api.map.primitive.ByteDoubleMap;
import org.eclipse.collections.api.map.primitive.ImmutableByteDoubleMap;
import org.eclipse.collections.impl.factory.primitive.ByteDoubleMaps;
import org.eclipse.collections.impl.map.immutable.primitive.ImmutableByteDoubleEmptyMap;
import org.eclipse.collections.impl.map.immutable.primitive.ImmutableByteDoubleHashMap;
import org.eclipse.collections.impl.map.immutable.primitive.ImmutableByteDoubleSingletonMap;

public enum ImmutableByteDoubleMapFactoryImpl implements ImmutableByteDoubleMapFactory
{
    INSTANCE;


    @Override
    public ImmutableByteDoubleMap empty() {
        return ImmutableByteDoubleEmptyMap.INSTANCE;
    }

    @Override
    public ImmutableByteDoubleMap of() {
        return this.empty();
    }

    @Override
    public ImmutableByteDoubleMap with() {
        return this.empty();
    }

    @Override
    public ImmutableByteDoubleMap of(byte key, double value) {
        return this.with(key, value);
    }

    @Override
    public ImmutableByteDoubleMap with(byte key, double value) {
        return new ImmutableByteDoubleSingletonMap(key, value);
    }

    @Override
    public ImmutableByteDoubleMap ofAll(ByteDoubleMap map2) {
        return this.withAll(map2);
    }

    @Override
    public ImmutableByteDoubleMap withAll(ByteDoubleMap map2) {
        if (map2 instanceof ImmutableByteDoubleMap) {
            return (ImmutableByteDoubleMap)map2;
        }
        if (map2.isEmpty()) {
            return this.with();
        }
        if (map2.size() == 1) {
            byte key = map2.keysView().byteIterator().next();
            return new ImmutableByteDoubleSingletonMap(key, map2.get(key));
        }
        return new ImmutableByteDoubleHashMap(map2);
    }

    @Override
    public <T> ImmutableByteDoubleMap from(Iterable<T> iterable, ByteFunction<? super T> keyFunction, DoubleFunction<? super T> valueFunction) {
        return ByteDoubleMaps.mutable.from(iterable, keyFunction, valueFunction).toImmutable();
    }
}

