/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.map.immutable.primitive;

import org.eclipse.collections.api.block.function.Function;
import org.eclipse.collections.api.block.function.primitive.DoubleFunction;
import org.eclipse.collections.api.factory.map.primitive.ImmutableDoubleObjectMapFactory;
import org.eclipse.collections.api.map.primitive.DoubleObjectMap;
import org.eclipse.collections.api.map.primitive.ImmutableDoubleObjectMap;
import org.eclipse.collections.api.map.primitive.MutableDoubleObjectMap;
import org.eclipse.collections.impl.factory.primitive.DoubleObjectMaps;
import org.eclipse.collections.impl.map.immutable.primitive.ImmutableDoubleObjectEmptyMap;
import org.eclipse.collections.impl.map.immutable.primitive.ImmutableDoubleObjectHashMap;
import org.eclipse.collections.impl.map.immutable.primitive.ImmutableDoubleObjectSingletonMap;

public enum ImmutableDoubleObjectMapFactoryImpl implements ImmutableDoubleObjectMapFactory
{
    INSTANCE;


    @Override
    public <V> ImmutableDoubleObjectMap<V> empty() {
        return ImmutableDoubleObjectEmptyMap.INSTANCE;
    }

    @Override
    public <V> ImmutableDoubleObjectMap<V> of() {
        return this.empty();
    }

    @Override
    public <V> ImmutableDoubleObjectMap<V> with() {
        return this.empty();
    }

    @Override
    public <V> ImmutableDoubleObjectMap<V> of(double key, V value) {
        return this.with(key, value);
    }

    @Override
    public <V> ImmutableDoubleObjectMap<V> with(double key, V value) {
        return new ImmutableDoubleObjectSingletonMap<V>(key, value);
    }

    @Override
    public <V> ImmutableDoubleObjectMap<V> ofAll(DoubleObjectMap<? extends V> map2) {
        return this.withAll(map2);
    }

    @Override
    public <V> ImmutableDoubleObjectMap<V> withAll(DoubleObjectMap<? extends V> map2) {
        if (map2 instanceof ImmutableDoubleObjectMap) {
            return (ImmutableDoubleObjectMap)map2;
        }
        if (map2.isEmpty()) {
            return this.with();
        }
        if (map2.size() == 1) {
            double[] array = new double[1];
            map2.forEachKey(each2 -> {
                array[0] = each2;
            });
            return new ImmutableDoubleObjectSingletonMap<V>(array[0], map2.get(array[0]));
        }
        return new ImmutableDoubleObjectHashMap<V>(map2);
    }

    @Override
    public <T, V> ImmutableDoubleObjectMap<V> from(Iterable<T> iterable, DoubleFunction<? super T> keyFunction, Function<? super T, ? extends V> valueFunction) {
        MutableDoubleObjectMap<V> map2 = DoubleObjectMaps.mutable.from(iterable, keyFunction, valueFunction);
        return map2.toImmutable();
    }
}

