/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.map.mutable.primitive;

import java.io.IOException;
import java.io.Serializable;
import java.util.NoSuchElementException;
import org.eclipse.collections.api.block.function.primitive.FloatToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectFloatToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.FloatPredicate;
import org.eclipse.collections.api.block.procedure.primitive.FloatProcedure;
import org.eclipse.collections.api.iterator.FloatIterator;
import org.eclipse.collections.api.set.ImmutableSet;
import org.eclipse.collections.api.set.primitive.ImmutableFloatSet;
import org.eclipse.collections.impl.SpreadFunctions;
import org.eclipse.collections.impl.set.immutable.primitive.AbstractImmutableFloatSet;
import org.eclipse.collections.impl.set.immutable.primitive.ImmutableFloatSetSerializationProxy;
import org.eclipse.collections.impl.set.mutable.UnifiedSet;
import org.eclipse.collections.impl.set.mutable.primitive.FloatHashSet;

class ImmutableFloatMapKeySet
extends AbstractImmutableFloatSet
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final float EMPTY_KEY = 0.0f;
    private static final float REMOVED_KEY = 1.0f;
    private static final int CACHE_LINE_SIZE = 64;
    private static final int KEY_SIZE = 4;
    private static final int INITIAL_LINEAR_PROBE = 8;
    private final float[] keys;
    private final int occupiedWithData;
    private final boolean containsZeroKey;
    private final boolean containsOneKey;

    ImmutableFloatMapKeySet(float[] keys2, int occupiedWithData, boolean containsZeroKey, boolean containsOneKey) {
        this.keys = keys2;
        this.occupiedWithData = occupiedWithData;
        this.containsZeroKey = containsZeroKey;
        this.containsOneKey = containsOneKey;
    }

    private static boolean isEmptyKey(float key) {
        return Float.compare(key, 0.0f) == 0;
    }

    private static boolean isRemovedKey(float key) {
        return Float.compare(key, 1.0f) == 0;
    }

    private static boolean isNonSentinel(float key) {
        return !ImmutableFloatMapKeySet.isEmptyKey(key) && !ImmutableFloatMapKeySet.isRemovedKey(key);
    }

    @Override
    public int hashCode() {
        int result = 0;
        if (this.containsZeroKey) {
            result += Float.floatToIntBits(0.0f);
        }
        if (this.containsOneKey) {
            result += Float.floatToIntBits(1.0f);
        }
        if (this.keys != null) {
            for (int i = 0; i < this.keys.length; ++i) {
                if (!ImmutableFloatMapKeySet.isNonSentinel(this.keys[i])) continue;
                result += Float.floatToIntBits(this.keys[i]);
            }
        }
        return result;
    }

    @Override
    public int size() {
        return this.occupiedWithData + (this.containsOneKey ? 1 : 0) + (this.containsZeroKey ? 1 : 0);
    }

    @Override
    public void appendString(Appendable appendable, String start, String separator, String end) {
        try {
            appendable.append(start);
            int count2 = 0;
            if (this.containsZeroKey) {
                appendable.append(String.valueOf(0.0f));
                ++count2;
            }
            if (this.containsOneKey) {
                if (count2 > 0) {
                    appendable.append(separator);
                }
                ++count2;
                appendable.append(String.valueOf(1.0f));
            }
            for (int i = 0; i < this.keys.length; ++i) {
                if (!ImmutableFloatMapKeySet.isNonSentinel(this.keys[i])) continue;
                if (count2 > 0) {
                    appendable.append(separator);
                }
                ++count2;
                appendable.append(String.valueOf(this.keys[i]));
            }
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public FloatIterator floatIterator() {
        return new InternalFloatIterator();
    }

    @Override
    public float[] toArray() {
        float[] array = new float[this.size()];
        int index = 0;
        if (this.containsZeroKey) {
            array[index] = 0.0f;
            ++index;
        }
        if (this.containsOneKey) {
            array[index] = 1.0f;
            ++index;
        }
        if (this.keys != null) {
            for (int i = 0; i < this.keys.length; ++i) {
                if (!ImmutableFloatMapKeySet.isNonSentinel(this.keys[i])) continue;
                array[index] = this.keys[i];
                ++index;
            }
        }
        return array;
    }

    @Override
    public float[] toArray(float[] array) {
        if (array.length < this.size()) {
            array = new float[this.size()];
        }
        int index = 0;
        if (this.containsZeroKey) {
            array[index] = 0.0f;
            ++index;
        }
        if (this.containsOneKey) {
            array[index] = 1.0f;
            ++index;
        }
        if (this.keys != null) {
            for (int i = 0; i < this.keys.length; ++i) {
                if (!ImmutableFloatMapKeySet.isNonSentinel(this.keys[i])) continue;
                array[index] = this.keys[i];
                ++index;
            }
        }
        return array;
    }

    @Override
    public boolean contains(float value) {
        if (Float.compare(value, 0.0f) == 0) {
            return this.containsZeroKey;
        }
        if (Float.compare(value, 1.0f) == 0) {
            return this.containsOneKey;
        }
        return Float.compare(this.keys[this.probe(value)], value) == 0;
    }

    @Override
    public void forEach(FloatProcedure procedure) {
        this.each(procedure);
    }

    @Override
    public void each(FloatProcedure procedure) {
        if (this.containsZeroKey) {
            procedure.value(0.0f);
        }
        if (this.containsOneKey) {
            procedure.value(1.0f);
        }
        if (this.keys != null) {
            for (int i = 0; i < this.keys.length; ++i) {
                if (!ImmutableFloatMapKeySet.isNonSentinel(this.keys[i])) continue;
                procedure.value(this.keys[i]);
            }
        }
    }

    @Override
    public ImmutableFloatSet select(FloatPredicate predicate) {
        FloatHashSet result = new FloatHashSet();
        if (this.containsZeroKey && predicate.accept(0.0f)) {
            result.add(0.0f);
        }
        if (this.containsOneKey && predicate.accept(1.0f)) {
            result.add(1.0f);
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ImmutableFloatMapKeySet.isNonSentinel(this.keys[i]) || !predicate.accept(this.keys[i])) continue;
            result.add(this.keys[i]);
        }
        return result.toImmutable();
    }

    @Override
    public ImmutableFloatSet reject(FloatPredicate predicate) {
        FloatHashSet result = new FloatHashSet();
        if (this.containsZeroKey && !predicate.accept(0.0f)) {
            result.add(0.0f);
        }
        if (this.containsOneKey && !predicate.accept(1.0f)) {
            result.add(1.0f);
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ImmutableFloatMapKeySet.isNonSentinel(this.keys[i]) || predicate.accept(this.keys[i])) continue;
            result.add(this.keys[i]);
        }
        return result.toImmutable();
    }

    @Override
    public <V> ImmutableSet<V> collect(FloatToObjectFunction<? extends V> function) {
        UnifiedSet target = UnifiedSet.newSet(this.size());
        if (this.containsZeroKey) {
            target.add(function.valueOf(0.0f));
        }
        if (this.containsOneKey) {
            target.add(function.valueOf(1.0f));
        }
        if (this.keys != null) {
            for (int i = 0; i < this.keys.length; ++i) {
                if (!ImmutableFloatMapKeySet.isNonSentinel(this.keys[i])) continue;
                target.add(function.valueOf(this.keys[i]));
            }
        }
        return target.toImmutable();
    }

    @Override
    public float detectIfNone(FloatPredicate predicate, float ifNone) {
        if (this.containsZeroKey && predicate.accept(0.0f)) {
            return 0.0f;
        }
        if (this.containsOneKey && predicate.accept(1.0f)) {
            return 1.0f;
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ImmutableFloatMapKeySet.isNonSentinel(this.keys[i]) || !predicate.accept(this.keys[i])) continue;
            return this.keys[i];
        }
        return ifNone;
    }

    @Override
    public int count(FloatPredicate predicate) {
        int count2 = 0;
        if (this.containsZeroKey && predicate.accept(0.0f)) {
            ++count2;
        }
        if (this.containsOneKey && predicate.accept(1.0f)) {
            ++count2;
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ImmutableFloatMapKeySet.isNonSentinel(this.keys[i]) || !predicate.accept(this.keys[i])) continue;
            ++count2;
        }
        return count2;
    }

    @Override
    public boolean anySatisfy(FloatPredicate predicate) {
        if (this.containsZeroKey && predicate.accept(0.0f)) {
            return true;
        }
        if (this.containsOneKey && predicate.accept(1.0f)) {
            return true;
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ImmutableFloatMapKeySet.isNonSentinel(this.keys[i]) || !predicate.accept(this.keys[i])) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean allSatisfy(FloatPredicate predicate) {
        if (this.containsZeroKey && !predicate.accept(0.0f)) {
            return false;
        }
        if (this.containsOneKey && !predicate.accept(1.0f)) {
            return false;
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ImmutableFloatMapKeySet.isNonSentinel(this.keys[i]) || predicate.accept(this.keys[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean noneSatisfy(FloatPredicate predicate) {
        if (this.containsZeroKey && predicate.accept(0.0f)) {
            return false;
        }
        if (this.containsOneKey && predicate.accept(1.0f)) {
            return false;
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ImmutableFloatMapKeySet.isNonSentinel(this.keys[i]) || !predicate.accept(this.keys[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public double sum() {
        double nextSum;
        double adjustedValue;
        double result = 0.0;
        double compensation = 0.0;
        if (this.containsZeroKey) {
            adjustedValue = 0.0 - compensation;
            nextSum = result + adjustedValue;
            compensation = nextSum - result - adjustedValue;
            result = nextSum;
        }
        if (this.containsOneKey) {
            adjustedValue = 1.0 - compensation;
            nextSum = result + adjustedValue;
            compensation = nextSum - result - adjustedValue;
            result = nextSum;
        }
        if (this.keys != null) {
            for (int i = 0; i < this.keys.length; ++i) {
                if (!ImmutableFloatMapKeySet.isNonSentinel(this.keys[i])) continue;
                double adjustedValue2 = (double)this.keys[i] - compensation;
                double nextSum2 = result + adjustedValue2;
                compensation = nextSum2 - result - adjustedValue2;
                result = nextSum2;
            }
        }
        return result;
    }

    @Override
    public float max() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        float max2 = 0.0f;
        boolean isMaxSet = false;
        if (this.containsZeroKey) {
            max2 = 0.0f;
            isMaxSet = true;
        }
        if (this.containsOneKey && (!isMaxSet || Float.compare(max2, 1.0f) < 0)) {
            max2 = 1.0f;
            isMaxSet = true;
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ImmutableFloatMapKeySet.isNonSentinel(this.keys[i]) || isMaxSet && Float.compare(max2, this.keys[i]) >= 0) continue;
            max2 = this.keys[i];
            isMaxSet = true;
        }
        return max2;
    }

    @Override
    public float min() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        float min2 = 0.0f;
        boolean isMinSet = false;
        if (this.containsZeroKey) {
            min2 = 0.0f;
            isMinSet = true;
        }
        if (this.containsOneKey && (!isMinSet || 1.0f < min2)) {
            min2 = 1.0f;
            isMinSet = true;
        }
        for (int i = 0; i < this.keys.length; ++i) {
            if (!ImmutableFloatMapKeySet.isNonSentinel(this.keys[i]) || isMinSet && Float.compare(this.keys[i], min2) >= 0) continue;
            min2 = this.keys[i];
            isMinSet = true;
        }
        return min2;
    }

    @Override
    public <T> T injectInto(T injectedValue, ObjectFloatToObjectFunction<? super T, ? extends T> function) {
        T result = injectedValue;
        if (this.containsZeroKey) {
            result = function.valueOf(result, 0.0f);
        }
        if (this.containsOneKey) {
            result = function.valueOf(result, 1.0f);
        }
        if (this.keys != null) {
            for (int i = 0; i < this.keys.length; ++i) {
                if (!ImmutableFloatMapKeySet.isNonSentinel(this.keys[i])) continue;
                result = function.valueOf(result, this.keys[i]);
            }
        }
        return result;
    }

    private Object writeReplace() {
        return new ImmutableFloatSetSerializationProxy(this);
    }

    int probe(float element) {
        int index = this.mask((int)element);
        float keyAtIndex = this.keys[index];
        if (Float.compare(keyAtIndex, element) == 0 || Float.compare(keyAtIndex, 0.0f) == 0) {
            return index;
        }
        int removedIndex = Float.compare(keyAtIndex, 1.0f) == 0 ? index : -1;
        for (int i = 1; i < 8; ++i) {
            int nextIndex = index + i & this.keys.length - 1;
            keyAtIndex = this.keys[nextIndex];
            if (Float.compare(keyAtIndex, element) == 0) {
                return nextIndex;
            }
            if (Float.compare(keyAtIndex, 0.0f) == 0) {
                return removedIndex == -1 ? nextIndex : removedIndex;
            }
            if (Float.compare(keyAtIndex, 1.0f) != 0 || removedIndex != -1) continue;
            removedIndex = nextIndex;
        }
        return this.probeTwo(element, removedIndex);
    }

    int probeTwo(float element, int removedIndex) {
        int index = this.spreadTwoAndMask(element);
        for (int i = 0; i < 8; ++i) {
            int nextIndex = index + i & this.keys.length - 1;
            float keyAtIndex = this.keys[nextIndex];
            if (Float.compare(keyAtIndex, element) == 0) {
                return nextIndex;
            }
            if (Float.compare(keyAtIndex, 0.0f) == 0) {
                return removedIndex == -1 ? nextIndex : removedIndex;
            }
            if (Float.compare(keyAtIndex, 1.0f) != 0 || removedIndex != -1) continue;
            removedIndex = nextIndex;
        }
        return this.probeThree(element, removedIndex);
    }

    int probeThree(float element, int removedIndex) {
        int nextIndex = SpreadFunctions.floatSpreadOne(element);
        int spreadTwo = Integer.reverse(SpreadFunctions.floatSpreadTwo(element)) | 1;
        float keyAtIndex;
        while (Float.compare(keyAtIndex = this.keys[nextIndex = this.mask(nextIndex + spreadTwo)], element) != 0) {
            if (Float.compare(keyAtIndex, 0.0f) == 0) {
                return removedIndex == -1 ? nextIndex : removedIndex;
            }
            if (Float.compare(keyAtIndex, 1.0f) != 0 || removedIndex != -1) continue;
            removedIndex = nextIndex;
        }
        return nextIndex;
    }

    int spreadAndMask(float element) {
        int code = SpreadFunctions.floatSpreadOne(element);
        return this.mask(code);
    }

    int spreadTwoAndMask(float element) {
        int code = SpreadFunctions.floatSpreadTwo(element);
        return this.mask(code);
    }

    private int mask(int spread) {
        return spread & this.keys.length - 1;
    }

    private class InternalFloatIterator
    implements FloatIterator {
        private int count;
        private int position;
        private boolean handledZero;
        private boolean handledOne;

        private InternalFloatIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.count < ImmutableFloatMapKeySet.this.size();
        }

        @Override
        public float next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("next() called, but the iterator is exhausted");
            }
            ++this.count;
            if (!this.handledZero) {
                this.handledZero = true;
                if (ImmutableFloatMapKeySet.this.containsZeroKey) {
                    return 0.0f;
                }
            }
            if (!this.handledOne) {
                this.handledOne = true;
                if (ImmutableFloatMapKeySet.this.containsOneKey) {
                    return 1.0f;
                }
            }
            float[] keys2 = ImmutableFloatMapKeySet.this.keys;
            while (!ImmutableFloatMapKeySet.isNonSentinel(keys2[this.position])) {
                ++this.position;
            }
            float result = ImmutableFloatMapKeySet.this.keys[this.position];
            ++this.position;
            return result;
        }
    }
}

