/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.multimap.bag;

import java.io.Serializable;
import org.eclipse.collections.api.bag.MutableBag;
import org.eclipse.collections.api.block.function.Function;
import org.eclipse.collections.api.block.function.Function2;
import org.eclipse.collections.api.block.predicate.Predicate2;
import org.eclipse.collections.api.multimap.bag.ImmutableBagMultimap;
import org.eclipse.collections.api.multimap.bag.MutableBagMultimap;
import org.eclipse.collections.api.tuple.Pair;
import org.eclipse.collections.impl.multimap.AbstractSynchronizedMultimap;

public class SynchronizedBagMultimap<K, V>
extends AbstractSynchronizedMultimap<K, V>
implements MutableBagMultimap<K, V>,
Serializable {
    private static final long serialVersionUID = 1L;

    public SynchronizedBagMultimap(MutableBagMultimap<K, V> multimap) {
        super(multimap);
    }

    public SynchronizedBagMultimap(MutableBagMultimap<K, V> multimap, Object newLock) {
        super(multimap, newLock);
    }

    public static <K, V> SynchronizedBagMultimap<K, V> of(MutableBagMultimap<K, V> multimap) {
        if (multimap == null) {
            throw new IllegalArgumentException("cannot create a SynchronizedBagMultimap for null");
        }
        return new SynchronizedBagMultimap<K, V>(multimap);
    }

    public static <K, V> SynchronizedBagMultimap<K, V> of(MutableBagMultimap<K, V> multimap, Object lock) {
        if (multimap == null) {
            throw new IllegalArgumentException("cannot create a SynchronizedBagMultimap for null");
        }
        return new SynchronizedBagMultimap<K, V>(multimap, lock);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableBag<V> replaceValues(K key, Iterable<? extends V> values2) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().replaceValues((Object)key, (Iterable)values2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableBag<V> removeAll(Object key) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().removeAll(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableBagMultimap<K, V> newEmpty() {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().newEmpty().asSynchronized();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableBag<V> get(K key) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().get((Object)key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableBag<V> getIfAbsentPutAll(K key, Iterable<? extends V> values2) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().getIfAbsentPutAll((Object)key, (Iterable)values2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableBagMultimap<K, V> toMutable() {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().toMutable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ImmutableBagMultimap<K, V> toImmutable() {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().toImmutable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void putOccurrences(K key, V value, int occurrences) {
        Object object = this.getLock();
        synchronized (object) {
            this.getDelegate().putOccurrences(key, value, occurrences);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableBagMultimap<V, K> flip() {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().flip();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableBagMultimap<K, V> selectKeysValues(Predicate2<? super K, ? super V> predicate) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().selectKeysValues((Predicate2)predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableBagMultimap<K, V> rejectKeysValues(Predicate2<? super K, ? super V> predicate) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().rejectKeysValues((Predicate2)predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableBagMultimap<K, V> selectKeysMultiValues(Predicate2<? super K, ? super Iterable<V>> predicate) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().selectKeysMultiValues((Predicate2)predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MutableBagMultimap<K, V> rejectKeysMultiValues(Predicate2<? super K, ? super Iterable<V>> predicate) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().rejectKeysMultiValues((Predicate2)predicate);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <K2, V2> MutableBagMultimap<K2, V2> collectKeysValues(Function2<? super K, ? super V, Pair<K2, V2>> function) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().collectKeysValues((Function2)function);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <K2, V2> MutableBagMultimap<K2, V2> collectKeyMultiValues(Function<? super K, ? extends K2> keyFunction, Function<? super V, ? extends V2> valueFunction) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().collectKeyMultiValues((Function)keyFunction, (Function)valueFunction);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <V2> MutableBagMultimap<K, V2> collectValues(Function<? super V, ? extends V2> function) {
        Object object = this.getLock();
        synchronized (object) {
            return this.getDelegate().collectValues((Function)function);
        }
    }

    @Override
    public MutableBagMultimap<K, V> asSynchronized() {
        return this;
    }

    @Override
    protected MutableBagMultimap<K, V> getDelegate() {
        return (MutableBagMultimap)super.getDelegate();
    }
}

