/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.stack.immutable;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.eclipse.collections.api.stack.StackIterable;
import org.eclipse.collections.impl.block.procedure.checked.CheckedProcedure;
import org.eclipse.collections.impl.factory.Stacks;
import org.eclipse.collections.impl.list.mutable.FastList;

class ImmutableStackSerializationProxy<T>
implements Externalizable {
    private static final long serialVersionUID = 1L;
    private StackIterable<T> stack;

    public ImmutableStackSerializationProxy() {
    }

    protected ImmutableStackSerializationProxy(StackIterable<T> stack) {
        this.stack = stack;
    }

    @Override
    public void writeExternal(final ObjectOutput out) throws IOException {
        out.writeInt(this.stack.size());
        try {
            this.stack.forEach(new CheckedProcedure<T>(){

                @Override
                public void safeValue(T object) throws IOException {
                    out.writeObject(object);
                }
            });
        }
        catch (RuntimeException e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            throw e;
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int size2 = in.readInt();
        FastList<Object> deserializedDelegate = new FastList<Object>(size2);
        for (int i = 0; i < size2; ++i) {
            deserializedDelegate.add(in.readObject());
        }
        this.stack = Stacks.immutable.withAllReversed(deserializedDelegate);
    }

    protected Object readResolve() {
        return this.stack;
    }
}

