/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.stack.mutable.primitive;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.eclipse.collections.api.FloatIterable;
import org.eclipse.collections.api.block.function.primitive.FloatToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.FloatPredicate;
import org.eclipse.collections.api.iterator.FloatIterator;
import org.eclipse.collections.api.list.primitive.FloatList;
import org.eclipse.collections.api.list.primitive.MutableFloatList;
import org.eclipse.collections.api.stack.MutableStack;
import org.eclipse.collections.api.stack.primitive.FloatStack;
import org.eclipse.collections.api.stack.primitive.ImmutableFloatStack;
import org.eclipse.collections.api.stack.primitive.MutableFloatStack;
import org.eclipse.collections.impl.factory.primitive.FloatStacks;
import org.eclipse.collections.impl.list.mutable.primitive.FloatArrayList;
import org.eclipse.collections.impl.stack.mutable.ArrayStack;
import org.eclipse.collections.impl.stack.mutable.primitive.SynchronizedFloatStack;
import org.eclipse.collections.impl.stack.mutable.primitive.UnmodifiableFloatStack;
import org.eclipse.collections.impl.stack.primitive.AbstractFloatStack;

public class FloatArrayStack
extends AbstractFloatStack
implements MutableFloatStack,
Externalizable {
    private static final long serialVersionUID = 1L;
    private transient FloatArrayList delegate;

    public FloatArrayStack() {
        this.delegate = new FloatArrayList();
    }

    private FloatArrayStack(int size2) {
        this.delegate = new FloatArrayList(size2);
    }

    private FloatArrayStack(float ... items) {
        this.delegate = new FloatArrayList(items);
    }

    public static FloatArrayStack newStackFromTopToBottom(float ... items) {
        FloatArrayStack stack = new FloatArrayStack(items.length);
        for (int i = items.length - 1; i >= 0; --i) {
            stack.push(items[i]);
        }
        return stack;
    }

    public static FloatArrayStack newStackWith(float ... items) {
        return new FloatArrayStack(items);
    }

    public static FloatArrayStack newStack(FloatIterable items) {
        FloatArrayStack stack = new FloatArrayStack(items.size());
        stack.delegate = FloatArrayList.newList(items);
        return stack;
    }

    public static FloatArrayStack newStackFromTopToBottom(FloatIterable items) {
        FloatArrayStack stack = new FloatArrayStack(items.size());
        stack.delegate = FloatArrayList.newList(items).reverseThis();
        return stack;
    }

    @Override
    protected FloatArrayList getDelegate() {
        return this.delegate;
    }

    @Override
    public void push(float item) {
        this.delegate.add(item);
    }

    @Override
    public float pop() {
        this.checkEmptyStack();
        return this.delegate.removeAtIndex(this.delegate.size() - 1);
    }

    @Override
    public FloatList pop(int count2) {
        this.checkPositiveValueForCount(count2);
        this.checkSizeLessThanCount(count2);
        if (count2 == 0) {
            return new FloatArrayList(0);
        }
        FloatArrayList subList = new FloatArrayList(count2);
        while (count2 > 0) {
            subList.add(this.pop());
            --count2;
        }
        return subList;
    }

    @Override
    public MutableFloatStack select(FloatPredicate predicate) {
        return FloatArrayStack.newStackFromTopToBottom(this.delegate.asReversed().select(predicate));
    }

    @Override
    public MutableFloatStack reject(FloatPredicate predicate) {
        return FloatArrayStack.newStackFromTopToBottom(this.delegate.asReversed().reject(predicate));
    }

    @Override
    public <V> MutableStack<V> collect(FloatToObjectFunction<? extends V> function) {
        return ArrayStack.newStackFromTopToBottom(this.delegate.asReversed().collect((FloatToObjectFunction)function));
    }

    @Override
    public void clear() {
        this.delegate.clear();
    }

    @Override
    public MutableFloatList toSortedList() {
        return FloatArrayList.newList(this).sortThis();
    }

    @Override
    public MutableFloatStack asUnmodifiable() {
        return new UnmodifiableFloatStack(this);
    }

    @Override
    public MutableFloatStack asSynchronized() {
        return new SynchronizedFloatStack(this);
    }

    @Override
    public ImmutableFloatStack toImmutable() {
        return FloatStacks.immutable.withAll(this.delegate);
    }

    @Override
    public FloatArrayStack newEmpty() {
        return new FloatArrayStack();
    }

    @Override
    public boolean equals(Object otherStack) {
        if (otherStack == this) {
            return true;
        }
        if (!(otherStack instanceof FloatStack)) {
            return false;
        }
        FloatStack stack = (FloatStack)otherStack;
        if (this.size() != stack.size()) {
            return false;
        }
        for (int i = 0; i < this.size(); ++i) {
            if (Float.compare(this.peekAt(i), stack.peekAt(i)) == 0) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int hashCode2 = 1;
        for (int i = this.size() - 1; i >= 0; --i) {
            float item = this.delegate.get(i);
            hashCode2 = 31 * hashCode2 + Float.floatToIntBits(item);
        }
        return hashCode2;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.size());
        FloatIterator iterator2 = this.delegate.asReversed().floatIterator();
        while (iterator2.hasNext()) {
            float each2 = iterator2.next();
            out.writeFloat(each2);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException {
        int size2 = in.readInt();
        float[] array = new float[size2];
        for (int i = size2 - 1; i >= 0; --i) {
            array[i] = in.readFloat();
        }
        this.delegate = FloatArrayList.newListWith(array);
    }
}

