/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.utility;

import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.block.HashingStrategy;
import org.eclipse.collections.api.block.function.Function;
import org.eclipse.collections.api.block.function.Function2;
import org.eclipse.collections.api.block.function.Function3;
import org.eclipse.collections.api.block.function.primitive.BooleanFunction;
import org.eclipse.collections.api.block.function.primitive.ByteFunction;
import org.eclipse.collections.api.block.function.primitive.CharFunction;
import org.eclipse.collections.api.block.function.primitive.DoubleFunction;
import org.eclipse.collections.api.block.function.primitive.DoubleObjectToDoubleFunction;
import org.eclipse.collections.api.block.function.primitive.FloatFunction;
import org.eclipse.collections.api.block.function.primitive.FloatObjectToFloatFunction;
import org.eclipse.collections.api.block.function.primitive.IntFunction;
import org.eclipse.collections.api.block.function.primitive.IntObjectToIntFunction;
import org.eclipse.collections.api.block.function.primitive.LongFunction;
import org.eclipse.collections.api.block.function.primitive.LongObjectToLongFunction;
import org.eclipse.collections.api.block.function.primitive.ShortFunction;
import org.eclipse.collections.api.block.predicate.Predicate;
import org.eclipse.collections.api.block.predicate.Predicate2;
import org.eclipse.collections.api.block.procedure.Procedure;
import org.eclipse.collections.api.block.procedure.Procedure2;
import org.eclipse.collections.api.block.procedure.primitive.ObjectIntProcedure;
import org.eclipse.collections.api.collection.primitive.MutableBooleanCollection;
import org.eclipse.collections.api.collection.primitive.MutableByteCollection;
import org.eclipse.collections.api.collection.primitive.MutableCharCollection;
import org.eclipse.collections.api.collection.primitive.MutableDoubleCollection;
import org.eclipse.collections.api.collection.primitive.MutableFloatCollection;
import org.eclipse.collections.api.collection.primitive.MutableIntCollection;
import org.eclipse.collections.api.collection.primitive.MutableLongCollection;
import org.eclipse.collections.api.collection.primitive.MutableShortCollection;
import org.eclipse.collections.api.factory.Lists;
import org.eclipse.collections.api.list.MutableList;
import org.eclipse.collections.api.list.primitive.MutableBooleanList;
import org.eclipse.collections.api.list.primitive.MutableByteList;
import org.eclipse.collections.api.list.primitive.MutableCharList;
import org.eclipse.collections.api.list.primitive.MutableDoubleList;
import org.eclipse.collections.api.list.primitive.MutableFloatList;
import org.eclipse.collections.api.list.primitive.MutableIntList;
import org.eclipse.collections.api.list.primitive.MutableLongList;
import org.eclipse.collections.api.list.primitive.MutableShortList;
import org.eclipse.collections.api.map.MutableMap;
import org.eclipse.collections.api.map.MutableMapIterable;
import org.eclipse.collections.api.map.primitive.ObjectDoubleMap;
import org.eclipse.collections.api.map.primitive.ObjectLongMap;
import org.eclipse.collections.api.multimap.MutableMultimap;
import org.eclipse.collections.api.tuple.Pair;
import org.eclipse.collections.api.tuple.Twin;
import org.eclipse.collections.impl.block.factory.Functions0;
import org.eclipse.collections.impl.block.factory.Predicates2;
import org.eclipse.collections.impl.block.factory.Procedures2;
import org.eclipse.collections.impl.block.procedure.MapCollectProcedure;
import org.eclipse.collections.impl.list.mutable.FastList;
import org.eclipse.collections.impl.list.mutable.primitive.BooleanArrayList;
import org.eclipse.collections.impl.list.mutable.primitive.ByteArrayList;
import org.eclipse.collections.impl.list.mutable.primitive.CharArrayList;
import org.eclipse.collections.impl.list.mutable.primitive.DoubleArrayList;
import org.eclipse.collections.impl.list.mutable.primitive.FloatArrayList;
import org.eclipse.collections.impl.list.mutable.primitive.IntArrayList;
import org.eclipse.collections.impl.list.mutable.primitive.LongArrayList;
import org.eclipse.collections.impl.list.mutable.primitive.ShortArrayList;
import org.eclipse.collections.impl.map.mutable.UnifiedMap;
import org.eclipse.collections.impl.multimap.list.FastListMultimap;
import org.eclipse.collections.impl.partition.list.PartitionFastList;
import org.eclipse.collections.impl.tuple.Tuples;
import org.eclipse.collections.impl.utility.ListIterate;
import org.eclipse.collections.impl.utility.internal.InternalArrayIterate;

public final class ArrayIterate {
    private ArrayIterate() {
        throw new AssertionError((Object)"Suppress default constructor for noninstantiability");
    }

    public static <T> void reverse(T[] array, int size2) {
        int mid = size2 / 2;
        int j = size2 - 1;
        int i = 0;
        while (i < mid) {
            T two;
            T one = array[i];
            array[i] = two = array[j];
            array[j] = one;
            ++i;
            --j;
        }
    }

    @Deprecated
    public static <T> void sort(T[] array, int size2, Comparator<? super T> comparator) {
        if (comparator == null) {
            Arrays.sort(array, 0, size2);
        } else {
            Arrays.sort(array, 0, size2, comparator);
        }
    }

    public static <T, V extends Comparable<? super V>> T minBy(T[] array, Function<? super T, ? extends V> function) {
        return InternalArrayIterate.minBy(array, array.length, function);
    }

    public static <T, V extends Comparable<? super V>> T maxBy(T[] array, Function<? super T, ? extends V> function) {
        return InternalArrayIterate.maxBy(array, array.length, function);
    }

    public static <T> T min(T[] array, Comparator<? super T> comparator) {
        return InternalArrayIterate.min(array, array.length, comparator);
    }

    public static <T> T max(T[] array, Comparator<? super T> comparator) {
        return InternalArrayIterate.max(array, array.length, comparator);
    }

    public static <T> T min(T ... array) {
        return InternalArrayIterate.min(array, array.length);
    }

    public static <T> T max(T ... array) {
        return InternalArrayIterate.max(array, array.length);
    }

    public static <T> MutableList<T> select(T[] objectArray, Predicate<? super T> predicate) {
        if (objectArray == null) {
            throw new IllegalArgumentException("Cannot perform a select on null");
        }
        return ArrayIterate.select(objectArray, predicate, FastList.newList());
    }

    public static <T, P> MutableList<T> selectWith(T[] objectArray, Predicate2<? super T, P> predicate, P parameter) {
        if (objectArray == null) {
            throw new IllegalArgumentException("Cannot perform a selectWith on null");
        }
        return ArrayIterate.selectWith(objectArray, predicate, parameter, FastList.newList());
    }

    public static <T> FastList<T> selectInstancesOf(Object[] objectArray, Class<T> clazz) {
        if (objectArray == null) {
            throw new IllegalArgumentException("Cannot perform a selectInstancesOf on null");
        }
        return InternalArrayIterate.selectInstancesOf(objectArray, objectArray.length, clazz);
    }

    public static <T> int count(T[] objectArray, Predicate<? super T> predicate) {
        if (objectArray == null) {
            return 0;
        }
        return InternalArrayIterate.count(objectArray, objectArray.length, predicate);
    }

    public static <T, P> int countWith(T[] objectArray, Predicate2<? super T, ? super P> predicate, P parameter) {
        if (objectArray == null) {
            return 0;
        }
        return InternalArrayIterate.countWith(objectArray, objectArray.length, predicate, parameter);
    }

    @Deprecated
    public static <T, P> Twin<MutableList<T>> selectAndRejectWith(T[] objectArray, Predicate2<? super T, ? super P> predicate, P parameter) {
        if (objectArray == null) {
            throw new IllegalArgumentException("Cannot perform a selectAndRejectWith on null");
        }
        return InternalArrayIterate.selectAndRejectWith(objectArray, objectArray.length, predicate, parameter);
    }

    public static <T> PartitionFastList<T> partition(T[] array, Predicate<? super T> predicate) {
        if (array == null) {
            throw new IllegalArgumentException("Cannot perform a partition on null");
        }
        return InternalArrayIterate.partition(array, array.length, predicate);
    }

    public static <T, P> PartitionFastList<T> partitionWith(T[] array, Predicate2<? super T, ? super P> predicate, P parameter) {
        if (array == null) {
            throw new IllegalArgumentException("Cannot perform a partitionWith on null");
        }
        return InternalArrayIterate.partitionWith(array, array.length, predicate, parameter);
    }

    public static <T, V> MutableList<V> collectIf(T[] objectArray, Predicate<? super T> predicate, Function<? super T, ? extends V> function) {
        if (objectArray == null) {
            throw new IllegalArgumentException("Cannot perform a collectIf on null");
        }
        return ArrayIterate.collectIf(objectArray, predicate, function, FastList.newList(objectArray.length));
    }

    public static <T, R extends Collection<T>> R select(T[] objectArray, Predicate<? super T> predicate, R targetCollection) {
        if (objectArray == null) {
            throw new IllegalArgumentException("Cannot perform a select on null");
        }
        return InternalArrayIterate.select(objectArray, objectArray.length, predicate, targetCollection);
    }

    public static <T, P, R extends Collection<T>> R selectWith(T[] objectArray, Predicate2<? super T, ? super P> predicate, P parameter, R targetCollection) {
        if (objectArray == null) {
            throw new IllegalArgumentException("Cannot perform a selectWith on null");
        }
        return InternalArrayIterate.selectWith(objectArray, objectArray.length, predicate, parameter, targetCollection);
    }

    public static <T, V, R extends Collection<V>> R collectIf(T[] objectArray, Predicate<? super T> predicate, Function<? super T, ? extends V> function, R targetCollection) {
        if (objectArray == null) {
            throw new IllegalArgumentException("Cannot perform a collectIf on null");
        }
        return InternalArrayIterate.collectIf(objectArray, objectArray.length, predicate, function, targetCollection);
    }

    public static <T> MutableList<T> reject(T[] objectArray, Predicate<? super T> predicate) {
        return ArrayIterate.reject(objectArray, predicate, FastList.newList());
    }

    public static <T, P> MutableList<T> rejectWith(T[] objectArray, Predicate2<? super T, P> predicate, P parameter) {
        if (objectArray == null) {
            throw new IllegalArgumentException("Cannot perform a rejectWith on null");
        }
        return ArrayIterate.rejectWith(objectArray, predicate, parameter, FastList.newList());
    }

    public static <T, R extends Collection<T>> R reject(T[] objectArray, Predicate<? super T> predicate, R targetCollection) {
        if (objectArray == null) {
            throw new IllegalArgumentException("Cannot perform a reject on null");
        }
        return InternalArrayIterate.reject(objectArray, objectArray.length, predicate, targetCollection);
    }

    public static <T, P, R extends Collection<T>> R rejectWith(T[] objectArray, Predicate2<? super T, ? super P> predicate, P parameter, R targetCollection) {
        if (objectArray == null) {
            throw new IllegalArgumentException("Cannot perform a rejectWith on null");
        }
        return InternalArrayIterate.rejectWith(objectArray, objectArray.length, predicate, parameter, targetCollection);
    }

    public static <T, R extends Collection<T>> R addAllTo(T[] objectArray, R targetCollection) {
        ArrayIterate.forEachWith(objectArray, Procedures2.addToCollection(), targetCollection);
        return targetCollection;
    }

    public static <T, V> MutableList<V> collect(T[] objectArray, Function<? super T, ? extends V> function) {
        if (objectArray == null) {
            throw new IllegalArgumentException("Cannot perform a collect on null");
        }
        return ArrayIterate.collect(objectArray, function, FastList.newList(objectArray.length));
    }

    public static <T, V, R extends Collection<V>> R collect(T[] objectArray, Function<? super T, ? extends V> function, R targetCollection) {
        if (objectArray == null) {
            throw new IllegalArgumentException("Cannot perform a collect on null");
        }
        return InternalArrayIterate.collect(objectArray, objectArray.length, function, targetCollection);
    }

    public static <T> MutableBooleanList collectBoolean(T[] objectArray, BooleanFunction<? super T> booleanFunction) {
        if (objectArray == null) {
            throw new IllegalArgumentException("Cannot perform a collectBoolean on null");
        }
        return ArrayIterate.collectBoolean(objectArray, booleanFunction, new BooleanArrayList(objectArray.length));
    }

    public static <T, R extends MutableBooleanCollection> R collectBoolean(T[] objectArray, BooleanFunction<? super T> booleanFunction, R target) {
        if (objectArray == null) {
            throw new IllegalArgumentException("Cannot perform a collectBoolean on null");
        }
        for (T each2 : objectArray) {
            target.add(booleanFunction.booleanValueOf(each2));
        }
        return target;
    }

    public static <T> MutableByteList collectByte(T[] objectArray, ByteFunction<? super T> byteFunction) {
        if (objectArray == null) {
            throw new IllegalArgumentException("Cannot perform a collectByte on null");
        }
        return ArrayIterate.collectByte(objectArray, byteFunction, new ByteArrayList(objectArray.length));
    }

    public static <T, R extends MutableByteCollection> R collectByte(T[] objectArray, ByteFunction<? super T> byteFunction, R target) {
        if (objectArray == null) {
            throw new IllegalArgumentException("Cannot perform a collectByte on null");
        }
        for (T each2 : objectArray) {
            target.add(byteFunction.byteValueOf(each2));
        }
        return target;
    }

    public static <T> MutableCharList collectChar(T[] objectArray, CharFunction<? super T> charFunction) {
        if (objectArray == null) {
            throw new IllegalArgumentException("Cannot perform a collectChar on null");
        }
        return ArrayIterate.collectChar(objectArray, charFunction, new CharArrayList(objectArray.length));
    }

    public static <T, R extends MutableCharCollection> R collectChar(T[] objectArray, CharFunction<? super T> charFunction, R target) {
        if (objectArray == null) {
            throw new IllegalArgumentException("Cannot perform a collectChar on null");
        }
        for (T each2 : objectArray) {
            target.add(charFunction.charValueOf(each2));
        }
        return target;
    }

    public static <T> MutableDoubleList collectDouble(T[] objectArray, DoubleFunction<? super T> doubleFunction) {
        if (objectArray == null) {
            throw new IllegalArgumentException("Cannot perform a collectDouble on null");
        }
        return ArrayIterate.collectDouble(objectArray, doubleFunction, new DoubleArrayList(objectArray.length));
    }

    public static <T, R extends MutableDoubleCollection> R collectDouble(T[] objectArray, DoubleFunction<? super T> doubleFunction, R target) {
        if (objectArray == null) {
            throw new IllegalArgumentException("Cannot perform a collectDouble on null");
        }
        for (T each2 : objectArray) {
            target.add(doubleFunction.doubleValueOf(each2));
        }
        return target;
    }

    public static <T> MutableFloatList collectFloat(T[] objectArray, FloatFunction<? super T> floatFunction) {
        if (objectArray == null) {
            throw new IllegalArgumentException("Cannot perform a collectFloat on null");
        }
        return ArrayIterate.collectFloat(objectArray, floatFunction, new FloatArrayList(objectArray.length));
    }

    public static <T, R extends MutableFloatCollection> R collectFloat(T[] objectArray, FloatFunction<? super T> floatFunction, R target) {
        if (objectArray == null) {
            throw new IllegalArgumentException("Cannot perform a collectFloat on null");
        }
        for (T each2 : objectArray) {
            target.add(floatFunction.floatValueOf(each2));
        }
        return target;
    }

    public static <T> MutableIntList collectInt(T[] objectArray, IntFunction<? super T> intFunction) {
        if (objectArray == null) {
            throw new IllegalArgumentException("Cannot perform a collectInt on null");
        }
        return ArrayIterate.collectInt(objectArray, intFunction, new IntArrayList(objectArray.length));
    }

    public static <T, R extends MutableIntCollection> R collectInt(T[] objectArray, IntFunction<? super T> intFunction, R target) {
        if (objectArray == null) {
            throw new IllegalArgumentException("Cannot perform a collectInt on null");
        }
        for (T each2 : objectArray) {
            target.add(intFunction.intValueOf(each2));
        }
        return target;
    }

    public static <T> MutableLongList collectLong(T[] objectArray, LongFunction<? super T> longFunction) {
        if (objectArray == null) {
            throw new IllegalArgumentException("Cannot perform a collectLong on null");
        }
        return ArrayIterate.collectLong(objectArray, longFunction, new LongArrayList(objectArray.length));
    }

    public static <T, R extends MutableLongCollection> R collectLong(T[] objectArray, LongFunction<? super T> longFunction, R target) {
        if (objectArray == null) {
            throw new IllegalArgumentException("Cannot perform a collectLong on null");
        }
        for (T each2 : objectArray) {
            target.add(longFunction.longValueOf(each2));
        }
        return target;
    }

    public static <T> MutableShortList collectShort(T[] objectArray, ShortFunction<? super T> shortFunction) {
        if (objectArray == null) {
            throw new IllegalArgumentException("Cannot perform a collectShort on null");
        }
        return ArrayIterate.collectShort(objectArray, shortFunction, new ShortArrayList(objectArray.length));
    }

    public static <T, R extends MutableShortCollection> R collectShort(T[] objectArray, ShortFunction<? super T> shortFunction, R target) {
        if (objectArray == null) {
            throw new IllegalArgumentException("Cannot perform a collectShort on null");
        }
        for (T each2 : objectArray) {
            target.add(shortFunction.shortValueOf(each2));
        }
        return target;
    }

    public static <T, V> MutableList<V> flatCollect(T[] objectArray, Function<? super T, ? extends Iterable<V>> function) {
        if (objectArray == null) {
            throw new IllegalArgumentException("Cannot perform a flatCollect on null");
        }
        return ArrayIterate.flatCollect(objectArray, function, FastList.newList(objectArray.length));
    }

    public static <T, V, R extends Collection<V>> R flatCollect(T[] objectArray, Function<? super T, ? extends Iterable<V>> function, R targetCollection) {
        if (objectArray == null) {
            throw new IllegalArgumentException("Cannot perform a flatCollect on null");
        }
        return InternalArrayIterate.flatCollect(objectArray, objectArray.length, function, targetCollection);
    }

    public static <T> T getFirst(T[] objectArray) {
        if (ArrayIterate.notEmpty(objectArray)) {
            return objectArray[0];
        }
        return null;
    }

    public static <T> T getLast(T[] objectArray) {
        if (ArrayIterate.notEmpty(objectArray)) {
            return objectArray[objectArray.length - 1];
        }
        return null;
    }

    public static <T> void forEach(T[] objectArray, Procedure<? super T> procedure) {
        if (objectArray == null) {
            throw new IllegalArgumentException("Cannot perform a forEach on null");
        }
        if (ArrayIterate.notEmpty(objectArray)) {
            for (T each2 : objectArray) {
                procedure.value(each2);
            }
        }
    }

    public static <T> void forEach(T[] objectArray, int from, int to, Procedure<? super T> procedure) {
        if (objectArray == null) {
            throw new IllegalArgumentException("Cannot perform a forEach on null");
        }
        ListIterate.rangeCheck(from, to, objectArray.length);
        InternalArrayIterate.forEachWithoutChecks(objectArray, from, to, procedure);
    }

    public static <T1, T2> void forEachInBoth(T1[] objectArray1, T2[] objectArray2, Procedure2<? super T1, ? super T2> procedure) {
        if (objectArray1 != null && objectArray2 != null) {
            if (objectArray1.length == objectArray2.length) {
                int size2 = objectArray1.length;
                for (int i = 0; i < size2; ++i) {
                    procedure.value(objectArray1[i], objectArray2[i]);
                }
            } else {
                throw new RuntimeException("Attempt to call forEachInBoth with two arrays of different sizes :" + objectArray1.length + ':' + objectArray2.length);
            }
        }
    }

    public static <T> void forEachWithIndex(T[] objectArray, ObjectIntProcedure<? super T> objectIntProcedure) {
        if (objectArray == null) {
            throw new IllegalArgumentException("Cannot perform a forEachWithIndex on null");
        }
        InternalArrayIterate.forEachWithIndex(objectArray, objectArray.length, objectIntProcedure);
    }

    public static <T> void forEachWithIndex(T[] objectArray, int from, int to, ObjectIntProcedure<? super T> objectIntProcedure) {
        if (objectArray == null) {
            throw new IllegalArgumentException("Cannot perform a forEachWithIndex on null");
        }
        ListIterate.rangeCheck(from, to, objectArray.length);
        InternalArrayIterate.forEachWithIndexWithoutChecks(objectArray, from, to, objectIntProcedure);
    }

    public static <T> T detect(T[] objectArray, Predicate<? super T> predicate) {
        if (objectArray == null) {
            throw new IllegalArgumentException("Cannot perform a detect on null");
        }
        return InternalArrayIterate.detect(objectArray, objectArray.length, predicate);
    }

    public static <T, P> T detectWith(T[] objectArray, Predicate2<? super T, ? super P> predicate, P parameter) {
        if (objectArray == null) {
            throw new IllegalArgumentException("Cannot perform a detectWith on null");
        }
        return InternalArrayIterate.detectWith(objectArray, objectArray.length, predicate, parameter);
    }

    public static <T> Optional<T> detectOptional(T[] objectArray, Predicate<? super T> predicate) {
        if (objectArray == null) {
            throw new IllegalArgumentException("Cannot perform a detect on null");
        }
        return InternalArrayIterate.detectOptional(objectArray, objectArray.length, predicate);
    }

    public static <T, P> Optional<T> detectWithOptional(T[] objectArray, Predicate2<? super T, ? super P> predicate, P parameter) {
        if (objectArray == null) {
            throw new IllegalArgumentException("Cannot perform a detectWith on null");
        }
        return InternalArrayIterate.detectWithOptional(objectArray, objectArray.length, predicate, parameter);
    }

    public static <T> T detectIfNone(T[] objectArray, Predicate<? super T> predicate, T ifNone) {
        T result = ArrayIterate.detect(objectArray, predicate);
        return result == null ? ifNone : result;
    }

    public static <T, P> T detectWithIfNone(T[] objectArray, Predicate2<? super T, ? super P> predicate, P parameter, T ifNone) {
        T result = ArrayIterate.detectWith(objectArray, predicate, parameter);
        return result == null ? ifNone : result;
    }

    public static <T, IV> IV injectInto(IV injectValue, T[] objectArray, Function2<? super IV, ? super T, ? extends IV> function) {
        if (objectArray == null) {
            throw new IllegalArgumentException("Cannot perform an injectInto on null");
        }
        IV result = injectValue;
        for (T each2 : objectArray) {
            result = function.value(result, each2);
        }
        return result;
    }

    public static <T> int injectInto(int injectValue, T[] objectArray, IntObjectToIntFunction<? super T> function) {
        if (objectArray == null) {
            throw new IllegalArgumentException("Cannot perform an injectInto on null");
        }
        int result = injectValue;
        if (ArrayIterate.notEmpty(objectArray)) {
            for (T each2 : objectArray) {
                result = function.intValueOf(result, each2);
            }
        }
        return result;
    }

    public static <T> long injectInto(long injectValue, T[] objectArray, LongObjectToLongFunction<? super T> function) {
        if (objectArray == null) {
            throw new IllegalArgumentException("Cannot perform an injectInto on null");
        }
        long result = injectValue;
        if (ArrayIterate.notEmpty(objectArray)) {
            for (T each2 : objectArray) {
                result = function.longValueOf(result, each2);
            }
        }
        return result;
    }

    public static <T> float injectInto(float injectValue, T[] objectArray, FloatObjectToFloatFunction<? super T> function) {
        if (objectArray == null) {
            throw new IllegalArgumentException("Cannot perform an injectInto on null");
        }
        float result = injectValue;
        if (ArrayIterate.notEmpty(objectArray)) {
            for (T each2 : objectArray) {
                result = function.floatValueOf(result, each2);
            }
        }
        return result;
    }

    public static <T> double injectInto(double injectValue, T[] objectArray, DoubleObjectToDoubleFunction<? super T> function) {
        if (objectArray == null) {
            throw new IllegalArgumentException("Cannot perform an injectInto on null");
        }
        double result = injectValue;
        if (ArrayIterate.notEmpty(objectArray)) {
            for (T each2 : objectArray) {
                result = function.doubleValueOf(result, each2);
            }
        }
        return result;
    }

    @Deprecated
    public static <T, R extends List<T>> R distinct(T[] objectArray, R targetList) {
        if (objectArray == null) {
            throw new IllegalArgumentException("Cannot perform a distinct on null");
        }
        return InternalArrayIterate.distinct(objectArray, objectArray.length, targetList);
    }

    public static <T> MutableList<T> distinct(T[] objectArray) {
        return ArrayIterate.distinct(objectArray, FastList.newList());
    }

    public static <T> MutableList<T> distinct(T[] objectArray, HashingStrategy<? super T> hashingStrategy) {
        if (objectArray == null) {
            throw new IllegalArgumentException("Cannot perform a distinct on null");
        }
        return InternalArrayIterate.distinct(objectArray, objectArray.length, hashingStrategy);
    }

    public static <T> boolean contains(T[] objectArray, T value) {
        return ArrayIterate.anySatisfyWith(objectArray, Predicates2.equal(), value);
    }

    public static boolean contains(int[] intArray, int value) {
        for (int each2 : intArray) {
            if (each2 != value) continue;
            return true;
        }
        return false;
    }

    public static boolean contains(double[] doubleArray, double value) {
        for (double each2 : doubleArray) {
            if (Double.doubleToLongBits(each2) != Double.doubleToLongBits(value)) continue;
            return true;
        }
        return false;
    }

    public static boolean contains(long[] longArray, long value) {
        for (long each2 : longArray) {
            if (each2 != value) continue;
            return true;
        }
        return false;
    }

    public static <T> int indexOf(T[] objectArray, T elem) {
        return InternalArrayIterate.indexOf(objectArray, objectArray.length, elem);
    }

    public static <T> int detectIndex(T[] objectArray, Predicate<? super T> predicate) {
        if (objectArray == null) {
            throw new IllegalArgumentException("Cannot perform a detectIndex on null");
        }
        return InternalArrayIterate.detectIndex(objectArray, objectArray.length, predicate);
    }

    public static <T, IV> int detectIndexWith(T[] objectArray, Predicate2<? super T, ? super IV> predicate, IV injectedValue) {
        if (objectArray == null) {
            throw new IllegalArgumentException("Cannot perform a detectIndexWith on null");
        }
        for (int i = 0; i < objectArray.length; ++i) {
            if (!predicate.accept(objectArray[i], injectedValue)) continue;
            return i;
        }
        return -1;
    }

    public static <T> int detectLastIndex(T[] objectArray, Predicate<? super T> predicate) {
        if (objectArray == null) {
            throw new IllegalArgumentException("Cannot perform a detectLastIndex on null");
        }
        return InternalArrayIterate.detectLastIndex(objectArray, objectArray.length, predicate);
    }

    public static boolean isEmpty(Object[] array) {
        return array == null || array.length == 0;
    }

    public static boolean notEmpty(Object[] array) {
        return array != null && array.length > 0;
    }

    public static int size(Object[] array) {
        return array == null ? 0 : array.length;
    }

    public static <T> boolean anySatisfy(T[] objectArray, Predicate<? super T> predicate) {
        if (objectArray == null) {
            throw new IllegalArgumentException("Cannot perform a anySatisfy on null");
        }
        return InternalArrayIterate.anySatisfy(objectArray, objectArray.length, predicate);
    }

    public static <T, P> boolean anySatisfyWith(T[] objectArray, Predicate2<? super T, ? super P> predicate, P parameter) {
        if (objectArray == null) {
            throw new IllegalArgumentException("Cannot perform a anySatisfyWith on null");
        }
        return InternalArrayIterate.anySatisfyWith(objectArray, objectArray.length, predicate, parameter);
    }

    public static <T> boolean allSatisfy(T[] objectArray, Predicate<? super T> predicate) {
        if (objectArray == null) {
            throw new IllegalArgumentException("Cannot perform a allSatisfy on null");
        }
        return InternalArrayIterate.allSatisfy(objectArray, objectArray.length, predicate);
    }

    public static <T, P> boolean allSatisfyWith(T[] objectArray, Predicate2<? super T, ? super P> predicate, P parameter) {
        if (objectArray == null) {
            throw new IllegalArgumentException("Cannot perform a allSatisfyWith on null");
        }
        return InternalArrayIterate.allSatisfyWith(objectArray, objectArray.length, predicate, parameter);
    }

    public static <T> boolean noneSatisfy(T[] objectArray, Predicate<? super T> predicate) {
        if (objectArray == null) {
            throw new IllegalArgumentException("Cannot perform a noneSatisfy on null");
        }
        return InternalArrayIterate.noneSatisfy(objectArray, objectArray.length, predicate);
    }

    public static <T, P> boolean noneSatisfyWith(T[] objectArray, Predicate2<? super T, ? super P> predicate, P parameter) {
        if (objectArray == null) {
            throw new IllegalArgumentException("Cannot perform a noneSatisfyWith on null");
        }
        return InternalArrayIterate.noneSatisfyWith(objectArray, objectArray.length, predicate, parameter);
    }

    public static <K, V> MutableMap<K, V> toMap(V[] objectArray, Function<? super V, ? extends K> keyFunction) {
        UnifiedMap map2 = UnifiedMap.newMap();
        MapCollectProcedure procedure = new MapCollectProcedure(map2, keyFunction);
        ArrayIterate.forEach(objectArray, procedure);
        return map2;
    }

    public static <T, K, V> MutableMap<K, V> toMap(T[] objectArray, Function<? super T, ? extends K> keyFunction, Function<? super T, ? extends V> valueFunction) {
        UnifiedMap map2 = UnifiedMap.newMap();
        MapCollectProcedure<? super T, ? extends K, ? extends V> procedure = new MapCollectProcedure<T, K, V>(map2, keyFunction, valueFunction);
        ArrayIterate.forEach(objectArray, procedure);
        return map2;
    }

    public static <T, P> void forEachWith(T[] objectArray, Procedure2<? super T, ? super P> procedure, P parameter) {
        if (objectArray == null) {
            throw new IllegalArgumentException("Cannot perform a forEachWith on null");
        }
        if (ArrayIterate.notEmpty(objectArray)) {
            for (T each2 : objectArray) {
                procedure.value(each2, parameter);
            }
        }
    }

    public static <T, P, V> MutableList<V> collectWith(T[] objectArray, Function2<? super T, ? super P, ? extends V> function, P parameter) {
        if (objectArray == null) {
            throw new IllegalArgumentException("Cannot perform a collectWith on null");
        }
        return ArrayIterate.collectWith(objectArray, function, parameter, FastList.newList(objectArray.length));
    }

    public static <T, P, V, R extends Collection<V>> R collectWith(T[] objectArray, Function2<? super T, ? super P, ? extends V> function, P parameter, R targetCollection) {
        if (objectArray == null) {
            throw new IllegalArgumentException("Cannot perform a collectWith on null");
        }
        return InternalArrayIterate.collectWith(objectArray, objectArray.length, function, parameter, targetCollection);
    }

    public static <T, IV, P> IV injectIntoWith(IV injectValue, T[] objectArray, Function3<? super IV, ? super T, ? super P, ? extends IV> function, P parameter) {
        if (objectArray == null) {
            throw new IllegalArgumentException("Cannot perform an injectIntoWith on null");
        }
        IV result = injectValue;
        if (ArrayIterate.notEmpty(objectArray)) {
            for (T each2 : objectArray) {
                result = function.value(result, each2, parameter);
            }
        }
        return result;
    }

    public static <T> MutableList<T> take(T[] array, int count2) {
        if (count2 < 0) {
            throw new IllegalArgumentException("Count must be greater than zero, but was: " + count2);
        }
        return ArrayIterate.take(array, count2, FastList.newList(Math.min(array.length, count2)));
    }

    public static <T, R extends Collection<T>> R take(T[] array, int count2, R target) {
        if (count2 < 0) {
            throw new IllegalArgumentException("Count must be greater than zero, but was: " + count2);
        }
        int end = Math.min(array.length, count2);
        for (int i = 0; i < end; ++i) {
            target.add(array[i]);
        }
        return target;
    }

    public static <T> MutableList<T> drop(T[] array, int count2) {
        if (count2 < 0) {
            throw new IllegalArgumentException("Count must be greater than zero, but was: " + count2);
        }
        return ArrayIterate.drop(array, count2, FastList.newList(array.length - Math.min(array.length, count2)));
    }

    public static <T, R extends Collection<T>> R drop(T[] array, int count2, R target) {
        if (count2 < 0) {
            throw new IllegalArgumentException("Count must be greater than zero, but was: " + count2);
        }
        for (int i = count2; i < array.length; ++i) {
            target.add(array[i]);
        }
        return target;
    }

    public static <T, V> FastListMultimap<V, T> groupBy(T[] array, Function<? super T, ? extends V> function) {
        return ArrayIterate.groupBy(array, function, FastListMultimap.newMultimap());
    }

    public static <T, V, R extends MutableMultimap<V, T>> R groupBy(T[] array, Function<? super T, ? extends V> function, R target) {
        return InternalArrayIterate.groupBy(array, array.length, function, target);
    }

    public static <T, V> FastListMultimap<V, T> groupByEach(T[] array, Function<? super T, ? extends Iterable<V>> function) {
        return ArrayIterate.groupByEach(array, function, FastListMultimap.newMultimap());
    }

    public static <T, V, R extends MutableMultimap<V, T>> R groupByEach(T[] array, Function<? super T, ? extends Iterable<V>> function, R target) {
        return InternalArrayIterate.groupByEach(array, array.length, function, target);
    }

    public static <T, V> MutableMapIterable<V, T> groupByUniqueKey(T[] array, Function<? super T, ? extends V> function) {
        return ArrayIterate.groupByUniqueKey(array, function, UnifiedMap.newMap());
    }

    public static <T, V, R extends MutableMapIterable<V, T>> R groupByUniqueKey(T[] array, Function<? super T, ? extends V> function, R target) {
        if (array == null) {
            throw new IllegalArgumentException("Cannot perform a groupByUniqueKey on null");
        }
        return InternalArrayIterate.groupByUniqueKey(array, array.length, function, target);
    }

    public static <T> RichIterable<RichIterable<T>> chunk(T[] array, int size2) {
        if (size2 <= 0) {
            throw new IllegalArgumentException("Size for groups must be positive but was: " + size2);
        }
        int index = 0;
        MutableList<RichIterable<T>> result = Lists.mutable.empty();
        while (index < array.length) {
            MutableList batch = Lists.mutable.empty();
            for (int i = 0; i < size2 && index < array.length; ++index, ++i) {
                batch.add(array[index]);
            }
            result.add(batch);
        }
        return result;
    }

    public static <X, Y> MutableList<Pair<X, Y>> zip(X[] xs, Y[] ys) {
        return ArrayIterate.zip(xs, ys, FastList.newList());
    }

    public static <X, Y, R extends Collection<Pair<X, Y>>> R zip(X[] xs, Y[] ys, R targetCollection) {
        int size2 = Math.min(xs.length, ys.length);
        for (int i = 0; i < size2; ++i) {
            targetCollection.add(Tuples.pair(xs[i], ys[i]));
        }
        return targetCollection;
    }

    public static <T> MutableList<Pair<T, Integer>> zipWithIndex(T ... array) {
        return ArrayIterate.zipWithIndex(array, FastList.newList());
    }

    public static <T, R extends Collection<Pair<T, Integer>>> R zipWithIndex(T[] array, R targetCollection) {
        for (int i = 0; i < array.length; ++i) {
            targetCollection.add(Tuples.pair(array[i], i));
        }
        return targetCollection;
    }

    public static <T> String makeString(T ... array) {
        return ArrayIterate.makeString(array, ", ");
    }

    public static <T> String makeString(T[] array, String separator) {
        return ArrayIterate.makeString(array, "", separator, "");
    }

    public static <T> String makeString(T[] array, String start, String separator, String end) {
        StringBuilder stringBuilder = new StringBuilder();
        ArrayIterate.appendString(array, stringBuilder, start, separator, end);
        return ((Object)stringBuilder).toString();
    }

    public static <T> void appendString(T[] array, Appendable appendable) {
        ArrayIterate.appendString(array, appendable, ", ");
    }

    public static <T> void appendString(T[] array, Appendable appendable, String separator) {
        ArrayIterate.appendString(array, appendable, "", separator, "");
    }

    public static <T> void appendString(T[] array, Appendable appendable, String start, String separator, String end) {
        try {
            appendable.append(start);
            if (array.length > 0) {
                appendable.append(String.valueOf(array[0]));
                int size2 = array.length;
                for (int i = 1; i < size2; ++i) {
                    appendable.append(separator);
                    appendable.append(String.valueOf(array[i]));
                }
            }
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> long sumOfInt(T[] array, IntFunction<? super T> function) {
        return InternalArrayIterate.sumOfInt(array, array.length, function);
    }

    public static <T> long sumOfLong(T[] array, LongFunction<? super T> function) {
        return InternalArrayIterate.sumOfLong(array, array.length, function);
    }

    public static <T> double sumOfFloat(T[] array, FloatFunction<? super T> function) {
        return InternalArrayIterate.sumOfFloat(array, array.length, function);
    }

    public static <T> double sumOfDouble(T[] array, DoubleFunction<? super T> function) {
        return InternalArrayIterate.sumOfDouble(array, array.length, function);
    }

    public static <T> BigDecimal sumOfBigDecimal(T[] array, Function<? super T, BigDecimal> function) {
        BigDecimal result = BigDecimal.ZERO;
        for (T each2 : array) {
            result = result.add(function.valueOf(each2));
        }
        return result;
    }

    public static <T> BigInteger sumOfBigInteger(T[] array, Function<? super T, BigInteger> function) {
        BigInteger result = BigInteger.ZERO;
        for (T each2 : array) {
            result = result.add(function.valueOf(each2));
        }
        return result;
    }

    public static <V, T> MutableMap<V, BigDecimal> sumByBigDecimal(T[] array, Function<? super T, ? extends V> groupBy, Function<? super T, BigDecimal> function) {
        UnifiedMap<V, BigDecimal> result = UnifiedMap.newMap();
        for (Object each2 : array) {
            result.updateValue(groupBy.valueOf(each2), Functions0.zeroBigDecimal(), original -> original.add((BigDecimal)function.valueOf((Object)each2)));
        }
        return result;
    }

    public static <V, T> MutableMap<V, BigInteger> sumByBigInteger(T[] array, Function<? super T, ? extends V> groupBy, Function<? super T, BigInteger> function) {
        UnifiedMap<V, BigInteger> result = UnifiedMap.newMap();
        for (Object each2 : array) {
            result.updateValue(groupBy.valueOf(each2), Functions0.zeroBigInteger(), original -> original.add((BigInteger)function.valueOf((Object)each2)));
        }
        return result;
    }

    public static <V, T> ObjectLongMap<V> sumByInt(T[] array, Function<? super T, ? extends V> groupBy, IntFunction<? super T> function) {
        return InternalArrayIterate.sumByInt(array, array.length, groupBy, function);
    }

    public static <V, T> ObjectLongMap<V> sumByLong(T[] array, Function<? super T, ? extends V> groupBy, LongFunction<? super T> function) {
        return InternalArrayIterate.sumByLong(array, array.length, groupBy, function);
    }

    public static <V, T> ObjectDoubleMap<V> sumByFloat(T[] array, Function<? super T, ? extends V> groupBy, FloatFunction<? super T> function) {
        return InternalArrayIterate.sumByFloat(array, array.length, groupBy, function);
    }

    public static <V, T> ObjectDoubleMap<V> sumByDouble(T[] array, Function<? super T, ? extends V> groupBy, DoubleFunction<? super T> function) {
        return InternalArrayIterate.sumByDouble(array, array.length, groupBy, function);
    }
}

