/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.utility.internal;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.block.HashingStrategy;
import org.eclipse.collections.api.block.function.Function;
import org.eclipse.collections.api.block.function.Function0;
import org.eclipse.collections.api.block.function.Function2;
import org.eclipse.collections.api.block.function.Function3;
import org.eclipse.collections.api.block.function.primitive.BooleanFunction;
import org.eclipse.collections.api.block.function.primitive.ByteFunction;
import org.eclipse.collections.api.block.function.primitive.CharFunction;
import org.eclipse.collections.api.block.function.primitive.DoubleFunction;
import org.eclipse.collections.api.block.function.primitive.DoubleObjectToDoubleFunction;
import org.eclipse.collections.api.block.function.primitive.FloatFunction;
import org.eclipse.collections.api.block.function.primitive.FloatObjectToFloatFunction;
import org.eclipse.collections.api.block.function.primitive.IntFunction;
import org.eclipse.collections.api.block.function.primitive.IntObjectToIntFunction;
import org.eclipse.collections.api.block.function.primitive.LongFunction;
import org.eclipse.collections.api.block.function.primitive.LongObjectToLongFunction;
import org.eclipse.collections.api.block.function.primitive.ShortFunction;
import org.eclipse.collections.api.block.predicate.Predicate;
import org.eclipse.collections.api.block.predicate.Predicate2;
import org.eclipse.collections.api.block.procedure.Procedure;
import org.eclipse.collections.api.block.procedure.Procedure2;
import org.eclipse.collections.api.block.procedure.primitive.ObjectIntProcedure;
import org.eclipse.collections.api.collection.MutableCollection;
import org.eclipse.collections.api.collection.primitive.MutableBooleanCollection;
import org.eclipse.collections.api.collection.primitive.MutableByteCollection;
import org.eclipse.collections.api.collection.primitive.MutableCharCollection;
import org.eclipse.collections.api.collection.primitive.MutableDoubleCollection;
import org.eclipse.collections.api.collection.primitive.MutableFloatCollection;
import org.eclipse.collections.api.collection.primitive.MutableIntCollection;
import org.eclipse.collections.api.collection.primitive.MutableLongCollection;
import org.eclipse.collections.api.collection.primitive.MutableShortCollection;
import org.eclipse.collections.api.factory.Lists;
import org.eclipse.collections.api.list.MutableList;
import org.eclipse.collections.api.map.MutableMap;
import org.eclipse.collections.api.map.MutableMapIterable;
import org.eclipse.collections.api.multimap.ImmutableMultimap;
import org.eclipse.collections.api.multimap.MutableMultimap;
import org.eclipse.collections.api.partition.PartitionMutableCollection;
import org.eclipse.collections.api.partition.list.PartitionMutableList;
import org.eclipse.collections.api.tuple.Pair;
import org.eclipse.collections.api.tuple.Twin;
import org.eclipse.collections.impl.block.factory.Functions0;
import org.eclipse.collections.impl.block.procedure.MutatingAggregationProcedure;
import org.eclipse.collections.impl.block.procedure.NonMutatingAggregationProcedure;
import org.eclipse.collections.impl.list.mutable.FastList;
import org.eclipse.collections.impl.list.mutable.primitive.BooleanArrayList;
import org.eclipse.collections.impl.list.mutable.primitive.ByteArrayList;
import org.eclipse.collections.impl.list.mutable.primitive.CharArrayList;
import org.eclipse.collections.impl.list.mutable.primitive.DoubleArrayList;
import org.eclipse.collections.impl.list.mutable.primitive.FloatArrayList;
import org.eclipse.collections.impl.list.mutable.primitive.IntArrayList;
import org.eclipse.collections.impl.list.mutable.primitive.LongArrayList;
import org.eclipse.collections.impl.list.mutable.primitive.ShortArrayList;
import org.eclipse.collections.impl.map.mutable.UnifiedMap;
import org.eclipse.collections.impl.multimap.list.FastListMultimap;
import org.eclipse.collections.impl.partition.list.PartitionFastList;
import org.eclipse.collections.impl.set.mutable.UnifiedSet;
import org.eclipse.collections.impl.set.strategy.mutable.UnifiedSetWithHashingStrategy;
import org.eclipse.collections.impl.tuple.Tuples;
import org.eclipse.collections.impl.utility.Iterate;

public final class IteratorIterate {
    private IteratorIterate() {
        throw new AssertionError((Object)"Suppress default constructor for noninstantiability");
    }

    public static <T, P> Twin<MutableList<T>> selectAndRejectWith(Iterator<T> iterator2, Predicate2<? super T, ? super P> predicate, P parameter) {
        MutableList positiveResult = Lists.mutable.empty();
        MutableList negativeResult = Lists.mutable.empty();
        while (iterator2.hasNext()) {
            T item = iterator2.next();
            (predicate.accept(item, parameter) ? positiveResult : negativeResult).add(item);
        }
        return Tuples.twin(positiveResult, negativeResult);
    }

    public static <T> PartitionMutableList<T> partition(Iterator<T> iterator2, Predicate<? super T> predicate) {
        PartitionFastList result = new PartitionFastList();
        MutableCollection selected = result.getSelected();
        MutableCollection rejected = result.getRejected();
        while (iterator2.hasNext()) {
            T each2 = iterator2.next();
            MutableCollection bucket = predicate.accept(each2) ? selected : rejected;
            bucket.add(each2);
        }
        return result;
    }

    public static <T, P> PartitionMutableList<T> partitionWith(Iterator<T> iterator2, Predicate2<? super T, ? super P> predicate, P parameter) {
        PartitionFastList result = new PartitionFastList();
        MutableCollection selected = result.getSelected();
        MutableCollection rejected = result.getRejected();
        while (iterator2.hasNext()) {
            T each2 = iterator2.next();
            MutableCollection bucket = predicate.accept(each2, parameter) ? selected : rejected;
            bucket.add(each2);
        }
        return result;
    }

    public static <T, R extends PartitionMutableCollection<T>> R partitionWhile(Iterator<T> iterator2, Predicate<? super T> predicate, R target) {
        RichIterable selected = target.getSelected();
        RichIterable rejected = target.getRejected();
        boolean partitionFound = false;
        while (iterator2.hasNext() && !partitionFound) {
            T next = iterator2.next();
            if (predicate.accept(next)) {
                selected.add(next);
                continue;
            }
            rejected.add(next);
            partitionFound = true;
        }
        while (iterator2.hasNext()) {
            rejected.add(iterator2.next());
        }
        return target;
    }

    public static <T, R extends MutableCollection<T>> R takeWhile(Iterator<T> iterator2, Predicate<? super T> predicate, R target) {
        while (iterator2.hasNext()) {
            T next = iterator2.next();
            if (predicate.accept(next)) {
                target.add(next);
                continue;
            }
            return target;
        }
        return target;
    }

    public static <T, R extends MutableCollection<T>> R dropWhile(Iterator<T> iterator2, Predicate<? super T> predicate, R target) {
        boolean partitionFound = false;
        while (iterator2.hasNext() && !partitionFound) {
            T next = iterator2.next();
            if (predicate.accept(next)) continue;
            target.add(next);
            partitionFound = true;
        }
        while (iterator2.hasNext()) {
            target.add(iterator2.next());
        }
        return target;
    }

    public static <T> int count(Iterator<T> iterator2, Predicate<? super T> predicate) {
        int count2 = 0;
        while (iterator2.hasNext()) {
            if (!predicate.accept(iterator2.next())) continue;
            ++count2;
        }
        return count2;
    }

    public static <T, P> int countWith(Iterator<T> iterator2, Predicate2<? super T, ? super P> predicate, P parameter) {
        int count2 = 0;
        while (iterator2.hasNext()) {
            if (!predicate.accept(iterator2.next(), parameter)) continue;
            ++count2;
        }
        return count2;
    }

    public static <T, R extends Collection<T>> R select(Iterator<T> iterator2, Predicate<? super T> predicate, R targetCollection) {
        while (iterator2.hasNext()) {
            T item = iterator2.next();
            if (!predicate.accept(item)) continue;
            targetCollection.add(item);
        }
        return targetCollection;
    }

    public static <T, P, R extends Collection<T>> R selectWith(Iterator<T> iterator2, Predicate2<? super T, ? super P> predicate, P injectedValue, R targetCollection) {
        while (iterator2.hasNext()) {
            T item = iterator2.next();
            if (!predicate.accept(item, injectedValue)) continue;
            targetCollection.add(item);
        }
        return targetCollection;
    }

    public static <T, R extends Collection<T>> R selectInstancesOf(Iterator<?> iterator2, Class<T> clazz, R targetCollection) {
        while (iterator2.hasNext()) {
            Object item = iterator2.next();
            if (!clazz.isInstance(item)) continue;
            targetCollection.add(item);
        }
        return targetCollection;
    }

    public static <T, V, R extends Collection<V>> R collectIf(Iterator<T> iterator2, Predicate<? super T> predicate, Function<? super T, ? extends V> function, R targetCollection) {
        while (iterator2.hasNext()) {
            T item = iterator2.next();
            if (!predicate.accept(item)) continue;
            targetCollection.add(function.valueOf(item));
        }
        return targetCollection;
    }

    public static <T, R extends Collection<T>> R reject(Iterator<T> iterator2, Predicate<? super T> predicate, R targetCollection) {
        while (iterator2.hasNext()) {
            T item = iterator2.next();
            if (predicate.accept(item)) continue;
            targetCollection.add(item);
        }
        return targetCollection;
    }

    public static <T, P, R extends Collection<T>> R rejectWith(Iterator<T> iterator2, Predicate2<? super T, ? super P> predicate, P parameter, R targetCollection) {
        while (iterator2.hasNext()) {
            T item = iterator2.next();
            if (predicate.accept(item, parameter)) continue;
            targetCollection.add(item);
        }
        return targetCollection;
    }

    public static <T, V, R extends Collection<V>> R collect(Iterator<T> iterator2, Function<? super T, ? extends V> function, R targetCollection) {
        while (iterator2.hasNext()) {
            targetCollection.add(function.valueOf(iterator2.next()));
        }
        return targetCollection;
    }

    public static <T> MutableBooleanCollection collectBoolean(Iterator<T> iterator2, BooleanFunction<? super T> booleanFunction) {
        BooleanArrayList result = new BooleanArrayList();
        while (iterator2.hasNext()) {
            result.add(booleanFunction.booleanValueOf(iterator2.next()));
        }
        return result;
    }

    public static <T, R extends MutableBooleanCollection> R collectBoolean(Iterator<T> iterator2, BooleanFunction<? super T> booleanFunction, R target) {
        while (iterator2.hasNext()) {
            target.add(booleanFunction.booleanValueOf(iterator2.next()));
        }
        return target;
    }

    public static <T> MutableByteCollection collectByte(Iterator<T> iterator2, ByteFunction<? super T> byteFunction) {
        ByteArrayList result = new ByteArrayList();
        while (iterator2.hasNext()) {
            result.add(byteFunction.byteValueOf(iterator2.next()));
        }
        return result;
    }

    public static <T, R extends MutableByteCollection> R collectByte(Iterator<T> iterator2, ByteFunction<? super T> byteFunction, R target) {
        while (iterator2.hasNext()) {
            target.add(byteFunction.byteValueOf(iterator2.next()));
        }
        return target;
    }

    public static <T> MutableCharCollection collectChar(Iterator<T> iterator2, CharFunction<? super T> charFunction) {
        CharArrayList result = new CharArrayList();
        while (iterator2.hasNext()) {
            result.add(charFunction.charValueOf(iterator2.next()));
        }
        return result;
    }

    public static <T, R extends MutableCharCollection> R collectChar(Iterator<T> iterator2, CharFunction<? super T> charFunction, R target) {
        while (iterator2.hasNext()) {
            target.add(charFunction.charValueOf(iterator2.next()));
        }
        return target;
    }

    public static <T> MutableDoubleCollection collectDouble(Iterator<T> iterator2, DoubleFunction<? super T> doubleFunction) {
        DoubleArrayList result = new DoubleArrayList();
        while (iterator2.hasNext()) {
            result.add(doubleFunction.doubleValueOf(iterator2.next()));
        }
        return result;
    }

    public static <T, R extends MutableDoubleCollection> R collectDouble(Iterator<T> iterator2, DoubleFunction<? super T> doubleFunction, R target) {
        while (iterator2.hasNext()) {
            target.add(doubleFunction.doubleValueOf(iterator2.next()));
        }
        return target;
    }

    public static <T> MutableFloatCollection collectFloat(Iterator<T> iterator2, FloatFunction<? super T> floatFunction) {
        FloatArrayList result = new FloatArrayList();
        while (iterator2.hasNext()) {
            result.add(floatFunction.floatValueOf(iterator2.next()));
        }
        return result;
    }

    public static <T, R extends MutableFloatCollection> R collectFloat(Iterator<T> iterator2, FloatFunction<? super T> floatFunction, R target) {
        while (iterator2.hasNext()) {
            target.add(floatFunction.floatValueOf(iterator2.next()));
        }
        return target;
    }

    public static <T> MutableIntCollection collectInt(Iterator<T> iterator2, IntFunction<? super T> intFunction) {
        IntArrayList result = new IntArrayList();
        while (iterator2.hasNext()) {
            result.add(intFunction.intValueOf(iterator2.next()));
        }
        return result;
    }

    public static <T, R extends MutableIntCollection> R collectInt(Iterator<T> iterator2, IntFunction<? super T> intFunction, R target) {
        while (iterator2.hasNext()) {
            target.add(intFunction.intValueOf(iterator2.next()));
        }
        return target;
    }

    public static <T> MutableLongCollection collectLong(Iterator<T> iterator2, LongFunction<? super T> longFunction) {
        LongArrayList result = new LongArrayList();
        while (iterator2.hasNext()) {
            result.add(longFunction.longValueOf(iterator2.next()));
        }
        return result;
    }

    public static <T, R extends MutableLongCollection> R collectLong(Iterator<T> iterator2, LongFunction<? super T> longFunction, R target) {
        while (iterator2.hasNext()) {
            target.add(longFunction.longValueOf(iterator2.next()));
        }
        return target;
    }

    public static <T> MutableShortCollection collectShort(Iterator<T> iterator2, ShortFunction<? super T> shortFunction) {
        ShortArrayList result = new ShortArrayList();
        while (iterator2.hasNext()) {
            result.add(shortFunction.shortValueOf(iterator2.next()));
        }
        return result;
    }

    public static <T, R extends MutableShortCollection> R collectShort(Iterator<T> iterator2, ShortFunction<? super T> shortFunction, R target) {
        while (iterator2.hasNext()) {
            target.add(shortFunction.shortValueOf(iterator2.next()));
        }
        return target;
    }

    public static <T, V, R extends Collection<V>> R flatCollect(Iterator<T> iterator2, Function<? super T, ? extends Iterable<V>> function, R targetCollection) {
        while (iterator2.hasNext()) {
            Iterate.addAllTo(function.valueOf(iterator2.next()), targetCollection);
        }
        return targetCollection;
    }

    public static <T> void forEach(Iterator<T> iterator2, Procedure<? super T> procedure) {
        while (iterator2.hasNext()) {
            procedure.value(iterator2.next());
        }
    }

    public static <T> void forEachWithIndex(Iterator<T> iterator2, ObjectIntProcedure<? super T> objectIntProcedure) {
        int i = 0;
        while (iterator2.hasNext()) {
            objectIntProcedure.value(iterator2.next(), i++);
        }
    }

    public static <T> T detect(Iterator<T> iterator2, Predicate<? super T> predicate) {
        while (iterator2.hasNext()) {
            T each2 = iterator2.next();
            if (!predicate.accept(each2)) continue;
            return each2;
        }
        return null;
    }

    public static <T, P> T detectWith(Iterator<T> iterator2, Predicate2<? super T, ? super P> predicate, P parameter) {
        while (iterator2.hasNext()) {
            T each2 = iterator2.next();
            if (!predicate.accept(each2, parameter)) continue;
            return each2;
        }
        return null;
    }

    public static <T> Optional<T> detectOptional(Iterator<T> iterator2, Predicate<? super T> predicate) {
        while (iterator2.hasNext()) {
            T each2 = iterator2.next();
            if (!predicate.accept(each2)) continue;
            return Optional.of(each2);
        }
        return Optional.empty();
    }

    public static <T, P> Optional<T> detectWithOptional(Iterator<T> iterator2, Predicate2<? super T, ? super P> predicate, P parameter) {
        while (iterator2.hasNext()) {
            T each2 = iterator2.next();
            if (!predicate.accept(each2, parameter)) continue;
            return Optional.of(each2);
        }
        return Optional.empty();
    }

    public static <T, IV> IV injectInto(IV injectValue, Iterator<T> iterator2, Function2<? super IV, ? super T, ? extends IV> function) {
        IV result = injectValue;
        while (iterator2.hasNext()) {
            result = function.value(result, iterator2.next());
        }
        return result;
    }

    public static <T> int injectInto(int injectValue, Iterator<T> iterator2, IntObjectToIntFunction<? super T> function) {
        int result = injectValue;
        while (iterator2.hasNext()) {
            result = function.intValueOf(result, iterator2.next());
        }
        return result;
    }

    public static <T> long injectInto(long injectValue, Iterator<T> iterator2, LongObjectToLongFunction<? super T> function) {
        long result = injectValue;
        while (iterator2.hasNext()) {
            result = function.longValueOf(result, iterator2.next());
        }
        return result;
    }

    public static <T> double injectInto(double injectValue, Iterator<T> iterator2, DoubleObjectToDoubleFunction<? super T> function) {
        double result = injectValue;
        while (iterator2.hasNext()) {
            result = function.doubleValueOf(result, iterator2.next());
        }
        return result;
    }

    public static <T> float injectInto(float injectValue, Iterator<T> iterator2, FloatObjectToFloatFunction<? super T> function) {
        float result = injectValue;
        while (iterator2.hasNext()) {
            result = function.floatValueOf(result, iterator2.next());
        }
        return result;
    }

    public static <T, IV, P> IV injectIntoWith(IV injectValue, Iterator<T> iterator2, Function3<? super IV, ? super T, ? super P, ? extends IV> function, P parameter) {
        IV result = injectValue;
        while (iterator2.hasNext()) {
            result = function.value(result, iterator2.next(), parameter);
        }
        return result;
    }

    public static <T> boolean shortCircuit(Iterator<T> iterator2, Predicate<? super T> predicate, boolean expected, boolean onShortCircuit, boolean atEnd) {
        while (iterator2.hasNext()) {
            T each2 = iterator2.next();
            if (predicate.accept(each2) != expected) continue;
            return onShortCircuit;
        }
        return atEnd;
    }

    public static <T, P> boolean shortCircuitWith(Iterator<T> iterator2, Predicate2<? super T, ? super P> predicate2, P parameter, boolean expected, boolean onShortCircuit, boolean atEnd) {
        while (iterator2.hasNext()) {
            T each2 = iterator2.next();
            if (predicate2.accept(each2, parameter) != expected) continue;
            return onShortCircuit;
        }
        return atEnd;
    }

    public static <T> boolean anySatisfy(Iterator<T> iterator2, Predicate<? super T> predicate) {
        return IteratorIterate.shortCircuit(iterator2, predicate, true, true, false);
    }

    public static <T, P> boolean anySatisfyWith(Iterator<T> iterator2, Predicate2<? super T, ? super P> predicate, P parameter) {
        return IteratorIterate.shortCircuitWith(iterator2, predicate, parameter, true, true, false);
    }

    public static <T> boolean allSatisfy(Iterator<T> iterator2, Predicate<? super T> predicate) {
        return IteratorIterate.shortCircuit(iterator2, predicate, false, false, true);
    }

    public static <T, P> boolean allSatisfyWith(Iterator<T> iterator2, Predicate2<? super T, ? super P> predicate, P parameter) {
        return IteratorIterate.shortCircuitWith(iterator2, predicate, parameter, false, false, true);
    }

    public static <T> boolean noneSatisfy(Iterator<T> iterator2, Predicate<? super T> predicate) {
        return IteratorIterate.shortCircuit(iterator2, predicate, true, false, true);
    }

    public static <T, P> boolean noneSatisfyWith(Iterator<T> iterator2, Predicate2<? super T, ? super P> predicate, P parameter) {
        return IteratorIterate.shortCircuitWith(iterator2, predicate, parameter, true, false, true);
    }

    public static <T> boolean removeIf(Iterator<T> iterator2, Predicate<? super T> predicate) {
        boolean changed = false;
        while (iterator2.hasNext()) {
            T each2 = iterator2.next();
            if (!predicate.accept(each2)) continue;
            iterator2.remove();
            changed = true;
        }
        return changed;
    }

    public static <T, P> boolean removeIfWith(Iterator<T> iterator2, Predicate2<? super T, ? super P> predicate, P parameter) {
        boolean changed = false;
        while (iterator2.hasNext()) {
            T each2 = iterator2.next();
            if (!predicate.accept(each2, parameter)) continue;
            iterator2.remove();
            changed = true;
        }
        return changed;
    }

    public static <T> boolean removeIf(Iterator<T> iterator2, Predicate<? super T> predicate, Procedure<? super T> procedure) {
        boolean changed = false;
        while (iterator2.hasNext()) {
            T each2 = iterator2.next();
            if (!predicate.accept(each2)) continue;
            procedure.value(each2);
            iterator2.remove();
            changed = true;
        }
        return changed;
    }

    public static <T, P> boolean removeIfWith(Iterator<T> iterator2, Predicate2<? super T, ? super P> predicate, P parameter, Procedure<? super T> procedure) {
        boolean changed = false;
        while (iterator2.hasNext()) {
            T each2 = iterator2.next();
            if (!predicate.accept(each2, parameter)) continue;
            procedure.value(each2);
            iterator2.remove();
            changed = true;
        }
        return changed;
    }

    public static <T> int detectIndex(Iterator<T> iterator2, Predicate<? super T> predicate) {
        int i = 0;
        while (iterator2.hasNext()) {
            if (predicate.accept(iterator2.next())) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static <T, IV> int detectIndexWith(Iterator<T> iterator2, Predicate2<? super T, ? super IV> predicate, IV injectedValue) {
        int i = 0;
        while (iterator2.hasNext()) {
            if (predicate.accept(iterator2.next(), injectedValue)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static <T, P> void forEachWith(Iterator<T> iterator2, Procedure2<? super T, ? super P> procedure, P parameter) {
        while (iterator2.hasNext()) {
            procedure.value(iterator2.next(), parameter);
        }
    }

    public static <T, P, A, R extends Collection<A>> R collectWith(Iterator<T> iterator2, Function2<? super T, ? super P, ? extends A> function, P parameter, R targetCollection) {
        while (iterator2.hasNext()) {
            targetCollection.add(function.value(iterator2.next(), parameter));
        }
        return targetCollection;
    }

    public static <T, V> ImmutableMultimap<V, T> groupBy(Iterator<T> iterator2, Function<? super T, ? extends V> function) {
        return IteratorIterate.groupBy(iterator2, function, new FastListMultimap()).toImmutable();
    }

    public static <T, V, R extends MutableMultimap<V, T>> R groupBy(Iterator<T> iterator2, Function<? super T, ? extends V> function, R target) {
        while (iterator2.hasNext()) {
            T item = iterator2.next();
            target.put(function.valueOf(item), item);
        }
        return target;
    }

    public static <T, V, R extends MutableMultimap<V, T>> R groupByEach(Iterator<T> iterator2, Function<? super T, ? extends Iterable<V>> function, R target) {
        while (iterator2.hasNext()) {
            T item = iterator2.next();
            Iterable<V> iterable = function.valueOf(item);
            for (V key : iterable) {
                target.put(key, item);
            }
        }
        return target;
    }

    public static <K, T, R extends MutableMapIterable<K, T>> R groupByUniqueKey(Iterator<T> iterator2, Function<? super T, ? extends K> function, R target) {
        while (iterator2.hasNext()) {
            T value = iterator2.next();
            K key = function.valueOf(value);
            if (target.put(key, value) == null) continue;
            throw new IllegalStateException("Key " + key + " already exists in map!");
        }
        return target;
    }

    @Deprecated
    public static <T, R extends List<T>> R distinct(Iterator<T> iterator2, R targetCollection) {
        UnifiedSet seenSoFar = UnifiedSet.newSet();
        while (iterator2.hasNext()) {
            T item = iterator2.next();
            if (!seenSoFar.add(item)) continue;
            targetCollection.add(item);
        }
        return targetCollection;
    }

    public static <T> MutableList<T> distinct(Iterator<T> iterator2) {
        return IteratorIterate.distinct(iterator2, FastList.newList());
    }

    public static <T> MutableList<T> distinct(Iterator<T> iterator2, HashingStrategy<? super T> hashingStrategy) {
        UnifiedSetWithHashingStrategy<T> seenSoFar = UnifiedSetWithHashingStrategy.newSet(hashingStrategy);
        FastList result = FastList.newList();
        while (iterator2.hasNext()) {
            T item = iterator2.next();
            if (!seenSoFar.add(item)) continue;
            result.add(item);
        }
        return result;
    }

    public static <X, Y, R extends Collection<Pair<X, Y>>> R zip(Iterator<X> xs, Iterator<Y> ys, R target) {
        while (xs.hasNext() && ys.hasNext()) {
            target.add(Tuples.pair(xs.next(), ys.next()));
        }
        return target;
    }

    public static <T, R extends Collection<Pair<T, Integer>>> R zipWithIndex(Iterator<T> iterator2, R target) {
        int index = 0;
        while (iterator2.hasNext()) {
            target.add(Tuples.pair(iterator2.next(), index));
            ++index;
        }
        return target;
    }

    public static <T> RichIterable<RichIterable<T>> chunk(Iterator<T> iterator2, int size2) {
        if (size2 <= 0) {
            throw new IllegalArgumentException("Size for groups must be positive but was: " + size2);
        }
        MutableList<RichIterable<T>> result = Lists.mutable.empty();
        while (iterator2.hasNext()) {
            MutableList batch = Lists.mutable.empty();
            for (int i = 0; i < size2 && iterator2.hasNext(); ++i) {
                batch.add(iterator2.next());
            }
            result.add(batch);
        }
        return result;
    }

    public static <T> T min(Iterator<T> iterator2, Comparator<? super T> comparator) {
        T min2 = iterator2.next();
        while (iterator2.hasNext()) {
            T next = iterator2.next();
            if (comparator.compare(next, min2) >= 0) continue;
            min2 = next;
        }
        return min2;
    }

    public static <T> T max(Iterator<T> iterator2, Comparator<? super T> comparator) {
        T max2 = iterator2.next();
        while (iterator2.hasNext()) {
            T next = iterator2.next();
            if (comparator.compare(next, max2) <= 0) continue;
            max2 = next;
        }
        return max2;
    }

    public static <T> Iterator<T> advanceIteratorTo(Iterator<T> iterator2, int from) {
        for (int i = 0; i < from; ++i) {
            iterator2.next();
        }
        return iterator2;
    }

    public static <T> long sumOfInt(Iterator<T> iterator2, IntFunction<? super T> function) {
        long sum2 = 0L;
        while (iterator2.hasNext()) {
            sum2 += (long)function.intValueOf(iterator2.next());
        }
        return sum2;
    }

    public static <T> long sumOfLong(Iterator<T> iterator2, LongFunction<? super T> function) {
        long sum2 = 0L;
        while (iterator2.hasNext()) {
            sum2 += function.longValueOf(iterator2.next());
        }
        return sum2;
    }

    public static <T> double sumOfFloat(Iterator<T> iterator2, FloatFunction<? super T> function) {
        double sum2 = 0.0;
        double compensation = 0.0;
        while (iterator2.hasNext()) {
            double adjustedValue = (double)function.floatValueOf(iterator2.next()) - compensation;
            double nextSum = sum2 + adjustedValue;
            compensation = nextSum - sum2 - adjustedValue;
            sum2 = nextSum;
        }
        return sum2;
    }

    public static <T> double sumOfDouble(Iterator<T> iterator2, DoubleFunction<? super T> function) {
        double sum2 = 0.0;
        double compensation = 0.0;
        while (iterator2.hasNext()) {
            double adjustedValue = function.doubleValueOf(iterator2.next()) - compensation;
            double nextSum = sum2 + adjustedValue;
            compensation = nextSum - sum2 - adjustedValue;
            sum2 = nextSum;
        }
        return sum2;
    }

    public static <T> BigDecimal sumOfBigDecimal(Iterator<T> iterator2, Function<? super T, BigDecimal> function) {
        BigDecimal result = BigDecimal.ZERO;
        while (iterator2.hasNext()) {
            result = result.add(function.valueOf(iterator2.next()));
        }
        return result;
    }

    public static <T> BigInteger sumOfBigInteger(Iterator<T> iterator2, Function<? super T, BigInteger> function) {
        BigInteger result = BigInteger.ZERO;
        while (iterator2.hasNext()) {
            result = result.add(function.valueOf(iterator2.next()));
        }
        return result;
    }

    public static <V, T> MutableMap<V, BigDecimal> sumByBigDecimal(Iterator<T> iterator2, Function<? super T, ? extends V> groupBy, Function<? super T, BigDecimal> function) {
        UnifiedMap<V, BigDecimal> result = UnifiedMap.newMap();
        while (iterator2.hasNext()) {
            Object item = iterator2.next();
            result.updateValue(groupBy.valueOf(item), Functions0.zeroBigDecimal(), original -> original.add((BigDecimal)function.valueOf((Object)item)));
        }
        return result;
    }

    public static <V, T> MutableMap<V, BigInteger> sumByBigInteger(Iterator<T> iterator2, Function<? super T, ? extends V> groupBy, Function<? super T, BigInteger> function) {
        UnifiedMap<V, BigInteger> result = UnifiedMap.newMap();
        while (iterator2.hasNext()) {
            Object item = iterator2.next();
            result.updateValue(groupBy.valueOf(item), Functions0.zeroBigInteger(), original -> original.add((BigInteger)function.valueOf((Object)item)));
        }
        return result;
    }

    public static <T, K, V> MutableMap<K, V> aggregateBy(Iterator<T> iterator2, Function<? super T, ? extends K> groupBy, Function0<? extends V> zeroValueFactory, Procedure2<? super V, ? super T> mutatingAggregator) {
        UnifiedMap map2 = UnifiedMap.newMap();
        IteratorIterate.forEach(iterator2, new MutatingAggregationProcedure<T, K, V>(map2, groupBy, zeroValueFactory, mutatingAggregator));
        return map2;
    }

    public static <T, K, V> MutableMap<K, V> aggregateBy(Iterator<T> iterator2, Function<? super T, ? extends K> groupBy, Function0<? extends V> zeroValueFactory, Function2<? super V, ? super T, ? extends V> nonMutatingAggregator) {
        UnifiedMap map2 = UnifiedMap.newMap();
        IteratorIterate.forEach(iterator2, new NonMutatingAggregationProcedure<T, K, V>(map2, groupBy, zeroValueFactory, nonMutatingAggregator));
        return map2;
    }

    public static <T, V extends Comparable<? super V>> T minBy(Iterator<T> iterator2, Function<? super T, ? extends V> function) {
        T min2 = iterator2.next();
        Comparable minValue = (Comparable)function.valueOf(min2);
        while (iterator2.hasNext()) {
            T next = iterator2.next();
            Comparable nextValue = (Comparable)function.valueOf(next);
            if (nextValue.compareTo(minValue) >= 0) continue;
            min2 = next;
            minValue = nextValue;
        }
        return min2;
    }

    public static <T, V extends Comparable<? super V>> T maxBy(Iterator<T> iterator2, Function<? super T, ? extends V> function) {
        T max2 = iterator2.next();
        Comparable maxValue = (Comparable)function.valueOf(max2);
        while (iterator2.hasNext()) {
            T next = iterator2.next();
            Comparable nextValue = (Comparable)function.valueOf(next);
            if (nextValue.compareTo(maxValue) <= 0) continue;
            max2 = next;
            maxValue = nextValue;
        }
        return max2;
    }
}

