/*
 * Decompiled with CFR 0.152.
 */
package sesim;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import sesim.Asset;
import sesim.AutoTrader;
import sesim.Market;
import sesim.Order;
import sesim.Position;
import sesim.util.FixedPoint;

public class Account {
    final Asset currency;
    private Market.AccountListener listener = null;
    long cash;
    long maxMargin = 100L;
    protected AutoTrader owner;
    final ConcurrentHashMap<Long, Order> orders;
    private final HashMap<Market, Position> positions;
    private HashMap<Market, Position> snap_positions = new HashMap();
    private long snap_cash;
    boolean isLiquided = false;

    Account(Asset currency, long initialCash) {
        this.orders = new ConcurrentHashMap();
        this.positions = new HashMap();
        this.currency = currency;
        this.cash = currency.round_Long(initialCash);
    }

    Account(Asset currency, double initialCash) {
        this(currency, FixedPoint.toInternal(initialCash));
    }

    void makeSnapShot() {
        this.snap_positions = new HashMap();
        for (Market m : this.positions.keySet()) {
            Position p = new Position(this.positions.get(m));
            this.snap_positions.put(m, p);
        }
        this.snap_cash = this.cash;
    }

    public Map<Market, Position> getPositions() {
        return Collections.unmodifiableMap(this.positions);
    }

    void cancelAllOrders() {
        for (Order o : this.orders.values()) {
            o.getMarket().cancelOrder(this, o.id);
        }
    }

    long getMarginUsed_Long() {
        long totalMargin = 0L;
        for (Position pos : this.positions.values()) {
            totalMargin += pos.getMargin_Long();
        }
        return totalMargin;
    }

    public double getMarginUsed() {
        return FixedPoint.toExternal(this.getMarginUsed_Long());
    }

    public double getShares(Market m) {
        return FixedPoint.toExternal(this.getShares_Long(m));
    }

    public long getShares_Long(Market m) {
        return this.getPosition(m).getShares_Long();
    }

    public double getMoney() {
        return FixedPoint.toExternal(this.cash);
    }

    public long getMoney_Long() {
        return this.cash;
    }

    void addCash(double m) {
        this.cash = (long)((double)this.cash + m * this.currency.getDf());
    }

    public AutoTrader getOwner() {
        return this.owner;
    }

    public Map<Long, Order> getOrders() {
        return Collections.unmodifiableMap(this.orders);
    }

    public void setListener(Market.AccountListener al) {
        this.listener = al;
    }

    public void update(Order o) {
        if (this.listener == null) {
            return;
        }
        this.listener.accountUpdated(this, o);
    }

    public int getNumberOfOpenOrders() {
        return this.orders.size();
    }

    public long getCashInOpenOrders_Long(long exclude) {
        Iterator<Map.Entry<Long, Order>> it = this.getOrders().entrySet().iterator();
        long orderCash = 0L;
        while (it.hasNext()) {
            Map.Entry<Long, Order> e = it.next();
            Order o = e.getValue();
            if (!o.isBuy() || !o.hasLimit() || o.id == exclude) continue;
            orderCash += FixedPoint.multiply(o.getInitialVolume_Long(), o.getLimit_Long()) - FixedPoint.multiply(o.getExecuted_Long(), o.getLimit_Long());
        }
        return orderCash;
    }

    public long getCashInOpenOrders_Long() {
        return this.getCashInOpenOrders_Long(-1L);
    }

    public double getCashInOpenOrders() {
        return (double)this.getCashInOpenOrders_Long() / this.currency.getDf();
    }

    public long getSharesInOpenOrders_Long(Position p, long exclude) {
        Iterator<Map.Entry<Long, Order>> it = this.getOrders().entrySet().iterator();
        long volume2 = 0L;
        while (it.hasNext()) {
            Map.Entry<Long, Order> e = it.next();
            Order o = e.getValue();
            if (o.position != p || !o.isSell() || o.id == exclude) continue;
            volume2 += o.getInitialVolume_Long() - o.getExecuted_Long();
        }
        return volume2;
    }

    public long getSharesInOpenOrders_Long(Position p) {
        return this.getSharesInOpenOrders_Long(p, -1L);
    }

    public float getSharesInOpenOrders() {
        return 0.0f;
    }

    public long getCashAvailabale_Long() {
        return this.cash;
    }

    public double getCashAvailable() {
        return this.getMoney() - this.getCashInOpenOrders();
    }

    public Order getOrderByID(long oid) {
        return this.orders.get(oid);
    }

    public boolean isOrderCovered_Long(Position p, byte type, long volume2, long price, int leverage, long ignoid) {
        if (this.maxMargin == 0L) {
            if (volume2 < 0L) {
                long so = this.getSharesInOpenOrders_Long(p, ignoid);
                return p.shares + volume2 - so >= 0L;
            }
            if ((type & 2) != 0) {
                long c = FixedPoint.multiply(volume2, price);
                return c <= this.cash - this.getCashInOpenOrders_Long(ignoid);
            }
            return true;
        }
        return true;
    }

    public boolean isOrderCovered(Market market, byte type, double volume2, double price, int leverage, long ignoid) {
        return this.isOrderCovered_Long(this.getPosition(market), type, FixedPoint.toInternal(volume2), FixedPoint.toInternal(price), leverage, ignoid);
    }

    public double getRequiredCashForOrder(Market market, double volume2, double price, int leverage) {
        return (double)this.getPosition(market).getRequiredCashForOrder_Long((long)(volume2 * market.getAsset().getDf()), (long)(price * this.currency.getDf()), leverage) / this.currency.getDf();
    }

    public double getPerformance(double lastPrice) {
        double total = this.getEquity();
        double iniTotal = this.getSnapShotEquity();
        return total / (iniTotal / 100.0) - 100.0;
    }

    public final long getEquity_Long() {
        long equity = this.cash;
        for (Position pos : this.positions.values()) {
            equity += pos.getEquityValue_Long();
        }
        return equity;
    }

    public final long getEquity_Long(long price) {
        long equity = this.cash;
        for (Position pos : this.positions.values()) {
            equity += pos.getEquityValue_Long(price);
        }
        return equity;
    }

    double getCash() {
        return FixedPoint.toExternal(this.cash);
    }

    public double getEquity() {
        return FixedPoint.toExternal(this.getEquity_Long());
    }

    public final long getSnapshotEquity_Long() {
        long equity = this.snap_cash;
        for (Position pos : this.snap_positions.values()) {
            equity += pos.getEquityValue_Long();
        }
        return equity;
    }

    public double getSnapShotEquity() {
        return FixedPoint.toExternal(this.getSnapshotEquity_Long());
    }

    public long getFreeMargin_Long() {
        return this.getEquity_Long() * this.maxMargin / 100L - this.getMarginUsed_Long();
    }

    public double getFreeMargin() {
        return FixedPoint.toExternal(this.getFreeMargin_Long());
    }

    public final Position getPosition(Market asset) {
        Position p = this.positions.get(asset);
        if (p != null) {
            return p;
        }
        p = new Position(asset, this);
        this.positions.put(asset, p);
        return p;
    }

    public boolean isLiquidated() {
        return this.isLiquided;
    }

    void calculateLiquidationStops(long lastPrice) {
        double criticalEquity;
        if (this.isLiquided) {
            return;
        }
        double currentEquity = this.getEquity();
        double maxEquityToLose = currentEquity - (criticalEquity = 200.0);
        if (maxEquityToLose <= 0.0) {
            return;
        }
        double totalAbsoluteVolumeSum = 0.0;
        for (Position p : this.positions.values()) {
            totalAbsoluteVolumeSum += Math.abs(p.getMarketValue());
        }
        for (Position p : this.positions.values()) {
            double positionVolume = Math.abs(p.getMarketValue());
            double weight = positionVolume / totalAbsoluteVolumeSum;
            double toleratedLoss_i_long = maxEquityToLose * weight;
            double shares = Math.abs(p.getShares());
            if (shares == 0.0) continue;
            double lossPerShare_double = toleratedLoss_i_long / shares;
            long currentPrice = p.market.getLastPrice_Long();
            long stopPrice = p.isShort() ? currentPrice + FixedPoint.toInternal(lossPerShare_double) : currentPrice - FixedPoint.toInternal(lossPerShare_double);
            p.setStopPrice(stopPrice);
        }
    }

    public Asset getCurrency() {
        return this.currency;
    }

    public long setMaxMargin(long m) {
        if (m <= 100L && m >= 0L) {
            this.maxMargin = m;
        }
        return this.maxMargin;
    }

    public long getMaxMargin() {
        return this.maxMargin;
    }
}

