/*
 * Decompiled with CFR 0.152.
 */
package sesim;

import java.text.DecimalFormat;
import sesim.Asset;

public class AssetBase
implements Asset {
    private String symbol;
    private String name;
    private long df = 100L;
    private int decimals;
    private DecimalFormat formatter;

    public AssetBase(String symbol, String name, int decimals) {
        this.symbol = symbol;
        this.name = name;
        this.setDecimals(decimals);
    }

    @Override
    public String getSymbol() {
        return this.symbol;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public double getDf() {
        return this.df;
    }

    @Override
    public DecimalFormat getFormatter() {
        return this.formatter;
    }

    private void setDecimals(int n) {
        this.df = (long)Math.pow(10.0, n);
        this.df = 10000L / this.df;
        this.decimals = n;
        this.formatter = this.getFormatter(n);
    }

    public DecimalFormat getFormatter(int n) {
        String s = "#0.";
        if (n == 0) {
            s = "#";
        } else {
            for (int i = 0; i < n; ++i) {
                s = s + "0";
            }
        }
        return new DecimalFormat(s);
    }

    @Override
    public int getDecimals() {
        return this.decimals;
    }

    @Override
    public double round(double val) {
        return this.roundToDecimals(val, this.df);
    }

    public double roundToDecimals(double val, double f) {
        return Math.floor(val * f) / f;
    }

    @Override
    public long round_Long(long val) {
        return val / this.df * this.df;
    }
}

