/*
 * Decompiled with CFR 0.152.
 */
package sesim;

import java.awt.Frame;
import javax.swing.JDialog;
import org.json.JSONObject;
import sesim.Account;
import sesim.Asset;
import sesim.AutoTrader;
import sesim.AutoTraderGui;
import sesim.Market;
import sesim.Scheduler;
import sesim.Sim;

public abstract class AutoTraderBase
implements AutoTrader,
Scheduler.EventProcessor {
    protected Account account;
    protected Market market = null;
    protected Sim sim;
    protected String name;
    private String strategyName = "default";
    int[] color = null;
    long id = 0L;
    String status = "";
    public static int callctr = 0;

    @Override
    public AutoTraderGui getGui() {
        return null;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public int[] getColor() {
        return this.color;
    }

    @Override
    public long getID() {
        return this.id;
    }

    @Override
    public Account getAccount() {
        return this.account;
    }

    @Override
    public void init(Sim sim, long id, String name, long money, String strat, JSONObject cfg) {
        this.account = new Account((Asset)sim.defaultCurrency, money);
        this.account.maxMargin = this.getMaxMargin();
        this.sim = sim;
        this.market = sim.getDefaultMarket();
        this.account.owner = this;
        this.name = name;
        this.id = id;
        this.strategyName = strat;
    }

    @Override
    public abstract void start();

    protected void setStatus(String format, Object ... arguments) {
        this.status = String.format(format, arguments);
    }

    @Override
    public String getStatus() {
        return this.status;
    }

    @Override
    public JDialog getGuiConsole(Frame parent) {
        return null;
    }

    public String getStrategyName() {
        return this.strategyName;
    }

    public void setStrategyName(String s) {
        this.strategyName = s;
    }

    @Override
    public void reset() {
    }

    @Override
    public void stop() {
    }

    @Override
    public Object initGlobal(Sim sim, Object global, JSONObject cfg) {
        return null;
    }

    @Override
    public boolean getDevelStatus() {
        return true;
    }

    public static long getRandomDelta_Long(long value, long minDeviation, long maxDeviation, long minAbsoluteDeviation) {
        long range;
        long maxDelta;
        ++callctr;
        long product = value * minDeviation;
        long minDelta = product >= 0L ? (product + 50000L) / 1000000L : (product - 50000L) / 1000000L;
        product = value * maxDeviation;
        long l = maxDelta = product >= 0L ? (product + 50000L) / 1000000L : (product - 50000L) / 1000000L;
        if (Math.abs(minDelta) < minAbsoluteDeviation && minDeviation != 0L) {
            long l2 = minDelta = minDeviation < 0L ? -minAbsoluteDeviation : minAbsoluteDeviation;
        }
        if (Math.abs(maxDelta) < minAbsoluteDeviation && maxDeviation != 0L) {
            long l3 = maxDelta = maxDeviation < 0L ? -minAbsoluteDeviation : minAbsoluteDeviation;
        }
        if (minDelta + value < 0L) {
            minDelta = -value;
        }
        if ((range = maxDelta - minDelta + 1L) < 0L) {
            System.out.printf("Name: %s\n", "hello");
        }
        long delta = Sim.random.nextLong(range) + minDelta;
        return delta;
    }

    public static long getRandomPrice_Long(long lastPrice, long minDeviation, long maxDeviation, long minAbsDeviation) {
        long delta = AutoTraderBase.getRandomDelta_Long(lastPrice, minDeviation, maxDeviation, minAbsDeviation);
        long newPrice = lastPrice + delta;
        if (newPrice < 1L) {
            newPrice = 1L;
        }
        return newPrice;
    }

    @Override
    public long getMaxMargin() {
        return 0L;
    }
}

