/*
 * Decompiled with CFR 0.152.
 */
package sesim;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.function.Consumer;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipInputStream;
import sesim.AutoTrader;

public class AutoTraderLoader {
    private ArrayList<String> pathList;
    private ArrayList<Class<AutoTrader>> traderCache;
    private ClassLoader XclassLoader;

    public AutoTraderLoader(ArrayList<String> pathlist) {
        this.setPathList(pathlist);
    }

    public final void setPathList(ArrayList<String> pathlist) {
        this.pathList = pathlist;
        this.traderCache = null;
    }

    public boolean isAutoTrader(Class<?> cls) {
        if (Modifier.isAbstract(cls.getModifiers())) {
            return false;
        }
        do {
            for (Class<?> i : cls.getInterfaces()) {
                String cn = AutoTrader.class.getCanonicalName();
                if (!cn.endsWith(i.getCanonicalName())) continue;
                return true;
            }
        } while ((cls = cls.getSuperclass()) != null);
        return false;
    }

    public AutoTrader MakeInstance(Class<?> cls) {
        AutoTrader ai;
        ClassLoader cur = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.XclassLoader);
        try {
            ai = (AutoTrader)cls.newInstance();
        }
        catch (IllegalAccessException | InstantiationException ex) {
            Logger.getLogger(AutoTraderLoader.class.getName()).log(Level.SEVERE, null, ex);
            ai = null;
        }
        Thread.currentThread().setContextClassLoader(cur);
        return ai;
    }

    Class<AutoTrader> loadAutoTraderClass(String filename, String classname) {
        if (classname == null) {
            return null;
        }
        String clnam = classname.substring(1, classname.length() - 6).replace('/', '.');
        File f = new File(filename);
        URL url = null;
        try {
            url = f.toURL();
        }
        catch (MalformedURLException ex) {
            Logger.getLogger(AutoTraderLoader.class.getName()).log(Level.SEVERE, null, ex);
        }
        URL[] urls = new URL[]{url};
        this.XclassLoader = new URLClassLoader(urls);
        this.XclassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Class<AutoTrader> cls;
            Class<AutoTrader> c = this.XclassLoader.loadClass(clnam);
            if (c == null) {
                // empty if block
            }
            if ((cls = c) == null) {
                // empty if block
            }
            if (this.isAutoTrader(cls)) {
                Class<AutoTrader> claa = cls;
                if (claa == null) {
                    // empty if block
                }
                return claa;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return null;
    }

    public ArrayList<Class<AutoTrader>> getTraders() {
        if (this.traderCache != null) {
            return this.traderCache;
        }
        ArrayList<Class<AutoTrader>> traders = new ArrayList<Class<AutoTrader>>();
        for (String classPathEntry : this.pathList) {
            Consumer<Object> pf = t -> {
                String fn = ((Path)t).toString();
                if (fn.toLowerCase().endsWith(".class")) {
                    String cl = fn.substring(classPathEntry.length());
                    Class<AutoTrader> cls = this.loadAutoTraderClass(fn, cl);
                    if (cls == null) {
                        return;
                    }
                    traders.add(cls);
                }
                if (fn.toLowerCase().endsWith(".jar")) {
                    ZipInputStream is = null;
                    try {
                        JarEntry entry;
                        File jar = new File(fn);
                        is = new JarInputStream(new FileInputStream(jar));
                        while ((entry = ((JarInputStream)is).getNextJarEntry()) != null) {
                            if (!entry.getName().endsWith(".class")) continue;
                            String fn0 = entry.getName();
                            Class<AutoTrader> cls = this.loadAutoTraderClass(fn, "/" + entry.getName());
                            if (cls == null) continue;
                            traders.add(cls);
                        }
                    }
                    catch (IOException ex) {
                        Logger.getLogger(AutoTraderLoader.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    finally {
                        try {
                            is.close();
                        }
                        catch (IOException ex) {
                            Logger.getLogger(AutoTraderLoader.class.getName()).log(Level.SEVERE, null, ex);
                        }
                    }
                }
            };
            try {
                Files.walk(Paths.get(classPathEntry, new String[0]), new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).forEach(pf);
            }
            catch (IOException ex) {
                Logger.getLogger(AutoTraderLoader.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        this.traderCache = traders;
        return traders;
    }

    public ArrayList<String> getDefaultStrategyNames(boolean devel) {
        ArrayList<String> ret2 = new ArrayList<String>();
        ArrayList<Class<AutoTrader>> trclasses = this.getTraders();
        for (int i = 0; i < trclasses.size(); ++i) {
            try {
                AutoTrader ac = this.MakeInstance(trclasses.get(i));
                if (ac.getDevelStatus() && !devel) continue;
                ret2.add(ac.getClass().getCanonicalName());
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return ret2;
    }

    public ArrayList<String> getDefaultStrategyNames() {
        return this.getDefaultStrategyNames(true);
    }

    public AutoTrader getStrategyBase(String name) {
        ArrayList<Class<AutoTrader>> traders = this.getTraders();
        for (int i = 0; i < traders.size(); ++i) {
            try {
                AutoTrader ac;
                if (traders.get(i) == null) {
                    // empty if block
                }
                if (!(ac = this.MakeInstance(traders.get(i))).getClass().getCanonicalName().equals(name)) continue;
                return ac;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public ArrayList getTraders(String dir) {
        File f = new File(dir);
        File[] ff = f.listFiles();
        ArrayList<File> a = new ArrayList<File>();
        a.addAll(Arrays.asList(ff));
        return a;
    }
}

