/*
 * Decompiled with CFR 0.152.
 */
package sesim;

import org.json.JSONArray;
import org.json.JSONObject;

public class Config {
    public static final String DEFAULT_RANDOM_CFG = "{seed: 0,use_seed: false}";

    public static long getRandomSeed(JSONObject cfg) {
        JSONObject rand = Config.getRandomCfg(cfg);
        return rand.optLong("seed", 0L);
    }

    public static JSONObject getStrategies(JSONObject cfg) {
        return cfg.optJSONObject("strategies");
    }

    public static void putStrategies(JSONObject sobj, JSONObject strategies) {
        sobj.put("strategies", strategies);
    }

    public static JSONObject getStrategy(JSONObject cfg, String name) {
        return Config.getStrategies(cfg).optJSONObject(name);
    }

    public static JSONObject getRandomCfg(JSONObject cfg) {
        JSONObject rand = cfg.optJSONObject("random");
        if (rand != null) {
            return rand;
        }
        return new JSONObject(DEFAULT_RANDOM_CFG);
    }

    public static boolean getUseRandomSeed(JSONObject cfg) {
        JSONObject rand = Config.getRandomCfg(cfg);
        return rand.optBoolean("use_seed", false);
    }

    public static JSONArray getTraders(JSONObject cfg) {
        JSONArray traders = cfg.getJSONArray("traders");
        return traders;
    }

    public static final void putTraders(JSONObject cfg, JSONArray traders) {
        cfg.put("traders", traders);
    }

    public static JSONObject getAssets(JSONObject cfg) {
        JSONObject assets = cfg.optJSONObject("assets");
        if (assets == null) {
            assets = new JSONObject();
        }
        return assets;
    }

    public static JSONObject getAsset(JSONObject cfg, String symbol) {
        JSONObject assets = Config.getAssets(cfg);
        return assets.optJSONObject(symbol);
    }

    public static JSONObject getMarkets(JSONObject cfg) {
        JSONObject currencies = cfg.optJSONObject("markets");
        if (currencies == null) {
            currencies = new JSONObject();
        }
        return currencies;
    }

    public static JSONObject getDefaultMarket(JSONObject cfg) {
        return cfg.optJSONObject("default_market");
    }

    public static String getDefaultCurrency(JSONObject cfg) {
        JSONObject dm = Config.getDefaultMarket(cfg);
        if (dm == null) {
            return null;
        }
        return dm.optString("currency");
    }

    public static String getDefaultAsset(JSONObject cfg) {
        JSONObject dm = Config.getDefaultMarket(cfg);
        if (dm == null) {
            return null;
        }
        return dm.optString("asset");
    }

    public static void putDefaultCurrency(JSONObject cfg, String currency) {
        JSONObject dm = Config.getDefaultMarket(cfg);
        if (dm == null) {
            dm = new JSONObject();
        }
        dm.put("currency", currency);
        cfg.put("default_market", dm);
    }

    public static void putDefaultAsset(JSONObject cfg, String asset) {
        JSONObject dm = Config.getDefaultMarket(cfg);
        if (dm == null) {
            dm = new JSONObject();
        }
        dm.put("asset", asset);
        cfg.put("default_market", dm);
    }
}

