/*
 * Decompiled with CFR 0.152.
 */
package sesim;

import java.math.BigInteger;
import java.util.Random;

public class MathBenchmark {
    static double[] val;
    static long[] lval;

    public static void main(String[] args) {
        MathBenchmark.b1();
        MathBenchmark.b2();
    }

    public static void b1() {
        long start = System.currentTimeMillis();
        Random r = new Random();
        int N = 1000000000;
        val = new double[N];
        System.out.printf("Generating random doubles\n", new Object[0]);
        for (int i = 1; i < N; ++i) {
            MathBenchmark.val[i] = r.nextDouble();
        }
        long end = System.currentTimeMillis();
        System.out.println("Random double gen time: " + (end - start) + " ms");
        start = System.currentTimeMillis();
        System.out.printf("Start Doublei calculations\n", new Object[0]);
        double v = 0.0;
        for (int i = 1; i < N; ++i) {
            v = val[i] + v;
            v = Math.floor(v);
            MathBenchmark.val[i] = v *= 100.0;
        }
        end = System.currentTimeMillis();
        System.out.println("Double: " + (end - start) + " ms");
        val = null;
    }

    public static void b2() {
        Random r = new Random();
        int N = 1000000000;
        lval = new long[N];
        long start = System.currentTimeMillis();
        System.out.printf("Generating random longs\n", new Object[0]);
        for (int i = 1; i < N; ++i) {
            MathBenchmark.lval[i] = r.nextLong();
        }
        long end = System.currentTimeMillis();
        System.out.println("Random long gen time: " + (end - start) + " ms");
        start = System.currentTimeMillis();
        System.out.printf("Start long calculations\n", new Object[0]);
        long v = 0L;
        for (int i = 1; i < N; ++i) {
            v = lval[i] + v;
            MathBenchmark.lval[i] = v *= 100L;
        }
        end = System.currentTimeMillis();
        System.out.println("Long: " + (end - start) + " ms");
        lval = null;
    }

    public static void ex() {
        int N = 1000000000;
        long start = System.currentTimeMillis();
        long longResult = 1L;
        for (int i = 1; i <= 1000000000; ++i) {
            longResult += (long)i;
        }
        long end = System.currentTimeMillis();
        System.out.println("long: " + (end - start) + " ms");
        start = System.currentTimeMillis();
        double doubleResult = 1.0;
        for (int i = 1; i <= 1000000000; ++i) {
            doubleResult += (double)i;
        }
        end = System.currentTimeMillis();
        System.out.println("double: " + (end - start) + " ms");
        start = System.currentTimeMillis();
        BigInteger bigResult = BigInteger.ONE;
        for (int i = 1; i <= 1000000000; ++i) {
            bigResult = bigResult.add(BigInteger.valueOf(i));
        }
        end = System.currentTimeMillis();
        System.out.println("BigInteger: " + (end - start) + " ms");
    }

    public static long getRandomPriceDelta_Long(long lastPrice, long minDeviation, long maxDeviation, long minAbsoluteDeviation, long rnd) {
        long maxDelta;
        long product = lastPrice * minDeviation;
        long minDelta = product >= 0L ? (product + 0L) / 10000L : (product - 0L) / 10000L;
        product = lastPrice * maxDeviation;
        long l = maxDelta = product >= 0L ? (product + 0L) / 10000L : (product - 0L) / 10000L;
        if (Math.abs(minDelta) < minAbsoluteDeviation && minDeviation != 0L) {
            long l2 = minDelta = minDeviation < 0L ? -minAbsoluteDeviation : minAbsoluteDeviation;
        }
        if (Math.abs(maxDelta) < minAbsoluteDeviation && maxDeviation != 0L) {
            long l3 = maxDelta = maxDeviation < 0L ? -minAbsoluteDeviation : minAbsoluteDeviation;
        }
        if (minDelta + lastPrice < 0L) {
            minDelta = -lastPrice;
        }
        long range = maxDelta - minDelta + 1L;
        long delta = rnd * (range - 1L) + minDelta;
        return delta;
    }

    public static long getRandomPrice_Long(long lastPrice, long minDeviation, long maxDeviation, long minAbsDeviation, long rnd) {
        long delta = MathBenchmark.getRandomPriceDelta_Long(lastPrice, minDeviation, maxDeviation, minAbsDeviation, rnd);
        long newPrice = lastPrice + delta;
        if (newPrice < 1L) {
            newPrice = 1L;
        }
        return newPrice;
    }
}

