/*
 * Decompiled with CFR 0.152.
 */
package sesim;

import java.util.ArrayList;
import sesim.Market;
import sesim.OHLCDataItem;
import sesim.util.FixedPoint;
import sesim.util.MinMax;

public class OHLCData {
    private long max = 0L;
    private long min = 0L;
    private int barDuration = 60000;
    Market market;
    public ArrayList<OHLCDataItem> data = new ArrayList();
    private long last_price = 0L;

    public OHLCData(Market market, int timeFrameLength) {
        this.market = market;
        this.barDuration = timeFrameLength;
    }

    public OHLCData(Market market, int barDuration, OHLCData base) {
        this(market, barDuration);
        for (OHLCDataItem i : base.data) {
            if (i.volume == 0L) continue;
            this.realTimeAdd(i.time, i.open, i.volume);
            this.realTimeAdd(i.time, i.high, 0L);
            this.realTimeAdd(i.time, i.low, 0L);
            this.realTimeAdd(i.time, i.close, 0L);
        }
    }

    public double getMax() {
        return FixedPoint.toExternal(this.max);
    }

    public double getMin() {
        return FixedPoint.toExternal(this.min);
    }

    public int size() {
        return this.data.size();
    }

    public int getFrameSize() {
        return this.barDuration;
    }

    public MinMax getMinMax(int first, int last) {
        if (first >= this.data.size()) {
            OHLCDataItem di = this.data.get(this.data.size() - 1);
            return new MinMax(this.market.currency.getDf(), di.low, di.high);
        }
        OHLCDataItem di = this.data.get(first);
        MinMax minmax = new MinMax(this.market.currency.getDf(), di.low, di.high);
        for (int i = first + 1; i < last && i < this.data.size(); ++i) {
            di = this.data.get(i);
            if (di.low < minmax.min) {
                minmax.min = di.low;
            }
            if (di.high <= minmax.max) continue;
            minmax.max = di.high;
        }
        return minmax;
    }

    public MinMax getVolMinMax(int first, int last) {
        if (first >= this.data.size()) {
            OHLCDataItem di = this.data.get(this.data.size() - 1);
            return new MinMax(this.market.getAsset().getDf(), di.volume, di.volume);
        }
        OHLCDataItem di = this.data.get(first);
        MinMax minmax = new MinMax(this.market.getAsset().getDf(), di.volume, di.volume);
        for (int i = first + 1; i < last && i < this.data.size(); ++i) {
            di = this.data.get(i);
            if (di.volume < minmax.min) {
                minmax.min = di.volume;
            }
            if (di.volume <= minmax.max) continue;
            minmax.max = di.volume;
        }
        return minmax;
    }

    public OHLCDataItem get(int n) {
        return this.data.get(n);
    }

    private void updateMinMax(long price) {
        if (price > this.max) {
            this.max = price;
        }
        if (price < this.min) {
            this.min = price;
        }
    }

    boolean realTimeAdd(long time, long price, long volume2) {
        if (this.data.isEmpty() && time < (long)this.barDuration) {
            this.data.add(new OHLCDataItem(this.market, 0L, price, volume2));
            this.last_price = price;
            return true;
        }
        long nFrame = (long)this.data.size() * (long)this.barDuration;
        if (time < nFrame) {
            this.last_price = price;
            this.updateMinMax(price);
            OHLCDataItem d = this.data.get(this.data.size() - 1);
            return d.update(price, volume2);
        }
        while (time > nFrame + (long)this.barDuration) {
            this.data.add(new OHLCDataItem(this.market, nFrame, this.last_price, 0L));
            nFrame += (long)this.barDuration;
        }
        this.data.add(new OHLCDataItem(this.market, nFrame, price, volume2));
        this.last_price = price;
        return true;
    }
}

