/*
 * Decompiled with CFR 0.152.
 */
package sesim;

import java.util.concurrent.atomic.AtomicLong;
import sesim.Account;
import sesim.Market;
import sesim.OrderBookEntry;
import sesim.Position;
import sesim.util.FixedPoint;

public class Order
implements OrderBookEntry {
    public static final byte BUY = 0;
    public static final byte SELL = 1;
    public static final byte LIMIT = 2;
    public static final byte STOP = 4;
    public static final byte TAKEPROFIT = 8;
    public static final byte FOK = 16;
    public static final byte LEVERAGED = 32;
    public static final byte SELLLIMIT = 3;
    public static final byte BUYLIMIT = 2;
    public static final byte STOPBUY = 4;
    public static final byte STOPLOSS = 5;
    public static final byte BUYSTOP = 4;
    public static final byte SELLSTOP = 5;
    public static final byte OPEN = 1;
    public static final byte PARTIALLY_EXECUTED = 3;
    public static final byte CLOSED = 4;
    public static final byte CANCELED = 8;
    long volume;
    long limit;
    long stop;
    int leverage;
    byte status;
    byte type;
    long initial_volume;
    public final long id;
    private long created;
    public Account account;
    public Position position;
    long cost;
    Market market;
    private static final AtomicLong ID_GEN = new AtomicLong(0L);

    Order(Market market, Account account, byte type, long volume2, long limit, long stop) {
        this.account = account;
        this.position = account.getPosition(market);
        this.market = market;
        this.id = ID_GEN.getAndIncrement();
        this.type = type;
        this.limit = limit;
        this.initial_volume = this.volume = volume2;
        this.created = market.sim.scheduler.getCurrentTimeMillis();
        this.status = 1;
        this.cost = 0L;
        this.stop = stop;
        this.leverage = 1;
    }

    Order(Market market, Account account, byte type, long volume2, long limit, long stop, int leverage) {
        this.account = account;
        this.position = account.getPosition(market);
        this.market = market;
        this.id = ID_GEN.getAndIncrement();
        this.type = type;
        this.limit = limit;
        this.initial_volume = this.volume = volume2;
        this.created = market.sim.scheduler.getCurrentTimeMillis();
        this.status = 1;
        this.cost = 0L;
        this.stop = stop;
        this.leverage = leverage;
    }

    Order(Order o) {
        this.market = o.market;
        this.account = o.account;
        this.id = o.id;
        this.type = o.type;
        this.limit = o.limit;
        this.volume = o.volume;
        this.initial_volume = o.initial_volume;
        this.created = o.created;
        this.status = o.status;
        this.cost = o.cost;
        this.stop = o.stop;
        this.position = o.position;
    }

    static void resetIdGenerator() {
        ID_GEN.set(0L);
    }

    @Override
    public String getOwnerName() {
        return this.account.owner.getName();
    }

    public Account getAccount() {
        return this.account;
    }

    public long getID() {
        return this.id;
    }

    public byte getType() {
        return this.type;
    }

    public static String getTypeAsString(byte t) {
        String s = 0 != (t & 1) ? "SELL" : "BUY";
        if (0 != (t & 4)) {
            s = s + "|STOP";
        }
        if (0 != (t & 2)) {
            s = s + "|LIMIT";
        }
        return s;
    }

    public String getTypeAsString() {
        return Order.getTypeAsString(this.type);
    }

    public long getExecuted_Long() {
        return this.initial_volume - this.volume;
    }

    public double getExecuted() {
        return FixedPoint.toExternal(this.getExecuted_Long());
    }

    public double getInitialVolume() {
        return FixedPoint.toExternal(this.initial_volume);
    }

    public long getInitialVolume_Long() {
        return this.initial_volume;
    }

    public double getCost() {
        return (double)this.cost / FixedPoint.toExternal(this.cost);
    }

    public static boolean isSell(byte type) {
        return (type & 1) != 0;
    }

    public static boolean isBuy(byte type) {
        return !Order.isSell(type);
    }

    public boolean isSell() {
        return (this.type & 1) != 0;
    }

    public boolean isBuy() {
        return !this.isSell();
    }

    public long getAveragePrice_Long() {
        long e = this.getExecuted_Long();
        if (e <= 0L) {
            return -1L;
        }
        return this.cost / e;
    }

    public double getAveragePrice() {
        return FixedPoint.toExternal(this.getAveragePrice_Long());
    }

    public byte getStatus() {
        return this.status;
    }

    public String getStatusString() {
        switch (this.status) {
            case 1: {
                return "OPEN";
            }
            case 4: {
                return "CLOSED";
            }
            case 3: {
                return "PARTIALLY_EXECUTED";
            }
            case 8: {
                return "CANCELED";
            }
        }
        return "UNKNOW";
    }

    public long getCreated() {
        return this.created;
    }

    public boolean isOpen() {
        return this.status == 1 || this.status == 3;
    }

    public boolean isClosed() {
        return this.status == 4;
    }

    @Override
    public double getVolume() {
        return FixedPoint.toExternal(this.volume);
    }

    @Override
    public double getLimit() {
        return FixedPoint.toExternal(this.limit);
    }

    @Override
    public long getLimit_Long() {
        return this.limit;
    }

    public boolean hasLimit() {
        return (this.type & 2) != 0;
    }

    public boolean hasStop() {
        return (this.type & 4) != 0;
    }

    @Override
    public void addVolume(long volume2) {
    }

    @Override
    public double getStop() {
        return FixedPoint.toExternal(this.stop);
    }

    @Override
    public long getVolume_Long() {
        return this.volume;
    }

    @Override
    public long getStop_Long() {
        return this.stop;
    }

    @Override
    public Market getMarket() {
        return this.market;
    }
}

