/*
 * Decompiled with CFR 0.152.
 */
package sesim;

import java.util.concurrent.atomic.AtomicLong;
import sesim.Account;
import sesim.Market;
import sesim.Order;
import sesim.util.FixedPoint;

public class Position {
    private static final AtomicLong ID_GEN = new AtomicLong(0L);
    final Market market;
    final Account account;
    long shares;
    long entryPrice;
    long margin;
    private long stopPrice;
    long id;
    long netCashFlow = 0L;
    long totalEntryCost = 0L;
    public boolean mops = true;
    Order liquidationOrder = null;

    public Position(Market asset, Account account) {
        this.market = asset;
        this.id = ID_GEN.incrementAndGet();
        this.shares = 0L;
        this.entryPrice = 0L;
        this.margin = 0L;
        this.account = account;
    }

    public Position(Position p) {
        this.market = p.market;
        this.id = p.id;
        this.account = p.account;
        this.margin = p.margin;
        this.netCashFlow = p.netCashFlow;
        this.shares = p.shares;
    }

    public String getName() {
        return this.market.getAsset().getSymbol();
    }

    public long getShares_Long() {
        return this.shares;
    }

    public double getShares() {
        return FixedPoint.toExternal(this.getShares_Long());
    }

    public double getLeverage() {
        double leverage = this.getMargin() == 0.0 ? 1.0 : this.getTotalEntryCost() / this.getMargin();
        return leverage;
    }

    public double getMargin() {
        return FixedPoint.toExternal(this.getMargin_Long());
    }

    public long getMargin_Long() {
        return Math.abs(this.margin);
    }

    public double getEntryPrice() {
        return this.getTotalEntryCost() / (double)this.shares;
    }

    public long getPnL_Long(long currentPrice) {
        if (this.account.maxMargin == 0L) {
            if (this.shares == 0L) {
                return 0L;
            }
            long l = FixedPoint.divide(this.totalEntryCost, this.shares);
        }
        return this.netCashFlow;
    }

    public long getPnL_Long() {
        return this.getPnL_Long(this.market.getLastPrice_Long());
    }

    public double getPnL() {
        return FixedPoint.multiply(this.market.getLastPrice_Long(), this.shares) + this.netCashFlow;
    }

    public double getPnLPercent() {
        if (this.account.maxMargin == 0L) {
            if (this.shares == 0L) {
                return 0.0;
            }
            double te = FixedPoint.toExternal(this.totalEntryCost);
            return 100.0 * (this.getEquityValue() - te) / te;
        }
        double mu = this.getMargin();
        double nc = this.getNetCashFlow();
        double te = FixedPoint.toExternal(this.totalEntryCost);
        System.out.printf("MU: %f, NC: %f\n", mu, nc);
        double ev = this.getEquityValue();
        if (mu == 0.0) {
            return 0.0;
        }
        return 100.0 * (mu + ev - mu) / mu;
    }

    public long getMarketValue_Long() {
        return FixedPoint.multiply(this.market.getLastPrice_Long(), this.shares);
    }

    public double getMarketValue() {
        return FixedPoint.toExternal(this.getMarketValue_Long());
    }

    public long getEquityValue_Long(long price) {
        if (this.account.maxMargin == 0L) {
            return FixedPoint.multiply(this.shares, price);
        }
        return this.netCashFlow + FixedPoint.multiply(this.shares, price);
    }

    public long getEquityValue_Long() {
        return this.getEquityValue_Long(this.market.getLastPrice_Long());
    }

    public double getEquityValue() {
        return FixedPoint.toExternal(this.getEquityValue_Long());
    }

    public double getTotalEntryCost() {
        return FixedPoint.toExternal(this.totalEntryCost);
    }

    public double getNetCashFlow() {
        return FixedPoint.toExternal(this.netCashFlow);
    }

    boolean isShort() {
        return this.shares < 0L;
    }

    void addShares(double volume2, double price, int leverage) {
        this.addShares_Long(this.market.asset.round_Long(FixedPoint.toInternal(volume2)), this.market.currency.round_Long(FixedPoint.toInternal(price)), leverage);
    }

    void addShares_Long(long volume2, long price, int leverage) {
        if (this.account.maxMargin == 0L) {
            long val = FixedPoint.floorMultiply(volume2, price);
            this.account.cash -= val;
            if (volume2 > 0L) {
                this.totalEntryCost += val;
                this.shares += volume2;
            } else {
                long pps = FixedPoint.divide(this.totalEntryCost, this.shares);
                this.shares += volume2;
                this.totalEntryCost = FixedPoint.multiply(this.shares, pps);
            }
            return;
        }
        if (Long.signum(this.shares) == Long.signum(volume2) || this.shares == 0L) {
            long val = FixedPoint.floorMultiply(volume2, price);
            this.netCashFlow -= val;
            this.totalEntryCost += val;
            long marginRequired = Math.abs(val / (long)leverage);
            this.shares += volume2;
            this.margin += marginRequired;
        } else {
            long nextShares = this.shares + volume2;
            if (Long.signum(this.shares) != Long.signum(nextShares)) {
                long marginRequired;
                this.netCashFlow += FixedPoint.floorMultiply(this.shares, price);
                this.account.cash += this.netCashFlow;
                this.shares = nextShares;
                long val = FixedPoint.floorMultiply(this.shares, price);
                this.netCashFlow = -val;
                this.totalEntryCost = val;
                this.margin = marginRequired = Math.abs(val) / (long)leverage;
            } else {
                long val = FixedPoint.floorMultiply(volume2, price);
                this.netCashFlow -= val;
                this.totalEntryCost += val;
                long reductionFactor = Math.abs(volume2) * 10000L / Math.abs(this.shares);
                long marginReduction = this.margin * reductionFactor / 10000L;
                this.shares = nextShares;
                this.margin -= marginReduction;
            }
        }
        if (this.margin != 0L) {
            this.account.calculateLiquidationStops(price);
        } else {
            this.market.removeLiquidationStop(this);
        }
    }

    private void updateLiquidation(long price) {
        if (this.margin != 0L || this.netCashFlow != 0L) {
            this.account.calculateLiquidationStops(price);
        } else {
            this.market.removeLiquidationStop(this);
        }
    }

    public double getStopPrice() {
        return FixedPoint.toExternal(this.stopPrice);
    }

    public long getStopPrice_Long() {
        return this.stopPrice;
    }

    void setStopPrice(long newStopPrice) {
        this.market.removeLiquidationStop(this);
        this.stopPrice = newStopPrice;
        this.market.setLiquidationStop(this);
    }

    long getSharesToTrade(long volume2) {
        if (Long.signum(this.shares) == Long.signum(volume2) || this.shares == 0L) {
            return volume2;
        }
        return this.shares + volume2;
    }

    public long getRequiredCashForOrder_Long(long volume2, long price, long leverage) {
        if (Long.signum(this.shares) == Long.signum(volume2) || this.shares == 0L) {
            long val = FixedPoint.multiply(volume2, price);
            long marginRequired = Math.abs(val / leverage);
            return marginRequired;
        }
        long nextShares = this.shares + volume2;
        if (Long.signum(this.shares) != Long.signum(nextShares) && nextShares != 0L) {
            long val = FixedPoint.multiply(nextShares, price);
            long marginRequired = Math.abs(val) / leverage;
            return marginRequired;
        }
        return 0L;
    }

    public long getTradableShares_Long(long volume2, long price, long leverage) {
        if (this.account.maxMargin == 0L) {
            if (volume2 < 0L) {
                if (this.shares + volume2 <= 0L) {
                    return this.shares;
                }
                return Math.abs(volume2);
            }
            long vmax = FixedPoint.floorDivide(this.account.cash, price);
            if (vmax < volume2) {
                return this.market.getAsset().round_Long(vmax);
            }
            return volume2;
        }
        if (Long.signum(this.shares) == Long.signum(volume2) || this.shares == 0L) {
            long freeMargin = this.account.getFreeMargin_Long();
            if (freeMargin <= 0L) {
                return 0L;
            }
            long val = FixedPoint.floorMultiply(volume2, price);
            long marginRequired = Math.abs(val / leverage);
            if (freeMargin < marginRequired) {
                return this.market.getAsset().round_Long(FixedPoint.floorDivide(freeMargin * leverage, price));
            }
        } else {
            long val;
            long marginRequired;
            long c;
            long nextShares = this.shares + volume2;
            if (Long.signum(this.shares) != Long.signum(nextShares) && nextShares != 0L && (c = this.netCashFlow - FixedPoint.multiply(-this.shares, price) + this.margin + this.account.cash) < (marginRequired = Math.abs(val = FixedPoint.multiply(nextShares, price)) / leverage)) {
                return Math.abs(this.shares) + FixedPoint.divide(c * leverage, price);
            }
        }
        return Math.abs(volume2);
    }

    void updateLiquidationOrder(int l) {
        if (this.margin == 0L) {
            if (this.liquidationOrder == null) {
                return;
            }
            this.market.cancelOrder(this.account, this.liquidationOrder.id);
            this.liquidationOrder = null;
            return;
        }
        int leverage = (int)(this.totalEntryCost / this.margin);
        if (this.liquidationOrder != null) {
            this.market.cancelOrder(this.account, this.liquidationOrder.id);
        }
    }
}

