/*
 * Decompiled with CFR 0.152.
 */
package sesim;

import sesim.Market;
import sesim.util.FixedPoint;

public class Quote
implements Comparable {
    Market market;
    long bid;
    long bid_volume;
    long ask;
    long ask_volume;
    long price;
    long volume;
    long time;

    public void print() {
        System.out.print("Quote (" + this.time + ") :" + this.price + " / " + this.volume + "\n");
    }

    public Quote(Market market) {
        this.market = market;
    }

    public int compareTo(Object o) {
        Quote q = (Quote)o;
        int ret2 = (int)(this.time - q.time);
        if (ret2 != 0) {
            return ret2;
        }
        return 0;
    }

    public double getPrice() {
        return FixedPoint.toExternal(this.price);
    }

    public double getBid() {
        return FixedPoint.toExternal(this.bid);
    }

    public double getAsk() {
        return FixedPoint.toExternal(this.ask);
    }

    public double getVolume() {
        return FixedPoint.toExternal(this.volume);
    }

    public long getPrice_Long() {
        return this.price;
    }

    public long getVolume_Long() {
        return this.volume;
    }
}

