/*
 * Decompiled with CFR 0.152.
 */
package sesim;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.SplittableRandom;
import java.util.TreeMap;
import java.util.function.Consumer;
import org.json.JSONArray;
import org.json.JSONObject;
import sesim.Asset;
import sesim.AssetBase;
import sesim.AutoTrader;
import sesim.AutoTraderBase;
import sesim.AutoTraderLoader;
import sesim.Config;
import sesim.Logger;
import sesim.Market;
import sesim.Order;
import sesim.Scheduler;
import sesim.util.FixedPoint;

public class Sim {
    private HashMap<String, Asset> assets = new HashMap();
    private HashMap<Asset, HashMap<Asset, Market>> currencies = new HashMap();
    private Market defaultMarket;
    public AutoTraderLoader tloader;
    Scheduler scheduler;
    Asset defaultAsset = new AssetBase("RBTN", "VEB Robotron", 0);
    AssetBase defaultCurrency = new AssetBase("TLR", "Taler", 2);
    public ArrayList<AutoTrader> traders = null;
    public static String DEFAULT_EXCHANGE_CFG = "{  money_decimals: 2,  shares_decimals: 0}";
    public static SplittableRandom random = new SplittableRandom(12L);
    TreeMap<Long, BreakPoint> breakPoints = new TreeMap();

    public static int randNextInt() {
        return random.nextInt();
    }

    public static int randNextInt(int bounds) {
        return random.nextInt(bounds);
    }

    public static double randNextDouble() {
        return random.nextDouble();
    }

    public Market getDefaultMarket() {
        return this.defaultMarket;
    }

    public void setAcceleration(double a) {
        this.scheduler.setAcceleration(a);
    }

    public void setPause(boolean p) {
        this.scheduler.setPause(p);
    }

    public boolean getPause() {
        return this.scheduler.getPause();
    }

    public long getCurrentTimeMillis() {
        return this.scheduler.getCurrentTimeMillis();
    }

    public void startScheduler() {
        this.scheduler.start();
        for (Long time : this.breakPoints.keySet()) {
            BreakPoint bp = this.breakPoints.get(time);
            this.scheduler.addEvent(time, bp);
        }
    }

    public void stop() {
        Logger.info("Sim stopped", new Object[0]);
        this.scheduler.terminate();
    }

    public void addEvent(long t, Scheduler.Event e) {
        this.scheduler.addEvent(t, e);
    }

    public boolean delEvent(long t, Scheduler.Event e) {
        return this.scheduler.delEvent(t, e);
    }

    public Sim() {
        this.scheduler = new Scheduler();
        this.defaultMarket = new Market(this, this.defaultCurrency, this.defaultAsset, new JSONObject());
        this.initAutoTraderLoader();
        this.reset();
    }

    public final void reset() {
        if (this.traders != null) {
            for (AutoTrader t : this.traders) {
                t.stop();
            }
        }
        this.traders = new ArrayList();
        this.scheduler = new Scheduler();
        this.defaultMarket.reset();
    }

    private AutoTrader createTraderNew(Market se, long id, String name, long money, String strat, JSONObject cfg) {
        String base = cfg.getString("base");
        AutoTrader ac = this.tloader.getStrategyBase(base);
        if (ac == null) {
            return null;
        }
        ac.setConfig(cfg);
        ac.init(this, id, name, money, strat, cfg);
        return ac;
    }

    void resetAutoTraders() {
        ArrayList<String> names = this.tloader.getDefaultStrategyNames();
        for (String name : names) {
            AutoTrader ac = this.tloader.getStrategyBase(name);
            ac.reset();
        }
    }

    private void initAutoTraderLoader() {
        ArrayList<String> pathlist = new ArrayList<String>();
        String dp = new File(Sim.class.getProtectionDomain().getCodeSource().getLocation().getPath()).toString();
        pathlist.add(dp);
        this.tloader = new AutoTraderLoader(pathlist);
    }

    public static final void putExchangeCfg(JSONObject sobj, JSONObject exchange) {
        sobj.put("exchange", exchange);
    }

    public static double calculateInitialPrice(JSONArray tlist) {
        double cash = 0.0;
        double shares = 0.0;
        for (int i = 0; i < tlist.length(); ++i) {
            JSONObject trader = tlist.getJSONObject(i);
            if (!trader.optBoolean("Enabled", false) || trader.optBoolean("ExcludeInitial", false)) continue;
            long count2 = trader.optLong("Count", 0L);
            cash += trader.optDouble("Cash", 0.0) * (double)count2;
            shares += trader.optDouble("Shares", 0.0) * (double)count2;
        }
        return shares == 0.0 ? 100.0 : cash / shares;
    }

    private void startRandomGenerator(JSONObject cfg) {
        long randomSeed = Config.getRandomSeed(cfg);
        boolean useSeed = Config.getUseRandomSeed(cfg);
        if (useSeed) {
            random = new SplittableRandom(randomSeed);
        } else {
            random = new SplittableRandom();
            randomSeed = random.nextLong(Long.MAX_VALUE);
            random = new SplittableRandom(randomSeed);
        }
        Logger.info("Random seed is %d", randomSeed);
    }

    private void initAssets(JSONObject cfg) {
        this.assets = new HashMap();
        JSONObject jassets = Config.getAssets(cfg);
        for (String symbol : jassets.keySet()) {
            JSONObject jasset = jassets.optJSONObject(symbol);
            AssetBase a = new AssetBase(symbol, jasset.optString("name", symbol), jasset.optInt("decimals", 0));
            this.assets.put(symbol, a);
        }
    }

    private void initMarkets(JSONObject cfg) {
        JSONObject jcurrencies = Config.getMarkets(cfg);
        String defaultCurrencySymbol = Config.getDefaultCurrency(cfg);
        String defaultAssetSymbol = Config.getDefaultAsset(cfg);
        for (String currencySymbol : jcurrencies.keySet()) {
            JSONObject jmarkets = jcurrencies.optJSONObject(currencySymbol);
            HashMap<Asset, Market> markets = new HashMap<Asset, Market>();
            Asset currency = this.assets.get(currencySymbol);
            for (String assetSymbol : jmarkets.keySet()) {
                Asset asset = this.assets.get(assetSymbol);
                Market market = new Market(this, currency, asset, jmarkets.optJSONObject(assetSymbol));
                markets.put(asset, market);
                if (assetSymbol.equals(defaultAssetSymbol) && currencySymbol.equals(defaultCurrencySymbol)) {
                    this.defaultMarket = market;
                }
                System.out.printf("Pair: %s/%s\n", currencySymbol, assetSymbol);
            }
            this.currencies.put(currency, markets);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startTraders(JSONObject cfg) {
        ArrayList<AutoTrader> arrayList = this.traders;
        synchronized (arrayList) {
            this.startTraders0(cfg);
        }
    }

    public void startTraders0(JSONObject cfg) {
        int i;
        Logger.info("Sim started", new Object[0]);
        Order.resetIdGenerator();
        this.startRandomGenerator(cfg);
        this.initAssets(cfg);
        this.initMarkets(cfg);
        this.resetAutoTraders();
        JSONArray tlist = Config.getTraders(cfg);
        boolean autoInitialPrice = this.defaultMarket.autoInitialPrice;
        double initialPrice = autoInitialPrice ? Sim.calculateInitialPrice(tlist) : this.defaultMarket.initalPrice;
        Logger.info("Initial prices is: %f", initialPrice);
        this.defaultMarket.initLastQuote(initialPrice);
        Float moneyTotal = Float.valueOf(0.0f);
        Float sharesTotal = Float.valueOf(0.0f);
        long id = 0L;
        block0: for (i = 0; i < tlist.length(); ++i) {
            JSONObject t = tlist.getJSONObject(i);
            String strategy_name = t.optString("Strategy", null);
            if (strategy_name == null) continue;
            JSONObject strategyCfg = Config.getStrategy(cfg, strategy_name);
            Integer count2 = t.getInt("Count");
            Float shares = Float.valueOf((float)t.optDouble("Shares", 0.0));
            Float money = Float.valueOf((float)t.optDouble("Cash", 0.0));
            Boolean enabled = t.optBoolean("Enabled", false);
            if (!enabled.booleanValue()) continue;
            if (strategyCfg == null) {
                Logger.error("Strategy '%s' does't exists, will not start '%s'", strategy_name, t.getString("Name"));
                continue;
            }
            Object global = null;
            for (int i1 = 0; i1 < count2; ++i1) {
                JSONArray color;
                String base = strategyCfg.getString("base");
                AutoTrader trader = this.tloader.getStrategyBase(base);
                if (trader == null) continue;
                global = trader.initGlobal(this, global, strategyCfg);
                trader.setConfig(strategyCfg);
                long iniPrice_Long = this.defaultMarket.currency.round_Long(FixedPoint.toInternal(initialPrice));
                long shares_Long = this.defaultMarket.asset.round_Long(FixedPoint.toInternal(shares.floatValue()));
                long money_Long = this.defaultMarket.currency.round_Long(FixedPoint.toInternal(money.floatValue()));
                trader.init(this, id, t.getString("Name") + "-" + i1, money_Long + FixedPoint.floorMultiply(iniPrice_Long, shares_Long), strategy_name, strategyCfg);
                trader.getAccount().getPosition(this.defaultMarket).addShares(shares.floatValue(), initialPrice, 1);
                trader.getAccount().makeSnapShot();
                if (trader == null) {
                    base = strategyCfg.getString("base");
                    Logger.error("Could not load base '%s', not starting %s", base, t.getString("Name"));
                    continue block0;
                }
                ((AutoTraderBase)trader).setStrategyName(strategy_name);
                this.traders.add(trader);
                ((AutoTraderBase)trader).id = this.traders.size() - 1;
                Boolean exclude = t.optBoolean("ExcludeInitial", false);
                if (!exclude.booleanValue()) {
                    moneyTotal = Float.valueOf(moneyTotal.floatValue() + money.floatValue());
                    sharesTotal = Float.valueOf(sharesTotal.floatValue() + shares.floatValue());
                }
                if ((color = t.optJSONArray("Color")) != null && color.length() == 3) {
                    int[] c = new int[]{color.getInt(0), color.getInt(1), color.getInt(2)};
                    ((AutoTraderBase)trader).color = c;
                }
                if (this.traders.size() % 10000 != 0) continue;
                Logger.info("Traders %d", this.traders.size());
            }
        }
        for (i = 0; i < this.traders.size(); ++i) {
            this.traders.get(i).start();
            if (i % 10000 != 0) continue;
            Logger.info("Traders start %d", i);
        }
    }

    public Scheduler getScheduler() {
        return this.scheduler;
    }

    public void addBreakPoint(long time, Consumer<Long> callback) {
        BreakPoint p = new BreakPoint(time, callback);
        this.breakPoints.put(time, p);
        this.scheduler.addEvent(time, p);
    }

    public void removeBreakPoint(long time) {
        Scheduler.Event e = this.breakPoints.remove(time);
        this.scheduler.delEvent(time, e);
    }

    public TreeMap<Long, BreakPoint> getBreakPoints() {
        return this.breakPoints;
    }

    public class BreakPoint
    extends Scheduler.Event
    implements Scheduler.EventProcessor {
        private final Consumer<Long> callback;
        private final long time;

        BreakPoint(long time, Consumer<Long> callback) {
            this.eventProcessor = this;
            this.time = time;
            this.callback = callback;
        }

        @Override
        public void processEvent(long time, Scheduler.Event e) {
            this.callback.accept(time);
        }
    }

    public static final class CfgKeys {
        public static final String SESIMVERSION = "version";
        public static final String STRATEGIES = "strategies";
        public static final String TRADERS = "traders";
        public static final String EXCHANGE = "exchange";
        public static final String RANDOM = "random";
    }
}

