/*
 * Decompiled with CFR 0.152.
 */
package sesim.util;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;

public class LinkedHashSet<T>
implements Iterable<T> {
    private final Map<T, Node<T>> map = new HashMap<T, Node<T>>();
    private final Node<T> dummy = new Node<Object>(null);
    private Node<T> tail = this.dummy;

    public void add(T value) {
        if (this.map.containsKey(value)) {
            return;
        }
        Node<T> node = new Node<T>(value);
        this.map.put(value, node);
        this.tail.next = node;
        node.prev = this.tail;
        this.tail = node;
    }

    public boolean remove(T value) {
        Node<T> node = this.map.remove(value);
        if (node == null) {
            return false;
        }
        if (node.prev != null) {
            node.prev.next = node.next;
        }
        if (node.next != null) {
            node.next.prev = node.prev;
        } else {
            this.tail = node.prev;
        }
        node.prev = null;
        node.next = null;
        node.value = null;
        return true;
    }

    public int size() {
        return this.map.size();
    }

    @Override
    public Iterator<T> iterator() {
        return new Iterator<T>(){
            Node<T> current;
            {
                this.current = LinkedHashSet.this.dummy;
            }

            @Override
            public boolean hasNext() {
                return this.current.next != null;
            }

            @Override
            public T next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                this.current = this.current.next;
                return this.current.value;
            }
        };
    }

    public void printList() {
        Node n = this.dummy.next;
        while (n != null) {
            System.out.print(n.value + " ");
            n = n.next;
        }
        System.out.println();
    }

    private static class Node<T> {
        T value;
        Node<T> prev;
        Node<T> next;

        Node(T v) {
            this.value = v;
        }
    }
}

