/*
 * Decompiled with CFR 0.152.
 */
package sesim.util;

import java.util.function.Function;

public class SeSimMath {
    public static long toLong(double v) {
        if (v >= 0.0) {
            return (long)(v + 0.5);
        }
        return (long)(v - 0.5);
    }

    public static long toFixedLong(double v, double f) {
        return SeSimMath.toLong(v * f);
    }

    public static double calculateEquilibriumPoint(double leftBound) {
        double result;
        if (leftBound >= 0.0) {
            throw new IllegalArgumentException("Linke Grenze muss negativ sein");
        }
        Function<Double, Double> equation = x -> {
            double term1 = (1.0 + x) * SeSimMath.log(1.0 + x) - (1.0 + x);
            double term2 = (1.0 + leftBound) * SeSimMath.log(1.0 + leftBound) - (1.0 + leftBound);
            return term1 - term2;
        };
        double lower = -leftBound;
        double upper = -leftBound + 0.01;
        while (equation.apply(lower) * equation.apply(upper) > 0.0) {
            upper += 0.001;
        }
        double PRECISION = 1.0E-8;
        double mid = 0.0;
        for (int i = 0; i < 100 && !(SeSimMath.abs(result = equation.apply(mid = (lower + upper) / 2.0).doubleValue()) < 1.0E-8); ++i) {
            if (result * equation.apply(lower) < 0.0) {
                upper = mid;
                continue;
            }
            lower = mid;
        }
        return mid;
    }

    public static double calculateEquilibriumPointApprox(double leftBound) {
        if (leftBound >= 0.0) {
            throw new IllegalArgumentException("Linke Grenze muss negativ sein");
        }
        double a = SeSimMath.abs(leftBound);
        return a + a * a / 2.0;
    }

    public static void main(String[] args) {
        double[] testValues = new double[]{-0.02, -0.03, -0.05, -0.1};
        System.out.println("Linke Grenze | Exakte rechte Grenze | N\u00e4herung");
        System.out.println("-------------|----------------------|----------");
        for (double left : testValues) {
            double exact = SeSimMath.calculateEquilibriumPoint(left);
            double approx = SeSimMath.calculateEquilibriumPointApprox(left);
            System.out.printf("%.2f%%       | %.4f (%.4f%%)    | %.4f (%.4f%%)\n", left * 100.0, exact, exact * 100.0, approx, approx * 100.0);
        }
    }

    private static double abs(double leftBound) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    private static double log(double d) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

