/*
 * Decompiled with CFR 0.152.
 */
package traders.ManualTrader;

import java.awt.Font;
import java.text.DecimalFormat;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import sesim.Account;
import sesim.Market;
import sesim.Quote;

public class AccountBalance
extends JPanel
implements Market.QuoteReceiver {
    Account account;
    ExecutorService executor = Executors.newSingleThreadExecutor();
    boolean busy;
    boolean update;
    Quote quote;
    private JLabel cashLabel;
    private JLabel cashLabelText;
    private JLabel equity;
    private JLabel freeMargin;
    private JLabel jLabel1;
    private JLabel marginUsed;
    private JLabel sharesLabelText;
    private JLabel volAvailLabel;

    public AccountBalance(Account a) {
        this.initComponents();
        this.account = a;
        if (a == null) {
            return;
        }
    }

    public AccountBalance() {
        this((Account)null);
    }

    public void updateBalance(Account account) {
        DecimalFormat mf = account.getCurrency().getFormatter();
        String s = mf.format(account.getMoney());
        this.cashLabel.setText(mf.format(account.getMoney()));
        this.marginUsed.setText(mf.format(account.getMarginUsed()));
        this.freeMargin.setText(mf.format(account.getFreeMargin()));
        this.equity.setText(mf.format(account.getEquity()));
    }

    @Override
    public void UpdateQuote(Quote q) {
        if (q == null) {
            return;
        }
        if (this.busy) {
            this.quote = q;
            this.update = true;
            return;
        }
        this.busy = true;
        this.update = true;
        this.executor.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    while (AccountBalance.this.update) {
                        Quote q = AccountBalance.this.quote;
                        AccountBalance.this.update = false;
                        if (q == null) {
                            return;
                        }
                        SwingUtilities.invokeLater(() -> AccountBalance.this.updateBalance(AccountBalance.this.account));
                        try {
                            Thread.sleep(500L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                }
                finally {
                    AccountBalance.this.busy = false;
                }
            }
        });
    }

    private void initComponents() {
        this.cashLabelText = new JLabel();
        this.sharesLabelText = new JLabel();
        this.freeMargin = new JLabel();
        this.volAvailLabel = new JLabel();
        this.jLabel1 = new JLabel();
        this.marginUsed = new JLabel();
        this.cashLabel = new JLabel();
        this.equity = new JLabel();
        this.cashLabelText.setText("Cash:");
        this.sharesLabelText.setText("Margin used");
        this.freeMargin.setText("0.0");
        this.volAvailLabel.setText("Free Margin");
        this.jLabel1.setFont(new Font("Noto Sans", 1, 12));
        this.jLabel1.setText("Total Equity");
        this.marginUsed.setText("0");
        this.cashLabel.setText("0.0000");
        this.equity.setFont(new Font("Noto Sans", 1, 12));
        this.equity.setHorizontalAlignment(2);
        this.equity.setText("0");
        GroupLayout layout2 = new GroupLayout(this);
        this.setLayout(layout2);
        layout2.setHorizontalGroup(layout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout2.createSequentialGroup().addGroup(layout2.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jLabel1, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.volAvailLabel, GroupLayout.Alignment.LEADING, -2, 77, -2).addComponent(this.sharesLabelText, GroupLayout.Alignment.LEADING, -1, 118, Short.MAX_VALUE).addComponent(this.cashLabelText, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout2.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.cashLabel, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.marginUsed, GroupLayout.Alignment.LEADING, -1, 162, Short.MAX_VALUE).addComponent(this.freeMargin, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.equity, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE)).addContainerGap(-1, Short.MAX_VALUE)));
        layout2.setVerticalGroup(layout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout2.createSequentialGroup().addGroup(layout2.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cashLabelText).addComponent(this.cashLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout2.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.freeMargin).addComponent(this.volAvailLabel, -2, 17, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout2.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.marginUsed).addComponent(this.sharesLabelText)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout2.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.equity).addComponent(this.jLabel1, -2, 17, -2)).addContainerGap(-1, Short.MAX_VALUE)));
    }
}

