/*
 * Decompiled with CFR 0.152.
 */
package traders.ManualTrader;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.DefaultFormatter;
import sesim.Account;
import sesim.Market;
import sesim.Order;
import sesim.Quote;

public class EditOrderPanel
extends JPanel {
    Market market;
    Account account;
    byte type;
    private JButton jButton1;
    private JCheckBox jCheckBox3;
    private JLabel jLabel1;
    private JLabel jLabel4;
    private JComboBox<String> leverageComboBox;
    private JCheckBox limitCheckBox;
    JSpinner limitSpinner;
    private JButton loadValuesButton;
    private JLabel priceLabel;
    private JButton setVolButton;
    private JCheckBox stopCheckBox;
    JSpinner stopSpinner;
    private JComboBox<String> typeComboBox;
    JSpinner volumeSpinner;

    public EditOrderPanel() {
        this.initComponents();
        JSpinner spinner = this.limitSpinner;
        JComponent comp = spinner.getEditor();
        JFormattedTextField field = (JFormattedTextField)comp.getComponent(0);
        DefaultFormatter formatter = (DefaultFormatter)field.getFormatter();
        formatter.setCommitsOnValidEdit(true);
        this.limitSpinner.setEnabled(false);
        spinner = this.volumeSpinner;
        comp = spinner.getEditor();
        field = (JFormattedTextField)comp.getComponent(0);
        formatter = (DefaultFormatter)field.getFormatter();
        formatter.setCommitsOnValidEdit(true);
        spinner = this.stopSpinner;
        comp = spinner.getEditor();
        field = (JFormattedTextField)comp.getComponent(0);
        formatter = (DefaultFormatter)field.getFormatter();
        formatter.setCommitsOnValidEdit(true);
        this.stopSpinner.setEnabled(false);
    }

    public EditOrderPanel(Market e, Account a, byte type) {
        this();
        this.market = e;
        this.account = a;
        this.type = type;
        if (this.account.getMaxMargin() == 0L) {
            this.leverageComboBox.setEnabled(false);
        }
    }

    public EditOrderPanel(Market e, Account a, Order o) {
        this();
        this.account = a;
        this.market = e;
        this.type = o.getType();
        this.volumeSpinner.setValue(o.getVolume());
        this.limitSpinner.setValue(o.getLimit());
        this.limitCheckBox.setSelected(o.hasLimit());
        this.limitSpinner.setEnabled(o.hasLimit());
        this.stopCheckBox.setSelected(o.hasStop());
        this.stopSpinner.setValue(o.getStop());
        this.stopSpinner.setEnabled(o.hasStop());
        this.leverageComboBox.setEnabled(false);
    }

    private void setPrice() {
    }

    public double getPrice() {
        double price = this.getVolume() * this.getLimit();
        price = this.market.getCurrency().round(price);
        return price;
    }

    public double getStop() {
        return (Double)this.stopSpinner.getValue();
    }

    public double getVolume() {
        return (Double)this.volumeSpinner.getValue();
    }

    public double getLimit() {
        return (Double)this.limitSpinner.getValue();
    }

    public int getLeverage() {
        return Integer.parseInt((String)this.leverageComboBox.getSelectedItem());
    }

    public byte getOrderType() {
        byte t = (byte)(this.type & 1);
        if (this.limitCheckBox.isSelected()) {
            t = (byte)(t | 2);
        }
        if (this.stopCheckBox.isSelected()) {
            t = (byte)(t | 4);
        }
        return t;
    }

    void addChangeListeners(final ChangeListener c) {
        this.volumeSpinner.addChangeListener(c);
        this.limitSpinner.addChangeListener(c);
        this.limitCheckBox.addChangeListener(c);
        this.leverageComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                c.stateChanged(new ChangeEvent(EditOrderPanel.this.leverageComboBox));
            }
        });
    }

    private void initComponents() {
        this.typeComboBox = new JComboBox();
        this.jCheckBox3 = new JCheckBox();
        this.limitSpinner = new JSpinner();
        this.jLabel4 = new JLabel();
        this.volumeSpinner = new JSpinner();
        this.loadValuesButton = new JButton();
        this.priceLabel = new JLabel();
        this.setVolButton = new JButton();
        this.stopCheckBox = new JCheckBox();
        this.limitCheckBox = new JCheckBox();
        this.stopSpinner = new JSpinner();
        this.jButton1 = new JButton();
        this.leverageComboBox = new JComboBox();
        this.jLabel1 = new JLabel();
        this.typeComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Buy Limit", "Sell Limit", "Sell", "Buy"}));
        this.jCheckBox3.setText("fill or kill");
        this.limitSpinner.setModel(new SpinnerNumberModel((Number)0.0, Double.valueOf(0.0), null, (Number)1.0));
        this.limitSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                EditOrderPanel.this.limitSpinnerStateChanged(evt);
            }
        });
        this.jLabel4.setText("Volume:");
        this.volumeSpinner.setModel(new SpinnerNumberModel((Number)0.0, Double.valueOf(0.0), null, (Number)1.0));
        this.volumeSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                EditOrderPanel.this.volumeSpinnerStateChanged(evt);
            }
        });
        this.loadValuesButton.setText("Set limit");
        this.loadValuesButton.setToolTipText("Set limit to the curent \ntraded price.");
        this.loadValuesButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EditOrderPanel.this.loadValuesButtonActionPerformed(evt);
            }
        });
        this.priceLabel.setHorizontalAlignment(0);
        this.priceLabel.setText("0.00");
        this.setVolButton.setText("Set vol");
        this.setVolButton.setToolTipText("Set the volume to the maximum \namount  you can buy with your \ncurrent cash balance.");
        this.setVolButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EditOrderPanel.this.setVolButtonActionPerformed(evt);
            }
        });
        this.stopCheckBox.setText("Stop");
        this.stopCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EditOrderPanel.this.stopCheckBoxActionPerformed(evt);
            }
        });
        this.limitCheckBox.setText("Lmit");
        this.limitCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EditOrderPanel.this.limitCheckBoxActionPerformed(evt);
            }
        });
        this.stopSpinner.setModel(new SpinnerNumberModel((Number)0.0, Double.valueOf(0.0), null, (Number)1.0));
        this.stopSpinner.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                EditOrderPanel.this.stopSpinnerStateChanged(evt);
            }
        });
        this.jButton1.setText("Set stop");
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EditOrderPanel.this.jButton1ActionPerformed(evt);
            }
        });
        this.leverageComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"1", "5", "10", "100"}));
        this.leverageComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EditOrderPanel.this.leverageComboBoxActionPerformed(evt);
            }
        });
        this.jLabel1.setText("Leverage:");
        GroupLayout layout2 = new GroupLayout(this);
        this.setLayout(layout2);
        layout2.setHorizontalGroup(layout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout2.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addGroup(layout2.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(layout2.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.leverageComboBox, -2, -1, -2)).addComponent(this.priceLabel, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout2.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.setVolButton, -1, -1, Short.MAX_VALUE).addComponent(this.loadValuesButton, -1, -1, Short.MAX_VALUE).addComponent(this.jButton1, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout2.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(layout2.createSequentialGroup().addComponent(this.limitCheckBox, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.limitSpinner, -2, 78, -2)).addGroup(layout2.createSequentialGroup().addGap(3, 3, 3).addComponent(this.jLabel4, -2, 58, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.volumeSpinner)).addGroup(layout2.createSequentialGroup().addComponent(this.stopCheckBox).addGap(18, 18, 18).addComponent(this.stopSpinner, -2, 78, -2))).addContainerGap()));
        layout2.setVerticalGroup(layout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout2.createSequentialGroup().addContainerGap().addGroup(layout2.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.volumeSpinner, -2, -1, -2).addComponent(this.jLabel4).addComponent(this.setVolButton).addComponent(this.priceLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout2.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.limitSpinner, -2, -1, -2).addGroup(layout2.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.limitCheckBox).addComponent(this.loadValuesButton).addComponent(this.leverageComboBox, -2, -1, -2).addComponent(this.jLabel1))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout2.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.stopCheckBox).addComponent(this.stopSpinner, -2, -1, -2).addComponent(this.jButton1)).addContainerGap(-1, Short.MAX_VALUE)));
    }

    private void loadValuesButtonActionPerformed(ActionEvent evt) {
        Quote q = this.market.getBestQuote_0();
        this.limitSpinner.setValue(this.market.getCurrency().round(q.getPrice()));
        this.setPrice();
    }

    private void limitSpinnerStateChanged(ChangeEvent evt) {
        this.setPrice();
    }

    private void volumeSpinnerStateChanged(ChangeEvent evt) {
        this.setPrice();
    }

    private void setVolButtonActionPerformed(ActionEvent evt) {
        Quote q = this.market.getBestQuote_0();
        if ((this.type & 1) == 0) {
            double l = this.getLimit();
            if (l < 1.0 / this.market.getAsset().getDf()) {
                l = 1.0 / this.market.getAsset().getDf();
            }
            this.volumeSpinner.setValue(this.market.getAsset().round(this.account.getCashAvailable() / l));
        }
        if (this.type == 1) {
            // empty if block
        }
        this.volumeSpinner.revalidate();
    }

    private void stopCheckBoxActionPerformed(ActionEvent evt) {
        this.stopSpinner.setEnabled(this.stopCheckBox.isSelected());
    }

    private void stopSpinnerStateChanged(ChangeEvent evt) {
    }

    private void limitCheckBoxActionPerformed(ActionEvent evt) {
        this.limitSpinner.setEnabled(this.limitCheckBox.isSelected());
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        Quote q = this.market.getBestQuote_0();
        this.stopSpinner.setValue(this.market.getCurrency().round(q.getPrice()));
    }

    private void leverageComboBoxActionPerformed(ActionEvent evt) {
        this.setPrice();
    }
}

