/*
 * Decompiled with CFR 0.152.
 */
package traders.ManualTrader;

import java.awt.Frame;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.ConcurrentHashMap;
import javafx.application.Platform;
import javafx.scene.media.Media;
import javafx.scene.media.MediaException;
import javafx.scene.media.MediaPlayer;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.LineEvent;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.UnsupportedAudioFileException;
import javax.swing.JDialog;
import org.json.JSONObject;
import sesim.Account;
import sesim.AutoTrader;
import sesim.AutoTraderBase;
import sesim.AutoTraderGui;
import sesim.Market;
import sesim.Order;
import sesim.Quote;
import sesim.Scheduler;
import sesim.Sim;
import traders.ManualTrader.ManTraderConsoleDialog;
import traders.ManualTrader.ManTraderGui;

public class ManTrader
extends AutoTraderBase
implements Market.AccountListener,
AutoTrader,
Market.QuoteReceiver {
    String soundFile = null;
    boolean marginTrading = false;
    int soundVolume = 50;
    public final ConcurrentHashMap<Long, Order> allOrders = new ConcurrentHashMap();
    ManTraderConsoleDialog consoleDialog = null;
    volatile Clip clip;
    private static MediaPlayer currentMediaPlayer;

    @Override
    public void init(Sim sim, long id, String name, long money, String strat, JSONObject cfg) {
        this.marginTrading = cfg.optBoolean("margin_account", false);
        super.init(sim, id, name, money, strat, cfg);
        this.getAccount().setListener(this);
    }

    @Override
    public void start() {
        this.account.setListener(this);
        this.market.addQuoteReceiver(this);
    }

    @Override
    public void processEvent(long t, Scheduler.Event e) {
    }

    @Override
    public String getDisplayName() {
        return "Human Trader";
    }

    @Override
    public AutoTraderGui getGui() {
        return new ManTraderGui(this);
    }

    @Override
    public long getMaxMargin() {
        if (this.marginTrading) {
            return 100L;
        }
        return 0L;
    }

    @Override
    public JSONObject getConfig() {
        JSONObject cfg = new JSONObject();
        cfg.put("sound_file", this.soundFile);
        cfg.put("margin_account", this.marginTrading);
        return cfg;
    }

    @Override
    public void setConfig(JSONObject cfg) {
        this.soundFile = cfg.optString("sound_file", null);
        this.marginTrading = cfg.optBoolean("margin_account", false);
    }

    @Override
    public boolean getDevelStatus() {
        return true;
    }

    @Override
    public JDialog getGuiConsole(Frame parent) {
        if (this.consoleDialog != null) {
            return this.consoleDialog;
        }
        this.consoleDialog = new ManTraderConsoleDialog(parent, false, this.market, this.account, this);
        this.consoleDialog.init(this.market, this.account);
        this.consoleDialog.doUpdate(this.account, this);
        this.consoleDialog.setLocationRelativeTo(parent);
        this.consoleDialog.pack();
        this.consoleDialog.setMinimumSize(this.consoleDialog.getSize());
        this.consoleDialog.setTitle(this.account.getOwner().getName() + " - Trading Console");
        return this.consoleDialog;
    }

    @Override
    public void stop() {
        if (this.consoleDialog != null) {
            this.consoleDialog.dispose();
        }
    }

    public void startSoundAsynchronously(String filePath) {
        Thread soundThread = new Thread(() -> {
            try {
                if (this.clip != null) {
                    this.clip.stop();
                    while (this.clip.isRunning()) {
                        Thread.sleep(5L);
                    }
                }
                Thread.sleep(50L);
                this.clip = null;
                File soundFile = new File(filePath);
                AudioInputStream audioIn = AudioSystem.getAudioInputStream(soundFile);
                this.clip = AudioSystem.getClip();
                if (this.clip.isControlSupported(FloatControl.Type.MASTER_GAIN)) {
                    FloatControl gainControl = (FloatControl)this.clip.getControl(FloatControl.Type.MASTER_GAIN);
                    gainControl.setValue(-85.0f);
                }
                this.clip.addLineListener(event -> {
                    if (event.getType() == LineEvent.Type.STOP) {
                        this.clip.close();
                    }
                });
                this.clip.open(audioIn);
                this.clip.start();
                while (this.clip.isRunning()) {
                    Thread.sleep(100L);
                }
            }
            catch (IOException | LineUnavailableException | UnsupportedAudioFileException e) {
                System.err.println("Fehler beim Laden/\u00d6ffnen des Sounds: " + e.getMessage());
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                System.err.println("Sound-Thread unterbrochen.");
            }
        });
        soundThread.start();
    }

    @Override
    public void accountUpdated(Account a, Order o) {
        this.allOrders.put(o.getID(), o);
        if (o.getStatus() == 4 && this.soundFile != null && this.soundFile.length() > 0) {
            ManTrader.startSoundFX(this.soundFile);
        }
        if (this.consoleDialog == null) {
            return;
        }
        if (o.getStatus() == 4) {
            // empty if block
        }
        this.consoleDialog.doUpdate(a, this);
    }

    public static void startSoundFX(String filePath) {
        if (currentMediaPlayer != null) {
            currentMediaPlayer.stop();
            currentMediaPlayer.dispose();
            currentMediaPlayer = null;
        }
        try {
            Platform.runLater(() -> {
                try {
                    File file = new File(filePath);
                    Media sound = new Media(file.toURI().toString());
                    MediaPlayer player = new MediaPlayer(sound);
                    player.setVolume(0.5);
                    currentMediaPlayer = player;
                    player.setOnEndOfMedia(() -> {
                        player.dispose();
                        if (currentMediaPlayer == player) {
                            currentMediaPlayer = null;
                        }
                    });
                    player.play();
                }
                catch (MediaException me) {
                    System.out.println("Fehler im JavaFX-Thread beim Erstellen des Players: " + me.getMessage());
                }
                catch (Exception e) {
                    System.out.println("Unerwarteter Fehler im JavaFX-Thread: " + e.getMessage());
                }
            });
        }
        catch (Exception e) {
            System.out.println("Fehler beim Abspielen des JavaFX Sounds: " + e.getMessage());
        }
    }

    @Override
    public void UpdateQuote(Quote q) {
        if (this.consoleDialog == null) {
            return;
        }
        this.consoleDialog.doUpdate(this.account, this);
    }
}

