/*
 * Decompiled with CFR 0.152.
 */
package traders.ManualTrader;

import gui.OpenOrdersList;
import gui.PositionsListPanel;
import gui.util.UpdateExecutor;
import java.awt.Color;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collections;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import sesim.Account;
import sesim.Market;
import sesim.Order;
import sesim.Quote;
import traders.ManualTrader.AccountBalance;
import traders.ManualTrader.EditOrderPanel;
import traders.ManualTrader.ManTrader;
import traders.ManualTrader.ModifyOrderDialog;

public class ManTraderConsolePanel
extends JPanel
implements Market.QuoteReceiver {
    public ManTrader trader;
    Account account;
    Market market;
    UpdateExecutor executor = new UpdateExecutor();
    private AccountBalance accountBalance2;
    private JButton buyButton;
    private EditOrderPanel buyEditOrderPanel;
    private OpenOrdersList closedOrderList;
    private JPopupMenu ctxMenu;
    private JMenuItem ctxMenuCancelOrder;
    private JMenuItem ctxMenuCreateBuyOrder;
    private JMenuItem ctxMenuCreateSellOrder;
    private JMenuItem ctxMenuModifyOder;
    private JPanel orderPanel;
    private JTabbedPane orderTabs;
    private OpenOrdersList ordersList;
    private PositionsListPanel positionList;
    private JButton sellButton;
    private EditOrderPanel sellEditOrderPanel;
    private JPanel tradingPanel;

    public OpenOrdersList getOrderListPanel() {
        return this.ordersList;
    }

    public ManTraderConsolePanel() {
        this.initComponents();
    }

    public ManTraderConsolePanel(final Market m, Account a) {
        this.account = a;
        this.market = m;
        this.initComponents();
        this.ordersList.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                if (evt.getClickCount() == 2 && !evt.isConsumed()) {
                    evt.consume();
                    Window parentWindow = SwingUtilities.getWindowAncestor(ManTraderConsolePanel.this);
                    Frame parentFrame = parentWindow instanceof Frame ? (Frame)parentWindow : null;
                    Point point = evt.getPoint();
                    int currentRow = ((ManTraderConsolePanel)ManTraderConsolePanel.this).ordersList.table.rowAtPoint(point);
                    if (currentRow != -1) {
                        ((ManTraderConsolePanel)ManTraderConsolePanel.this).ordersList.table.setRowSelectionInterval(currentRow, currentRow);
                        Long oid = (Long)((ManTraderConsolePanel)ManTraderConsolePanel.this).ordersList.table.getModel().getValueAt(currentRow, 0);
                        Order o = ManTraderConsolePanel.this.account.getOrderByID(oid);
                        ModifyOrderDialog d = new ModifyOrderDialog(parentFrame, true, m, o);
                        d.setLocationRelativeTo(parentWindow);
                        d.setVisible(true);
                    }
                }
            }
        });
        this.buyEditOrderPanel.addChangeListeners(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ManTraderConsolePanel.this.updateBuyButton();
                ManTraderConsolePanel.this.updateSellButton();
            }
        });
        this.sellEditOrderPanel.addChangeListeners(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ManTraderConsolePanel.this.updateBuyButton();
                ManTraderConsolePanel.this.updateSellButton();
            }
        });
    }

    private boolean updateBuyButton() {
        double vol = this.buyEditOrderPanel.getVolume();
        double limit = this.buyEditOrderPanel.getLimit();
        byte type = this.buyEditOrderPanel.getOrderType();
        int leverage = this.buyEditOrderPanel.getLeverage();
        boolean b = this.account.isOrderCovered(this.market, type, vol, limit, leverage, -1L);
        this.buyButton.setEnabled(b);
        return b;
    }

    private boolean updateSellButton() {
        double vol = this.sellEditOrderPanel.getVolume();
        double limit = this.sellEditOrderPanel.getLimit();
        byte type = this.sellEditOrderPanel.getOrderType();
        int leverage = this.buyEditOrderPanel.getLeverage();
        boolean b = this.account.isOrderCovered(this.market, type, -vol, limit, leverage, -1L);
        this.sellButton.setEnabled(b);
        return b;
    }

    void init(Account a, ManTrader mt) {
        this.positionList.setPositionList(this.account.getPositions());
        this.ordersList.setOrderList(this.account.getOrders());
        this.closedOrderList.setOrderList(Collections.unmodifiableMap(mt.allOrders));
    }

    void doUpdate(Account a, ManTrader mt) {
        this.ordersList.updateModel();
        this.positionList.updateModel();
        this.closedOrderList.updateModel();
        this.accountBalance2.updateBalance(a);
        this.updateBuyButton();
        this.updateSellButton();
    }

    private void initComponents() {
        this.ctxMenu = new JPopupMenu();
        this.ctxMenuCreateBuyOrder = new JMenuItem();
        this.ctxMenuCreateSellOrder = new JMenuItem();
        this.ctxMenuCancelOrder = new JMenuItem();
        this.ctxMenuModifyOder = new JMenuItem();
        this.orderPanel = new JPanel();
        this.orderTabs = new JTabbedPane();
        this.positionList = new PositionsListPanel();
        this.ordersList = new OpenOrdersList();
        this.closedOrderList = new OpenOrdersList();
        this.tradingPanel = new JPanel();
        this.sellButton = new JButton();
        this.sellEditOrderPanel = new EditOrderPanel(this.market, this.account, 1);
        this.buyEditOrderPanel = new EditOrderPanel(this.market, this.account, 0);
        this.buyButton = new JButton();
        this.accountBalance2 = new AccountBalance();
        this.ctxMenuCreateBuyOrder.setText("Create Buy Order");
        this.ctxMenuCreateBuyOrder.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ManTraderConsolePanel.this.ctxMenuCreateBuyOrderActionPerformed(evt);
            }
        });
        this.ctxMenu.add(this.ctxMenuCreateBuyOrder);
        this.ctxMenuCreateSellOrder.setText("Create Sell Order");
        this.ctxMenuCreateSellOrder.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ManTraderConsolePanel.this.ctxMenuCreateSellOrderActionPerformed(evt);
            }
        });
        this.ctxMenu.add(this.ctxMenuCreateSellOrder);
        this.ctxMenuCancelOrder.setText("Cancel Order");
        this.ctxMenuCancelOrder.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ManTraderConsolePanel.this.ctxMenuCancelOrderActionPerformed(evt);
            }
        });
        this.ctxMenu.add(this.ctxMenuCancelOrder);
        this.ctxMenuModifyOder.setText("Modify Oder");
        this.ctxMenu.add(this.ctxMenuModifyOder);
        this.orderTabs.addTab("Positions", this.positionList);
        this.orderTabs.addTab("Open Orders", this.ordersList);
        this.orderTabs.addTab("All Orders", this.closedOrderList);
        GroupLayout orderPanelLayout = new GroupLayout(this.orderPanel);
        this.orderPanel.setLayout(orderPanelLayout);
        orderPanelLayout.setHorizontalGroup(orderPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(orderPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.orderTabs).addContainerGap()));
        orderPanelLayout.setVerticalGroup(orderPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, orderPanelLayout.createSequentialGroup().addContainerGap().addComponent(this.orderTabs, -1, 237, Short.MAX_VALUE).addContainerGap()));
        this.sellButton.setBackground(new Color(255, 153, 153));
        this.sellButton.setText("Sell");
        this.sellButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ManTraderConsolePanel.this.sellButtonActionPerformed(evt);
            }
        });
        this.buyButton.setBackground(new Color(153, 255, 153));
        this.buyButton.setText("Buy");
        this.buyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ManTraderConsolePanel.this.buyButtonActionPerformed(evt);
            }
        });
        GroupLayout tradingPanelLayout = new GroupLayout(this.tradingPanel);
        this.tradingPanel.setLayout(tradingPanelLayout);
        tradingPanelLayout.setHorizontalGroup(tradingPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(tradingPanelLayout.createSequentialGroup().addContainerGap(38, Short.MAX_VALUE).addGroup(tradingPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.sellEditOrderPanel, -1, -1, Short.MAX_VALUE).addComponent(this.buyEditOrderPanel, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(tradingPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.buyButton, -1, 98, Short.MAX_VALUE).addComponent(this.sellButton, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        tradingPanelLayout.setVerticalGroup(tradingPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(tradingPanelLayout.createSequentialGroup().addContainerGap().addGroup(tradingPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.buyEditOrderPanel, -1, -1, Short.MAX_VALUE).addComponent(this.buyButton, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(tradingPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.sellEditOrderPanel, -1, -1, Short.MAX_VALUE).addComponent(this.sellButton, -1, -1, Short.MAX_VALUE)).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout layout2 = new GroupLayout(this);
        this.setLayout(layout2);
        layout2.setHorizontalGroup(layout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout2.createSequentialGroup().addContainerGap().addGroup(layout2.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.orderPanel, -1, -1, Short.MAX_VALUE).addGroup(layout2.createSequentialGroup().addGap(6, 6, 6).addComponent(this.accountBalance2, -2, 292, -2).addGap(18, 18, 18).addComponent(this.tradingPanel, -2, -1, -2).addContainerGap()))));
        layout2.setVerticalGroup(layout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout2.createSequentialGroup().addGap(4, 4, 4).addComponent(this.orderPanel, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout2.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.tradingPanel, -1, -1, Short.MAX_VALUE).addGroup(layout2.createSequentialGroup().addComponent(this.accountBalance2, -2, -1, -2).addGap(0, 0, Short.MAX_VALUE)))));
    }

    private void buyButtonActionPerformed(ActionEvent evt) {
        double vol = this.buyEditOrderPanel.getVolume();
        double limit = this.buyEditOrderPanel.getLimit();
        double stop = this.buyEditOrderPanel.getStop();
        byte type = this.buyEditOrderPanel.getOrderType();
        int leverage = this.buyEditOrderPanel.getLeverage();
        double cash = this.account.getRequiredCashForOrder(this.market, vol, limit, leverage);
        Order o = this.market.createOrder(this.account, type, vol, limit, stop, leverage);
        this.updateBuyButton();
    }

    private void sellButtonActionPerformed(ActionEvent evt) {
        double vol = this.sellEditOrderPanel.getVolume();
        double limit = this.sellEditOrderPanel.getLimit();
        double stop = this.sellEditOrderPanel.getStop();
        byte type = this.sellEditOrderPanel.getOrderType();
        int leverage = this.sellEditOrderPanel.getLeverage();
        double cash = this.account.getRequiredCashForOrder(this.market, -vol, limit, leverage);
        Order o = this.market.createOrder(this.account, type, vol, limit, stop, leverage);
        this.updateSellButton();
    }

    private void ctxMenuCreateBuyOrderActionPerformed(ActionEvent evt) {
    }

    private void ctxMenuCreateSellOrderActionPerformed(ActionEvent evt) {
    }

    private void ctxMenuCancelOrderActionPerformed(ActionEvent evt) {
    }

    private void ordersListMousePressed(MouseEvent evt) {
    }

    @Override
    public void UpdateQuote(Quote q) {
    }
}

