/*
 * Decompiled with CFR 0.152.
 */
package traders.MarginTraderL;

import org.json.JSONObject;
import sesim.Account;
import sesim.AutoTraderBase;
import sesim.AutoTraderGui;
import sesim.Market;
import sesim.Order;
import sesim.Scheduler;
import sesim.Sim;
import sesim.util.FixedPoint;
import sesim.util.SeSimMath;
import traders.MarginTraderL.MarginTraderGui;

public class MarginTraderL
extends AutoTraderBase
implements Market.AccountListener {
    private final Scheduler.Event NEXTTRADE = new Scheduler.Event(this);
    private final Scheduler.Event FILLTIMEOUT = new Scheduler.Event(this);
    Order currentOrder = null;
    long waitForFill = 0L;
    private boolean isOpening = false;
    Config cfg = new Config();

    @Override
    public void start() {
        this.account.setListener(this);
        long initialDelay = Sim.random.nextLong(this.cfg.initialDelay + 1L) + Sim.random.nextLong(this.cfg.initialDelayRange + 1L);
        this.setStatus("Delay: %.1f", Float.valueOf((float)initialDelay / 1000.0f));
        this.sim.addEvent(this.sim.getCurrentTimeMillis() + initialDelay, this.NEXTTRADE);
    }

    @Override
    public void processEvent(long time, Scheduler.Event e) {
        if (this.account.isLiquidated()) {
            this.setStatus("Ruined/Liquidated", new Object[0]);
            return;
        }
        if (e == this.NEXTTRADE) {
            this.nextTrade();
        }
        if (e == this.FILLTIMEOUT) {
            this.fillTimeout();
        }
    }

    private void openTrade() {
        long limit;
        byte type;
        long freeMarginUsage = Sim.random.nextLong(this.cfg.minFreeMarginUsage, this.cfg.maxFreeMarginUsage + 1L);
        long margin = this.account.getFreeMargin_Long() * freeMarginUsage / 1000L;
        long price = this.sim.getDefaultMarket().getLastPrice_Long();
        if (Sim.random.nextBoolean()) {
            type = 0;
            limit = MarginTraderL.getRandomPrice_Long(price, this.cfg.minLongLimit, this.cfg.maxLongLimit, this.cfg.minLongDeviation);
        } else {
            type = 1;
            limit = MarginTraderL.getRandomPrice_Long(price, this.cfg.minShortLimit, this.cfg.maxShortLimit, this.cfg.minShortDeviation);
        }
        long volume2 = FixedPoint.floorDivide(margin * (long)this.cfg.leverage, limit);
        this.submitTrade(type, volume2, limit);
        this.setStatus("Open %s- vol:%d", type == 1 ? "Short" : "Long", volume2);
        this.isOpening = true;
    }

    void closeTrade(long volume2) {
        long limit;
        byte type;
        long price = this.sim.getDefaultMarket().getBestQuote_0().getPrice_Long();
        if (volume2 < 0L) {
            type = 0;
            limit = MarginTraderL.getRandomPrice_Long(price, this.cfg.minLongLimit, this.cfg.maxLongLimit, this.cfg.minLongDeviation);
        } else {
            type = 1;
            limit = MarginTraderL.getRandomPrice_Long(price, this.cfg.minShortLimit, this.cfg.maxShortLimit, this.cfg.minShortDeviation);
        }
        this.isOpening = false;
        this.submitTrade(type, Math.abs(volume2), limit);
        this.setStatus("Close %s, vol:%d", type == 1 ? "Long" : "Short", volume2);
    }

    void nextTrade() {
        long shares = this.account.getPosition(this.sim.getDefaultMarket()).getShares_Long();
        if (shares == 0L) {
            this.openTrade();
        } else {
            this.closeTrade(shares);
        }
    }

    void submitTrade(byte type, long volume2, long limit) {
        this.waitForFill = this.sim.getCurrentTimeMillis() + this.cfg.waitForFill + Sim.random.nextLong(this.cfg.waitForFillRange + 1L);
        this.sim.addEvent(this.waitForFill, this.FILLTIMEOUT);
        this.currentOrder = this.sim.getDefaultMarket().createOrder_Long(this.account, (byte)(type | 2), volume2, limit, 0L, this.cfg.leverage);
    }

    void fillTimeout() {
        if (this.currentOrder != null) {
            this.currentOrder.getMarket().cancelOrder(this.account, this.currentOrder.id);
            this.currentOrder = null;
        }
        this.hold();
    }

    void hold() {
        long shares = this.account.getPosition(this.sim.getDefaultMarket()).getShares_Long();
        if (this.isOpening) {
            if (shares == 0L) {
                long c = this.cfg.coolDownTime + Sim.random.nextLong(this.cfg.coolDownTimeRange + 1L);
                this.sim.addEvent(this.sim.getCurrentTimeMillis() + c, this.NEXTTRADE);
                this.setStatus("Cool Down %.1f", Float.valueOf((float)c / 1000.0f));
                return;
            }
            if (shares < 0L) {
                long c = this.cfg.holdShortPositionTime + Sim.random.nextLong(this.cfg.holdShortPositionTimeRange + 1L);
                this.sim.addEvent(this.sim.getCurrentTimeMillis() + c, this.NEXTTRADE);
                this.setStatus("Hold Short %.1f", Float.valueOf((float)c / 1000.0f));
                return;
            }
            long c = this.cfg.holdLongPositionTime + Sim.random.nextLong(this.cfg.holdLongPositionTimeRange + 1L);
            this.sim.addEvent(this.sim.getCurrentTimeMillis() + c, this.NEXTTRADE);
            this.setStatus("Hold Long %.1f", Float.valueOf((float)c / 1000.0f));
            return;
        }
        long c = this.cfg.coolDownTime + Sim.random.nextLong(this.cfg.coolDownTimeRange + 1L);
        this.sim.addEvent(this.sim.getCurrentTimeMillis() + c, this.NEXTTRADE);
        this.setStatus("Cool Down %.1f", Float.valueOf((float)c / 1000.0f));
    }

    @Override
    public void accountUpdated(Account a, Order o) {
        if (o.getStatus() != 4) {
            return;
        }
        this.currentOrder = null;
        this.sim.delEvent(this.waitForFill, this.FILLTIMEOUT);
        this.hold();
    }

    @Override
    public String getDisplayName() {
        return "MarginTrader L";
    }

    @Override
    public JSONObject getConfig() {
        JSONObject cfg = new JSONObject();
        cfg.put("initial_delay", (double)this.cfg.initialDelay / 1000.0);
        cfg.put("initial_delay_range", (double)this.cfg.initialDelayRange / 1000.0);
        cfg.put("min_short_limit", (double)this.cfg.minShortLimit / 100.0);
        cfg.put("max_short_limit", (double)this.cfg.maxShortLimit / 100.0);
        cfg.put("min_long_limit", (double)this.cfg.minLongLimit / 100.0);
        cfg.put("max_long_limit", (double)this.cfg.maxLongLimit / 100.0);
        cfg.put("wait_for_fill", (double)this.cfg.waitForFill / 1000.0);
        cfg.put("wait_for_fill_range", (double)this.cfg.waitForFillRange / 1000.0);
        cfg.put("hold_short_position_time", (double)this.cfg.holdShortPositionTime / 1000.0);
        cfg.put("hold_short_position_time_range", (double)this.cfg.holdShortPositionTimeRange / 1000.0);
        cfg.put("hold_long_position_time", (double)this.cfg.holdLongPositionTime / 1000.0);
        cfg.put("hold_long_position_time_range", (double)this.cfg.holdLongPositionTimeRange / 1000.0);
        cfg.put("cool_down_time", (double)this.cfg.coolDownTime / 1000.0);
        cfg.put("cool_down_time_range", (double)this.cfg.coolDownTimeRange / 1000.0);
        cfg.put("leverage", this.cfg.leverage);
        return cfg;
    }

    @Override
    public void setConfig(JSONObject cfg) {
        this.cfg.initialDelay = (long)(1000.0 * cfg.optDouble("initial_delay", 0.0));
        this.cfg.initialDelayRange = (long)(1000.0 * cfg.optDouble("initial_delay_range", 10.0));
        this.cfg.minShortLimit = SeSimMath.toFixedLong(cfg.optDouble("min_short_limit", -2.0), 100.0);
        this.cfg.maxShortLimit = SeSimMath.toFixedLong(cfg.optDouble("max_short_limit", 2.0), 100.0);
        this.cfg.minLongLimit = SeSimMath.toFixedLong(cfg.optDouble("min_long_limit", -2.0), 100.0);
        this.cfg.maxLongLimit = SeSimMath.toFixedLong(cfg.optDouble("max_long_limit", 2.0), 100.0);
        this.cfg.waitForFill = SeSimMath.toFixedLong(cfg.optDouble("wait_for_fill", 10.0), 1000.0);
        this.cfg.waitForFillRange = SeSimMath.toFixedLong(cfg.optDouble("wait_for_fill_range", 10.0), 1000.0);
        this.cfg.holdShortPositionTime = SeSimMath.toFixedLong(cfg.optDouble("hold_short_position_time", 60.0), 1000.0);
        this.cfg.holdShortPositionTimeRange = SeSimMath.toFixedLong(cfg.optDouble("hold_short_position_time_range", 120.0), 1000.0);
        this.cfg.holdLongPositionTime = SeSimMath.toFixedLong(cfg.optDouble("hold_long_position_time", 60.0), 1000.0);
        this.cfg.holdLongPositionTimeRange = SeSimMath.toFixedLong(cfg.optDouble("hold_long_position_time_range", 120.0), 1000.0);
        this.cfg.coolDownTime = SeSimMath.toFixedLong(cfg.optDouble("cool_down_time", 30.0), 1000.0);
        this.cfg.coolDownTimeRange = SeSimMath.toFixedLong(cfg.optDouble("cool_down_time_range", 60.0), 1000.0);
        this.cfg.leverage = cfg.optInt("leverage", 50);
    }

    @Override
    public AutoTraderGui getGui() {
        return new MarginTraderGui(this.cfg);
    }

    @Override
    public long getMaxMargin() {
        return 100L;
    }

    class Config {
        long initialDelay = 0L;
        long initialDelayRange = 60000L;
        int leverage = 50;
        long minFreeMarginUsage = 500L;
        long maxFreeMarginUsage = 500L;
        long minShortLimit = -200L;
        long maxShortLimit = 200L;
        long minLongDeviation = 1L;
        long minLongLimit = -200L;
        long maxLongLimit = 200L;
        long minShortDeviation = 1L;
        long waitForFill = 60000L;
        long waitForFillRange = 60000L;
        long holdLongPositionTime = 30000L;
        long holdLongPositionTimeRange = 120000L;
        long holdShortPositionTime = 30000L;
        long holdShortPositionTimeRange = 120000L;
        long coolDownTime = 3000L;
        long coolDownTimeRange = 60000L;

        Config() {
        }
    }
}

