/*
 * Decompiled with CFR 0.152.
 */
package traders.MarketMaker;

import org.json.JSONObject;
import sesim.AutoTraderBase;
import sesim.AutoTraderGui;
import sesim.Order;
import sesim.Scheduler;
import traders.MarketMaker.MarkeMakerGui;

public class MarketMaker
extends AutoTraderBase {
    int numPositions = 15;
    double timerInterval = 3.0;
    double depthPercent = 8.0;
    double cashToUse = 50.0;
    int interval = 1000;
    private MMOrder[] orders;
    private Scheduler.Event TIMEREVENT;
    Order resetOrder = null;

    @Override
    public void start() {
        this.initOrders();
        this.TIMEREVENT = new Scheduler.Event(this);
        this.sim.addEvent(this.sim.getCurrentTimeMillis() + (long)((double)this.interval * this.timerInterval), this.TIMEREVENT);
    }

    private void initOrders() {
        double centerPrice = this.market.getLastPrice();
        double lowestPrice = centerPrice - this.depthPercent * centerPrice / 100.0;
        this.orders = new MMOrder[this.numPositions];
        double dist = (centerPrice - lowestPrice) / (double)(this.numPositions + 1);
        double cashPerBuyOrder = this.account.getMoney() * (this.cashToUse / 100.0) / (double)(this.numPositions + 1);
        double price = lowestPrice + dist;
        for (int i = 0; i < this.numPositions; ++i) {
            this.orders[i] = new MMOrder();
            this.orders[i].buyLimit = this.market.getCurrency().round(price);
            this.orders[i].sellLimit = this.market.getCurrency().round(price += dist);
            this.orders[i].volume = this.market.getAsset().round(cashPerBuyOrder / price);
            this.orders[i].o = this.market.createOrder(this.account, (byte)2, this.orders[i].volume, this.orders[i].buyLimit, 0.0);
        }
        this.setStatus("%s - %s", this.market.getCurrency().getFormatter().format(lowestPrice), this.market.getCurrency().getFormatter().format(centerPrice));
    }

    private void flipOrders() {
        for (int i = 0; i < this.numPositions; ++i) {
            Order n;
            Order o = this.orders[i].o;
            if (this.orders[i].o == null || o.getStatus() != 4) continue;
            if (o.getType() == 3) {
                n = this.market.createOrder(this.account, (byte)2, this.orders[i].volume, this.orders[i].buyLimit, 0.0);
                if (n == null) continue;
                this.orders[i].o = n;
                continue;
            }
            n = this.market.createOrder(this.account, (byte)3, this.orders[i].volume, this.orders[i].sellLimit, 0.0);
            if (n == null) continue;
            this.orders[i].o = n;
        }
    }

    private boolean readjustOrders() {
        double price = this.market.getLastPrice();
        if (price <= this.orders[this.numPositions - 1].sellLimit && price >= this.orders[0].buyLimit) {
            return false;
        }
        for (int i = 0; i < this.numPositions; ++i) {
            if (this.orders[i].o == null) continue;
            this.market.cancelOrder(this.account, this.orders[i].o.getID());
        }
        this.resetTrader();
        return true;
    }

    void resetTrader() {
        this.setStatus("Reset", new Object[0]);
        if (this.account.getPosition(this.sim.getDefaultMarket()).getShares() == 0.0) {
            this.initOrders();
            return;
        }
        this.resetOrder = this.market.createOrder_Long(this.account, (byte)1, this.account.getShares_Long(this.sim.getDefaultMarket()), 0L, 0L, 1);
    }

    @Override
    public void processEvent(long time, Scheduler.Event e) {
        if (this.resetOrder != null) {
            if (this.resetOrder.getStatus() != 4) {
                this.sim.addEvent(this.sim.getCurrentTimeMillis() + (long)((double)this.interval * this.timerInterval), this.TIMEREVENT);
                return;
            }
            this.resetOrder = null;
            this.initOrders();
        }
        if (!this.readjustOrders()) {
            this.flipOrders();
        }
        this.sim.addEvent(this.sim.getCurrentTimeMillis() + (long)((double)this.interval * this.timerInterval), this.TIMEREVENT);
    }

    @Override
    public boolean getDevelStatus() {
        return true;
    }

    @Override
    public String getDisplayName() {
        return "Market Maker";
    }

    @Override
    public AutoTraderGui getGui() {
        return new MarkeMakerGui(this);
    }

    @Override
    public JSONObject getConfig() {
        JSONObject cfg = new JSONObject();
        cfg.put("num_positions", this.numPositions);
        cfg.put("timer_interval", this.timerInterval);
        cfg.put("depth_percent", this.depthPercent);
        cfg.put("cash_to_use", this.cashToUse);
        return cfg;
    }

    @Override
    public void setConfig(JSONObject cfg) {
        this.numPositions = cfg.optInt("num_positions", 16);
        this.timerInterval = cfg.optDouble("timer_interval", 3.0);
        this.depthPercent = cfg.optDouble("depth_percent", 8.0);
        this.cashToUse = cfg.optDouble("cash_to_use", 50.0);
    }

    class MMOrder {
        Order o = null;
        double buyLimit;
        double sellLimit;
        double volume;

        MMOrder() {
        }
    }
}

